/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.release;

import com.atlassian.performance.tools.SigningKeyInformationTask;
import com.atlassian.performance.tools.release.PublishingConfigurator;
import com.atlassian.performance.tools.release.javadoc.Javadoc;
import com.atlassian.performance.tools.release.repositories.PublishingRepositories;
import com.atlassian.performance.tools.release.source.Source;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.CopySpec;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.kotlin.dsl.ExtensionContainerExtensionsKt;
import org.gradle.kotlin.dsl.ExtraPropertiesExtensionsKt;
import org.gradle.kotlin.dsl.support.ExceptionsKt;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.jetbrains.annotations.NotNull;
import pl.allegro.tech.build.axion.release.domain.RepositoryConfig;
import pl.allegro.tech.build.axion.release.domain.VersionConfig;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\bH\u0002J\f\u0010\u0012\u001a\u00020\b*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/release/PublishingConfigurator;", "", "project", "Lorg/gradle/api/Project;", "scmVersion", "Lpl/allegro/tech/build/axion/release/domain/VersionConfig;", "(Lorg/gradle/api/Project;Lpl/allegro/tech/build/axion/release/domain/VersionConfig;)V", "configurePublishing", "", "publishingRepositories", "Lcom/atlassian/performance/tools/release/repositories/PublishingRepositories;", "component", "Lorg/gradle/api/component/SoftwareComponent;", "source", "Lcom/atlassian/performance/tools/release/source/Source;", "javadoc", "Lcom/atlassian/performance/tools/release/javadoc/Javadoc;", "includePom", "includeScm", "Lorg/gradle/api/publish/maven/MavenPomScm;", "gradle-release"})
public final class PublishingConfigurator {
    private final Project project;
    private final VersionConfig scmVersion;

    public final void configurePublishing(@NotNull PublishingRepositories publishingRepositories, @NotNull SoftwareComponent component, @NotNull Source source, @NotNull Javadoc javadoc) {
        Set signMavenJavaPublication;
        Intrinsics.checkParameterIsNotNull((Object)publishingRepositories, (String)"publishingRepositories");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)javadoc, (String)"javadoc");
        this.project.getPlugins().apply("org.gradle.maven-publish");
        ExtensionContainer extensionContainer = this.project.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.extensions");
        Object object = ExtensionContainerExtensionsKt.get((ExtensionContainer)extensionContainer, (String)"publishing");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.publish.PublishingExtension");
        }
        PublishingExtension publishing = (PublishingExtension)object;
        publishing.getPublications().register("mavenJava", MavenPublication.class, new Action<U>(this, component, source, javadoc){
            final /* synthetic */ PublishingConfigurator this$0;
            final /* synthetic */ SoftwareComponent $component;
            final /* synthetic */ Source $source;
            final /* synthetic */ Javadoc $javadoc;

            public final void execute(@NotNull MavenPublication $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.pom((Action)new Action<MavenPom>(this){
                    final /* synthetic */ configurePublishing.1 this$0;

                    public final void execute(@NotNull MavenPom $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        $receiver.scm((Action)new Action<MavenPomScm>(this){
                            final /* synthetic */ configurePublishing.1 this$0;

                            public final void execute(@NotNull MavenPomScm $receiver) {
                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                PublishingConfigurator.access$includeScm(this.this$0.this$0.this$0, $receiver);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        $receiver.licenses((Action)configurePublishing.2.INSTANCE);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                $receiver.from(this.$component);
                $receiver.artifact((Object)this.$source.getJar());
                $receiver.artifact((Object)this.$javadoc.getJar());
            }
            {
                this.this$0 = publishingConfigurator;
                this.$component = softwareComponent;
                this.$source = source;
                this.$javadoc = javadoc;
            }
        });
        SigningExtension signingExtension = new SigningExtension(this.project);
        signingExtension.sign((DomainObjectCollection)publishing.getPublications());
        SigningKeyInformationTask gatherKeyInformation = (SigningKeyInformationTask)this.project.getTasks().create("gatherKeyInformation", SigningKeyInformationTask.class);
        gatherKeyInformation.setGroup("Release");
        gatherKeyInformation.setDescription("Gathers key information");
        Set set = signMavenJavaPublication = this.project.getTasksByName("signMavenJavaPublication", false);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"signMavenJavaPublication");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            Task it = (Task)element$iv;
            it.dependsOn(new Object[]{gatherKeyInformation});
        }
        this.project.getTasks().withType(Sign.class, new Action<S>(gatherKeyInformation){
            final /* synthetic */ SigningKeyInformationTask $gatherKeyInformation;

            public final void execute(@NotNull Sign $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.onlyIf((Spec)new Spec<Task>(this, $receiver){
                    final /* synthetic */ configurePublishing.3 this$0;
                    final /* synthetic */ Sign receiver$0;

                    public final boolean isSatisfiedBy(Task it) {
                        Project project = this.receiver$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        return ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)project)).has(this.this$0.$gatherKeyInformation.getSigningKeyId());
                    }
                    {
                        this.this$0 = var1_1;
                        this.receiver$0 = sign;
                    }
                });
            }
            {
                this.$gatherKeyInformation = signingKeyInformationTask;
            }
        });
        this.includePom();
        String string = this.scmVersion.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scmVersion.version");
        if (!StringsKt.endsWith$default((String)string, (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            publishing.getRepositories().add(publishingRepositories.getMain());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void includeScm(@NotNull MavenPomScm $receiver) {
        Object object;
        RepositoryConfig repositoryConfig = this.scmVersion.getRepository();
        Intrinsics.checkExpressionValueIsNotNull((Object)repositoryConfig, (String)"scmVersion\n            .repository");
        File file = repositoryConfig.getDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scmVersion\n            .\u2026ry\n            .directory");
        Object object2 = FilesKt.resolve((File)file, (String)".git");
        File it = object2;
        File file2 = it.exists() ? it : null;
        if (file2 != null && (file2 = Git.open((File)(it = (object2 = file2)))) != null) {
            object2 = (AutoCloseable)((Object)file2);
            Throwable throwable = null;
            try {
                Object object3;
                Object v5;
                block17: {
                    void $receiver$iv;
                    Git repo = (Git)object2;
                    List list = repo.remoteList().call();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"repo\n                   \u2026                  .call()");
                    Iterable iterable = list;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $receiver$iv) {
                        RemoteConfig it2;
                        RemoteConfig remoteConfig = it2 = (RemoteConfig)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)remoteConfig, (String)"it");
                        if (!Intrinsics.areEqual((Object)remoteConfig.getName(), (Object)"origin")) continue;
                        if (found$iv) {
                            v5 = null;
                            break block17;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v5 = !found$iv ? null : single$iv;
                }
                String string = (object3 = (RemoteConfig)v5) != null && (object3 = object3.getURIs()) != null && (object3 = (URIish)CollectionsKt.single((List)object3)) != null ? object3.getHost() : null;
                object = string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
            }
        }
        object = null;
        Throwable remoteHost = object;
        String projectName = this.project.getName();
        Throwable throwable = remoteHost;
        if (throwable != null) {
            switch (throwable) {
                case "bitbucket.org": {
                    $receiver.getUrl().set((Object)("https://bitbucket.org/atlassian/" + projectName));
                    $receiver.getConnection().set((Object)("scm:git:git@bitbucket.org:atlassian/" + projectName + ".git"));
                    $receiver.getDeveloperConnection().set((Object)("scm:git:git@bitbucket.org:atlassian/" + projectName + ".git"));
                    break;
                }
                case "github.com": {
                    $receiver.getUrl().set((Object)("https://github.com/atlassian/" + projectName));
                    $receiver.getConnection().set((Object)("scm:git:git@github.com:atlassian/" + projectName + ".git"));
                    $receiver.getDeveloperConnection().set((Object)("scm:git:git@github.com:atlassian/" + projectName + ".git"));
                    break;
                }
                default: {
                    throw (Throwable)new Exception("Cannot infer POM SCM section from " + (String)((Object)remoteHost));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void includePom() {
        Jar jar;
        void $receiver$iv;
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"project.tasks");
        NamedDomainObjectCollection namedDomainObjectCollection = (NamedDomainObjectCollection)taskContainer;
        String name$iv = "jar";
        void $receiver$iv$iv = $receiver$iv;
        Object object = $receiver$iv$iv.getByName(name$iv);
        Object it$iv$iv = object;
        Object object2 = it$iv$iv;
        if (!(object2 instanceof Jar)) {
            object2 = null;
        }
        Jar jar2 = (Jar)object2;
        if (jar2 == null) {
            throw (Throwable)ExceptionsKt.illegalElementType((Object)$receiver$iv$iv, (String)name$iv, (KClass)Reflection.getOrCreateKotlinClass(Jar.class), (KClass)Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()));
        }
        Jar $receiver = jar = jar2;
        StringBuilder stringBuilder = new StringBuilder().append("META-INF/maven/");
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        StringBuilder stringBuilder2 = stringBuilder.append(project.getGroup()).append('/');
        Project project2 = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        $receiver.into((Object)stringBuilder2.append(project2.getName()).toString(), (Action)new Action<CopySpec>($receiver){
            final /* synthetic */ Jar receiver$0;

            public final void execute(@NotNull CopySpec $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.rename(".*", "pom.xml");
                Object[] objectArray = new Object[1];
                Project project = this.receiver$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                TaskCollection taskCollection = project.getTasks().withType(GenerateMavenPom.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)taskCollection, (String)"project.tasks.withType(G\u2026rateMavenPom::class.java)");
                objectArray[0] = CollectionsKt.single((Iterable)((Iterable)taskCollection));
                $receiver.from(objectArray);
            }
            {
                this.receiver$0 = jar;
            }
        });
        $receiver.into((Object)"META-INF", (Action)includePom.1.2.INSTANCE);
    }

    public PublishingConfigurator(@NotNull Project project, @NotNull VersionConfig scmVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scmVersion, (String)"scmVersion");
        this.project = project;
        this.scmVersion = scmVersion;
    }

    public static final /* synthetic */ void access$includeScm(PublishingConfigurator $this, @NotNull MavenPomScm $receiver) {
        $this.includeScm($receiver);
    }
}

