/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import nl.javadude.gradle.plugins.license.DependencyMetadata;
import nl.javadude.gradle.plugins.license.LicenseMetadata;
import nl.javadude.gradle.plugins.license.LicenseResolver;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/license/VerifyLicensingTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowedLicenses", "", "", "getEmptyLicenseMessages", "", "dependencies", "Lnl/javadude/gradle/plugins/license/DependencyMetadata;", "getIllegalLicenseMessages", "resolveDependencies", "config", "verifyLicenses", "", "gradle-release"})
public class VerifyLicensingTask
extends DefaultTask {
    private final Set<String> allowedLicenses = SetsKt.setOf((Object[])new String[]{"The Apache Software License, Version 2.0", "Apache License, Version 2.0", "Apache 2", "Apache 2.0", "Apache License 2.0", "Apache Public License 2.0", "The Apache License, Version 2.0", "Bouncy Castle Licence", "MIT license", "MIT License", "The MIT License", "Revised BSD", "New BSD License", "BSD", "CC0 1.0 Universal", "CDDL 1.1", "CDDL+GPL License", "COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0", "Dual license consisting of the CDDL v1.1 and GPL v2", "Eclipse Distribution License (New BSD License)", "Eclipse Public License 1.0", "GNU General Public License, version 2 (GPL2), with the classpath exception", "GPL2 w/ CPE", "GNU Lesser General Public License"});

    @TaskAction
    public final void verifyLicenses() {
        Collection $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new String[]{"compileClasspath", "runtimeClasspath"});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            Iterable list$iv$iv = this.resolveDependencies(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set dependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $receiver$iv = this.getEmptyLicenseMessages(dependencies);
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            this.getLogger().warn(it);
        }
        List<String> illegalLicenseMessages = this.getIllegalLicenseMessages(dependencies);
        $receiver$iv$iv = illegalLicenseMessages;
        if (!$receiver$iv$iv.isEmpty()) {
            Iterable $receiver$iv2 = illegalLicenseMessages;
            for (Object element$iv : $receiver$iv2) {
                String it = (String)element$iv;
                this.getLogger().error(it);
            }
            throw (Throwable)new Exception("Illegal license found");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getIllegalLicenseMessages(Set<? extends DependencyMetadata> dependencies) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = dependencies;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DependencyMetadata p1 = (DependencyMetadata)element$iv$iv;
            if (!p1.hasLicense()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            LicenseMetadata it;
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv2;
            DependencyMetadata dependency = (DependencyMetadata)element$iv$iv;
            List list = dependency.getLicenseMetadataList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dependency\n             \u2026     .licenseMetadataList");
            Iterable $i$a$1$unknown = list;
            void $i$f$filterTo = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                LicenseMetadata licenseMetadata = it = (LicenseMetadata)element$iv$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)licenseMetadata, (String)"it");
                if (!(!this.allowedLicenses.contains(licenseMetadata.getLicenseName()))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void license;
                it = (LicenseMetadata)item$iv$iv;
                Collection collection = destination$iv$iv2;
                StringBuilder stringBuilder = new StringBuilder().append("Illegal license found '");
                void v3 = license;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"license");
                String string = stringBuilder.append(v3.getLicenseName()).append("' in '").append(dependency.getDependency()).append('\'').toString();
                collection.add(string);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getEmptyLicenseMessages(Set<? extends DependencyMetadata> dependencies) {
        DependencyMetadata p1;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = dependencies;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            p1 = (DependencyMetadata)element$iv$iv;
            if (p1.hasLicense()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void dependency;
            p1 = (DependencyMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = "Dependency without a license found '" + dependency.getDependency() + '\'';
            collection.add(string);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final Set<DependencyMetadata> resolveDependencies(String config) {
        LicenseResolver licenseResolver = new LicenseResolver();
        licenseResolver.setProperty("project", (Object)this.getProject());
        licenseResolver.setProperty("includeProjectDependencies", (Object)true);
        licenseResolver.setProperty("ignoreFatalParseErrors", (Object)false);
        String string = "dependenciesToIgnore";
        LicenseResolver licenseResolver2 = licenseResolver;
        List list = CollectionsKt.emptyList();
        licenseResolver2.setProperty(string, (Object)list);
        licenseResolver.setProperty("dependencyConfiguration", (Object)config);
        Set set = licenseResolver.provideLicenseMap4Dependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"licenseResolver.provideLicenseMap4Dependencies()");
        return set;
    }
}

