/*
 * Decompiled with CFR 0.152.
 */
package at.zierler.gradle;

import at.zierler.gradle.ValidationProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlValidatorTask
extends DefaultTask {
    static final String STARTING_DIRECTORY_MESSAGE = "Starting validation of YAML files in directory '%s'.";
    static final String STARTING_DIRECTORY_RECURSIVE_MESSAGE = "Starting validation of YAML files in directory '%s' recursively.";
    static final String STARTING_FILE_MESSAGE = "Starting validation of YAML file '%s'.";
    static final String DOCUMENT_SUCCESS_MESSAGE = "Validation of document #%s in file %s successful.";
    static final String FILE_SUCCESS_MESSAGE = "Validation of YAML file '%s' successful.";
    static final String FILE_FAILURE_MESSAGE = "Validation of YAML file '%s' failed.";
    private final ValidationProperties validationProperties = (ValidationProperties)this.getProject().getExtensions().findByType(ValidationProperties.class);
    private Yaml yaml;

    @TaskAction
    public void validateAllProvidedFilesAndDirectories() throws IOException {
        for (String path : this.validationProperties.getSearchPaths()) {
            Path fileOrDirectory = this.resolveFileOrDirectoryByPath(path);
            this.checkFileOrDirectory(fileOrDirectory);
        }
    }

    private Path resolveFileOrDirectoryByPath(String path) throws IOException {
        return this.getProject().file((Object)path).toPath().toAbsolutePath().toRealPath(new LinkOption[0]);
    }

    private void checkFileOrDirectory(Path fileOrDirectory) throws IOException {
        if (Files.isDirectory(fileOrDirectory, new LinkOption[0])) {
            this.validateDirectory(fileOrDirectory);
        } else if (Files.isRegularFile(fileOrDirectory, new LinkOption[0])) {
            this.validateSingleFile(fileOrDirectory);
        } else {
            throw new IOException(String.format("File at path %s is neither a file nor a directory.", fileOrDirectory));
        }
    }

    private void validateSingleFile(Path file) {
        if (this.isYamlFile(file)) {
            this.validateYamlFile(file);
        }
    }

    private void validateDirectory(Path directory) throws IOException {
        boolean shouldSearchForYamlFilesRecursively = this.validationProperties.isSearchRecursive();
        if (shouldSearchForYamlFilesRecursively) {
            this.validateYamlFilesInDirectoryRecursively(directory);
        } else {
            this.validateYamlFilesOnlyDirectlyInDirectory(directory);
        }
    }

    private void validateYamlFilesOnlyDirectlyInDirectory(Path directory) throws IOException {
        this.getLogger().info(String.format(STARTING_DIRECTORY_MESSAGE, directory));
        Files.list(directory).filter(this::isYamlFile).forEach(this::validateYamlFile);
    }

    private void validateYamlFilesInDirectoryRecursively(Path directory) throws IOException {
        this.getLogger().info(String.format(STARTING_DIRECTORY_RECURSIVE_MESSAGE, directory));
        Files.walk(directory, new FileVisitOption[0]).filter(this::isYamlFile).forEach(this::validateYamlFile);
    }

    private boolean isYamlFile(Path file) {
        Path fileNameAsPath = file.getFileName();
        if (fileNameAsPath == null) {
            throw new IllegalStateException(String.format("Couldn't extract file name from %s.", file));
        }
        String fileName = fileNameAsPath.toString();
        return fileName.endsWith(".yaml") || fileName.endsWith(".yml");
    }

    private void validateYamlFile(Path file) {
        this.getLogger().info(String.format(STARTING_FILE_MESSAGE, file));
        try (InputStream yamlFileInputStream = Files.newInputStream(file, new OpenOption[0]);){
            this.validateAllDocuments(yamlFileInputStream, file);
        }
        catch (Exception e) {
            throw new GradleException(String.format(FILE_FAILURE_MESSAGE, file), (Throwable)e);
        }
        this.getLogger().info(String.format(FILE_SUCCESS_MESSAGE, file));
    }

    private void validateAllDocuments(InputStream yamlFileInputStream, Path file) {
        int documentIndex = 0;
        for (Object document : this.yamlLoader().loadAll(yamlFileInputStream)) {
            this.getLogger().info(String.format(DOCUMENT_SUCCESS_MESSAGE, ++documentIndex, file));
        }
    }

    private Yaml yamlLoader() {
        if (this.yaml == null) {
            this.createYamlLoader();
        }
        return this.yaml;
    }

    private void createYamlLoader() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(this.validationProperties.isAllowDuplicates());
        this.yaml = new Yaml(loaderOptions);
    }
}

