package gov.raptor.gradle.plugins.buildsupport

import groovy.transform.ToString
import org.gradle.api.file.FileCollection

/**
 * Simple DSL object to allow the configuration for an RDM facade generation task to be captured.  Using an object
 * like this allows the consuming script to easily configure a facade generator.  See
 * {@link GenerateRdmFacadesExtension} for details.
 *
 * @author Proprietary information subject to the terms of a Non-Disclosure Agreement
 * @since 0.4
 * @see GenerateRdmFacadesExtension
 */
@ToString(includeNames = true)
class RdmFacadeGeneratorDefinition {
    /**
     * The configuration name, must be unique among all configurations on a given project.
     */
    final String name

    /**
     * Collection of structure XML files to process.
     */
    FileCollection structureXmls

    /**
     * The package into which to generate the facade classes
     */
    String targetPackage

    /**
     * Set {@code true} to convert the message type to camel case when generating the class name.  Otherwise,
     * use the message type "as is".
     */
    boolean camelCase = false

    /**
     * Prefix to apply to all generated class names.  This can be useful when dealing with message types that don't
     * start with a character that can legally start a java identifier (like digits).
     * <p>
     * Defaults to empty.
     */
    String classNamePrefix = ''

    /**
     * Set {@code true} to fail the build if any errors are encountered while generating the facade classes (like
     * illegal class or method names being generated from structure definitions).  Set {@code false} to simply
     * emit error messages and delete the class file that was being generated.
     * <p>
     * Default is {@code true}
     *
     */
    boolean failBuildOnError = true

    RdmFacadeGeneratorDefinition(String name) {
        this.name = name
    }
}
