/*
 * Decompiled with CFR 0.152.
 */
package com.unitypay.billingmodule.billing;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.unitypay.billingmodule.BillingToClient;
import com.unitypay.billingmodule.billing.Security;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BillingManager
implements PurchasesUpdatedListener {
    public static final int BILLING_MANAGER_NOT_INITIALIZED = -1;
    private static final String TAG = "BillingManager";
    private BillingToClient mBillingClient;
    private boolean mIsServiceConnected;
    private final BillingUpdatesListener mBillingUpdatesListener;
    private final Activity mActivity;
    private final List<Purchase> mPurchases = new ArrayList<Purchase>();
    private Set<String> mTokensToBeConsumed;
    private int mBillingClientResponseCode = -1;
    private static final String BASE_64_ENCODED_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAi2vCWSaTqeYYczDu8Jz3tVeNKSjtLEleU6aTvMC/EVI7RHiTuqUOV00QJKj2Bkx86J68MbeAdSXywjkwPFplV+dA2z3lNCp09nNd8Lh5BA0NX7Zl2p5O4jEPD4rGpMu2QAKGHRYixMxTJ7HuMpzvytp0Fme6QYWtFWHukQJ9CNKoKK2kE42eUo62GeIctPHPAYBY6m+vovPaWuiIh25LzPEPjac2qpnDVhdk7AUnGK3Vn4TTH8QujuHWY+u5pN2BaK1ffd7FTb+cOoo7EvM3GTn5iPDuPBicAGFrP7m17V7iywpY0XkJbYD7w4cM+wmZurXJmySYnpQ1UCOda6xCeQIDAQAB";

    public BillingManager(Activity activity, BillingUpdatesListener updatesListener) {
        Log.d((String)TAG, (String)"Creating Billing client.");
        this.mActivity = activity;
        this.mBillingUpdatesListener = updatesListener;
        this.mBillingClient = BillingToClient.newBuilder((Context)this.mActivity).setListener(this).build();
        Log.d((String)TAG, (String)"Starting setup.");
        this.startServiceConnection(new Runnable(){

            @Override
            public void run() {
                if (BillingManager.this.mBillingUpdatesListener != null) {
                    BillingManager.this.mBillingUpdatesListener.onBillingClientSetupFinished();
                }
                Log.d((String)BillingManager.TAG, (String)"Setup successful. Querying inventory.");
            }
        });
    }

    public void onPurchasesUpdated(int resultCode, List<Purchase> purchases) {
        if (resultCode == 0) {
            for (Purchase purchase : purchases) {
                this.handlePurchase(purchase);
            }
            this.mBillingUpdatesListener.onPurchasesUpdated(this.mPurchases);
        } else if (resultCode == 1) {
            Log.i((String)TAG, (String)"onPurchasesUpdated() - user cancelled the purchase flow - skipping");
            this.mBillingUpdatesListener.onPurchasesCode(resultCode);
        } else {
            this.mBillingUpdatesListener.onPurchasesCode(resultCode);
            Log.w((String)TAG, (String)("onPurchasesUpdated() got unknown resultCode: " + resultCode));
        }
    }

    public void initiatePurchaseFlow(String skuId, String billingType) {
        this.initiatePurchaseFlow(skuId, null, billingType);
    }

    public void initiatePurchaseFlow(final String skuId, final ArrayList<String> oldSkus, final String billingType) {
        Runnable purchaseFlowRequest = new Runnable(){

            @Override
            public void run() {
                Log.d((String)BillingManager.TAG, (String)("Launching in-app purchase flow. Replace old SKU? " + (oldSkus != null)));
                BillingFlowParams purchaseParams = BillingFlowParams.newBuilder().setSku(skuId).setType(billingType).build();
                if (BillingManager.this.mBillingClient != null) {
                    BillingManager.this.mBillingClient.launchBillingFlow(BillingManager.this.mActivity, purchaseParams);
                } else if (BillingManager.this.mBillingUpdatesListener != null) {
                    BillingManager.this.mBillingUpdatesListener.onPurchasesCode(9);
                }
            }
        };
        this.executeServiceRequest(purchaseFlowRequest);
    }

    public Context getContext() {
        return this.mActivity;
    }

    public void destroy() {
        Log.d((String)TAG, (String)"Destroying the manager.");
        if (this.mBillingClient != null && this.mBillingClient.isReady()) {
            this.mBillingClient.endConnection();
            this.mBillingClient = null;
        }
    }

    public void querySkuDetailsAsync(final String itemType, final List<String> skuList, final SkuDetailsResponseListener listener) {
        Runnable queryRequest2 = new Runnable(){

            @Override
            public void run() {
                SkuDetailsParams.Builder params = SkuDetailsParams.newBuilder();
                params.setSkusList(skuList).setType(itemType);
                BillingManager.this.mBillingClient.querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(){

                    public void onSkuDetailsResponse(int responseCode, List<SkuDetails> skuDetailsList) {
                        listener.onSkuDetailsResponse(responseCode, skuDetailsList);
                    }
                });
            }
        };
        this.executeServiceRequest(queryRequest2);
    }

    public void consumeAsync(final String purchaseToken) {
        if (this.mTokensToBeConsumed == null) {
            this.mTokensToBeConsumed = new HashSet<String>();
        } else if (this.mTokensToBeConsumed.contains(purchaseToken)) {
            Log.i((String)TAG, (String)"Token was already scheduled to be consumed - skipping...");
            return;
        }
        this.mTokensToBeConsumed.add(purchaseToken);
        final ConsumeResponseListener onConsumeListener = new ConsumeResponseListener(){

            public void onConsumeResponse(int responseCode, String purchaseToken) {
                BillingManager.this.mBillingUpdatesListener.onConsumeFinished(purchaseToken, responseCode);
            }
        };
        Runnable consumeRequest = new Runnable(){

            @Override
            public void run() {
                BillingManager.this.mBillingClient.consumeAsync(purchaseToken, onConsumeListener);
            }
        };
        this.executeServiceRequest(consumeRequest);
    }

    public int getBillingClientResponseCode() {
        return this.mBillingClientResponseCode;
    }

    private void handlePurchase(Purchase purchase) {
        if (!this.verifyValidSignature(purchase.getOriginalJson(), purchase.getSignature())) {
            Log.i((String)TAG, (String)("Got a purchase: " + purchase + "; but signature is bad. Skipping..."));
            return;
        }
        Log.d((String)TAG, (String)("Got a verified purchase: " + purchase));
        this.mPurchases.add(purchase);
    }

    private void onQueryPurchasesFinished(Purchase.PurchasesResult result) {
        if (this.mBillingClient == null || result.getResponseCode() != 0) {
            Log.w((String)TAG, (String)("Billing client was null or result code (" + result.getResponseCode() + ") was bad - quitting"));
            return;
        }
        Log.d((String)TAG, (String)"Query inventory was successful.");
        this.mPurchases.clear();
        this.onPurchasesUpdated(0, result.getPurchasesList());
    }

    public boolean areSubscriptionsSupported() {
        int responseCode = this.mBillingClient.isFeatureSupported("subscriptions");
        if (responseCode != 0) {
            Log.w((String)TAG, (String)("areSubscriptionsSupported() got an error response: " + responseCode));
        }
        return responseCode == 0;
    }

    public void queryPurchases() {
        Runnable queryToExecute2 = new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                Purchase.PurchasesResult purchasesResult = BillingManager.this.mBillingClient.queryPurchases("inapp");
                Log.i((String)BillingManager.TAG, (String)("Querying purchases elapsed time: " + (System.currentTimeMillis() - time) + "ms"));
                if (BillingManager.this.areSubscriptionsSupported()) {
                    Purchase.PurchasesResult subscriptionResult = BillingManager.this.mBillingClient.queryPurchases("subs");
                    Log.i((String)BillingManager.TAG, (String)("Querying purchases and subscriptions elapsed time: " + (System.currentTimeMillis() - time) + "ms"));
                    Log.i((String)BillingManager.TAG, (String)("Querying subscriptions result code: " + subscriptionResult.getResponseCode() + " res: " + subscriptionResult.getPurchasesList().size()));
                    if (subscriptionResult.getResponseCode() == 0) {
                        purchasesResult.getPurchasesList().addAll(subscriptionResult.getPurchasesList());
                    } else {
                        Log.e((String)BillingManager.TAG, (String)"Got an error response trying to query subscription purchases");
                    }
                } else if (purchasesResult.getResponseCode() == 0) {
                    Log.i((String)BillingManager.TAG, (String)"Skipped subscription purchases query since they are not supported");
                } else {
                    Log.w((String)BillingManager.TAG, (String)("queryPurchases() got an error response code: " + purchasesResult.getResponseCode()));
                }
                BillingManager.this.onQueryPurchasesFinished(purchasesResult);
            }
        };
        this.executeServiceRequest(queryToExecute2);
    }

    public void startServiceConnection(final Runnable executeOnSuccess) {
        this.mBillingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(int billingResponseCode) {
                Log.d((String)BillingManager.TAG, (String)("Setup finished. Response code: " + billingResponseCode));
                if (billingResponseCode == 0) {
                    BillingManager.this.mIsServiceConnected = true;
                    if (executeOnSuccess != null) {
                        executeOnSuccess.run();
                    }
                }
                BillingManager.this.mBillingClientResponseCode = billingResponseCode;
            }

            public void onBillingServiceDisconnected() {
                BillingManager.this.mIsServiceConnected = false;
            }
        });
    }

    private void executeServiceRequest(Runnable runnable) {
        if (this.mIsServiceConnected) {
            runnable.run();
        } else {
            this.startServiceConnection(runnable);
        }
    }

    private boolean verifyValidSignature(String signedData, String signature) {
        if (BASE_64_ENCODED_PUBLIC_KEY.contains("CONSTRUCT_YOUR")) {
            throw new RuntimeException("Please update your app's public key at: BASE_64_ENCODED_PUBLIC_KEY");
        }
        try {
            return Security.verifyPurchase(BASE_64_ENCODED_PUBLIC_KEY, signedData, signature);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Got an exception trying to validate a purchase: " + e));
            return false;
        }
    }

    public static interface ServiceConnectedListener {
        public void onServiceConnected(int var1);
    }

    public static interface BillingUpdatesListener {
        public void onBillingClientSetupFinished();

        public void onConsumeFinished(String var1, int var2);

        public void onPurchasesUpdated(List<Purchase> var1);

        public void onPurchasesCode(Integer var1);

        public void googleError(Integer var1);
    }
}

