/*
 * Decompiled with CFR 0.152.
 */
package com.unitypay.billingmodule;

import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class Md5Util {
    public static String getFileMD5(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            return null;
        }
        return Md5Util.encodeHex(digest.digest());
    }

    public static String getPackageNameMd5(String packageName) {
        if (packageName == null) {
            return null;
        }
        return Md5Util.getStringMd5(packageName + "ijinshan");
    }

    public static String getFilePathMd5(String filePath) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        String[] s = filePath.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (!TextUtils.isEmpty((CharSequence)s[i])) {
                sb.append(Md5Util.getStringMd5(s[i].toLowerCase() + "ijinshan"));
            }
            if (i == s.length - 1) continue;
            sb.append('+');
        }
        return sb.toString();
    }

    public static String getStringMd5(String plainText) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
        }
        catch (Exception e) {
            return null;
        }
        return Md5Util.encodeHex(md.digest());
    }

    public static String getStreamMD5(InputStream in) {
        if (in == null) {
            return null;
        }
        MessageDigest md = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            md = MessageDigest.getInstance("MD5");
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                md.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            return null;
        }
        return Md5Util.encodeHex(md.digest());
    }

    public static String getByteArrayMD5(byte[] data) {
        if (null == data) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(data);
        }
        catch (Exception e) {
            return null;
        }
        return Md5Util.encodeHex(md.digest());
    }

    public static String encodeHex(byte[] data) {
        if (data == null) {
            return null;
        }
        String HEXES = "0123456789abcdef";
        int len = data.length;
        StringBuilder hex = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            hex.append("0123456789abcdef".charAt((data[i] & 0xF0) >>> 4));
            hex.append("0123456789abcdef".charAt(data[i] & 0xF));
        }
        return hex.toString();
    }
}

