/*
 * Decompiled with CFR 0.152.
 */
package com.unitypay.billingmodule;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.unitypay.billingmodule.GooglePayManager;
import com.unitypay.billingmodule.billing.Security;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001EB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010+\u001a\u00020!J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020(H\u0002J \u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u00172\u000e\u00104\u001a\n\u0012\u0004\u0012\u00020(\u0018\u000105H\u0016J\u0010\u00106\u001a\u00020-2\u0006\u00107\u001a\u000208H\u0002J\u0006\u00109\u001a\u00020-J$\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020\b2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\b0=2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020/J\u0018\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006F"}, d2={"Lcom/unitypay/billingmodule/GooglePayManager;", "Lcom/android/billingclient/api/PurchasesUpdatedListener;", "act", "Landroid/app/Activity;", "mBillingUpdatesListener", "Lcom/unitypay/billingmodule/GooglePayManager$BillingUpdatesListener;", "(Landroid/app/Activity;Lcom/unitypay/billingmodule/GooglePayManager$BillingUpdatesListener;)V", "BASE_64_ENCODED_PUBLIC_KEY", "", "TAG", "getTAG", "()Ljava/lang/String;", "getAct", "()Landroid/app/Activity;", "setAct", "(Landroid/app/Activity;)V", "mBillingClient", "Lcom/android/billingclient/api/BillingClient;", "getMBillingClient", "()Lcom/android/billingclient/api/BillingClient;", "setMBillingClient", "(Lcom/android/billingclient/api/BillingClient;)V", "mBillingClientResponseCode", "", "getMBillingClientResponseCode", "()I", "setMBillingClientResponseCode", "(I)V", "getMBillingUpdatesListener", "()Lcom/unitypay/billingmodule/GooglePayManager$BillingUpdatesListener;", "setMBillingUpdatesListener", "(Lcom/unitypay/billingmodule/GooglePayManager$BillingUpdatesListener;)V", "mIsServiceConnected", "", "getMIsServiceConnected", "()Z", "setMIsServiceConnected", "(Z)V", "mPurchases", "Ljava/util/ArrayList;", "Lcom/android/billingclient/api/Purchase;", "getMPurchases", "()Ljava/util/ArrayList;", "areSubscriptionsSupported", "executeServiceRequest", "", "runnable", "Ljava/lang/Runnable;", "handlePurchase", "purchase", "onPurchasesUpdated", "responseCode", "purchases", "", "onQueryPurchasesFinished", "result", "Lcom/android/billingclient/api/Purchase$PurchasesResult;", "queryPurchases", "querySkuDetailsAsync", "itemType", "skuList", "", "listener", "Lcom/android/billingclient/api/SkuDetailsResponseListener;", "startServiceConnection", "executeOnSuccess", "verifyValidSignature", "signedData", "signature", "BillingUpdatesListener", "unitybuy_release"})
public final class GooglePayManager
implements PurchasesUpdatedListener {
    @NotNull
    private final String TAG = "GooglePay";
    @NotNull
    private BillingClient mBillingClient;
    private int mBillingClientResponseCode;
    @NotNull
    private final ArrayList<Purchase> mPurchases;
    private final String BASE_64_ENCODED_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAi2vCWSaTqeYYczDu8Jz3tVeNKSjtLEleU6aTvMC/EVI7RHiTuqUOV00QJKj2Bkx86J68MbeAdSXywjkwPFplV+dA2z3lNCp09nNd8Lh5BA0NX7Zl2p5O4jEPD4rGpMu2QAKGHRYixMxTJ7HuMpzvytp0Fme6QYWtFWHukQJ9CNKoKK2kE42eUo62GeIctPHPAYBY6m+vovPaWuiIh25LzPEPjac2qpnDVhdk7AUnGK3Vn4TTH8QujuHWY+u5pN2BaK1ffd7FTb+cOoo7EvM3GTn5iPDuPBicAGFrP7m17V7iywpY0XkJbYD7w4cM+wmZurXJmySYnpQ1UCOda6xCeQIDAQAB";
    private boolean mIsServiceConnected;
    @NotNull
    private Activity act;
    @NotNull
    private BillingUpdatesListener mBillingUpdatesListener;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final BillingClient getMBillingClient() {
        return this.mBillingClient;
    }

    public final void setMBillingClient(@NotNull BillingClient billingClient) {
        Intrinsics.checkParameterIsNotNull((Object)billingClient, (String)"<set-?>");
        this.mBillingClient = billingClient;
    }

    public final int getMBillingClientResponseCode() {
        return this.mBillingClientResponseCode;
    }

    public final void setMBillingClientResponseCode(int n) {
        this.mBillingClientResponseCode = n;
    }

    @NotNull
    public final ArrayList<Purchase> getMPurchases() {
        return this.mPurchases;
    }

    public final boolean getMIsServiceConnected() {
        return this.mIsServiceConnected;
    }

    public final void setMIsServiceConnected(boolean bl) {
        this.mIsServiceConnected = bl;
    }

    public final void startServiceConnection(@NotNull Runnable executeOnSuccess) {
        Intrinsics.checkParameterIsNotNull((Object)executeOnSuccess, (String)"executeOnSuccess");
        this.mBillingClient.startConnection(new BillingClientStateListener(this, executeOnSuccess){
            final /* synthetic */ GooglePayManager this$0;
            final /* synthetic */ Runnable $executeOnSuccess;

            public void onBillingSetupFinished(int billingResponseCode) {
                if (billingResponseCode == 0) {
                    this.this$0.setMIsServiceConnected(true);
                    this.$executeOnSuccess.run();
                }
                this.this$0.setMBillingClientResponseCode(billingResponseCode);
            }

            public void onBillingServiceDisconnected() {
                this.this$0.setMIsServiceConnected(false);
            }
            {
                this.this$0 = $outer;
                this.$executeOnSuccess = $captured_local_variable$1;
            }
        });
    }

    public final void queryPurchases() {
        Runnable queryToExecute2 = new Runnable(this){
            final /* synthetic */ GooglePayManager this$0;

            public final void run() {
                long time = System.currentTimeMillis();
                Purchase.PurchasesResult purchasesResult = this.this$0.getMBillingClient().queryPurchases("inapp");
                Log.i((String)this.this$0.getTAG(), (String)("Querying purchases elapsed time: " + (System.currentTimeMillis() - time) + "ms"));
                if (this.this$0.areSubscriptionsSupported()) {
                    Purchase.PurchasesResult subscriptionResult = this.this$0.getMBillingClient().queryPurchases("subs");
                    Log.i((String)this.this$0.getTAG(), (String)("Querying purchases and subscriptions elapsed time: " + (System.currentTimeMillis() - time) + "ms"));
                    String string = this.this$0.getTAG();
                    StringBuilder stringBuilder = new StringBuilder().append("Querying subscriptions result code: ");
                    Purchase.PurchasesResult purchasesResult2 = subscriptionResult;
                    Intrinsics.checkExpressionValueIsNotNull((Object)purchasesResult2, (String)"subscriptionResult");
                    Log.i((String)string, (String)stringBuilder.append(purchasesResult2.getResponseCode()).append(" res: ").append(subscriptionResult.getPurchasesList().size()).toString());
                    if (subscriptionResult.getResponseCode() == 0) {
                        Purchase.PurchasesResult purchasesResult3 = purchasesResult;
                        Intrinsics.checkExpressionValueIsNotNull((Object)purchasesResult3, (String)"purchasesResult");
                        List list = purchasesResult3.getPurchasesList();
                        List list2 = subscriptionResult.getPurchasesList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"subscriptionResult.purchasesList");
                        list.addAll(list2);
                    } else {
                        Log.e((String)this.this$0.getTAG(), (String)"Got an error response trying to query subscription purchases");
                    }
                } else {
                    Purchase.PurchasesResult purchasesResult4 = purchasesResult;
                    Intrinsics.checkExpressionValueIsNotNull((Object)purchasesResult4, (String)"purchasesResult");
                    if (purchasesResult4.getResponseCode() == 0) {
                        Log.i((String)this.this$0.getTAG(), (String)"Skipped subscription purchases query since they are not supported");
                    } else {
                        Log.w((String)this.this$0.getTAG(), (String)("queryPurchases() got an error response code: " + purchasesResult.getResponseCode()));
                    }
                }
                Purchase.PurchasesResult purchasesResult5 = purchasesResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)purchasesResult5, (String)"purchasesResult");
                GooglePayManager.access$onQueryPurchasesFinished(this.this$0, purchasesResult5);
            }
            {
                this.this$0 = googlePayManager;
            }
        };
        this.executeServiceRequest(queryToExecute2);
    }

    private final void executeServiceRequest(Runnable runnable) {
        if (this.mIsServiceConnected) {
            runnable.run();
        } else {
            this.startServiceConnection(runnable);
        }
    }

    public final boolean areSubscriptionsSupported() {
        int responseCode = this.mBillingClient.isFeatureSupported("subscriptions");
        if (responseCode != 0) {
            Log.w((String)this.TAG, (String)("areSubscriptionsSupported() got an error response: " + responseCode));
        }
        return responseCode == 0;
    }

    private final void onQueryPurchasesFinished(Purchase.PurchasesResult result) {
        if (this.mBillingClient == null || result.getResponseCode() != 0) {
            Log.w((String)this.TAG, (String)("Billing client was null or result code (" + result.getResponseCode() + ") was bad - quitting"));
            return;
        }
        Log.d((String)this.TAG, (String)"Query inventory was successful.");
        this.mPurchases.clear();
        this.onPurchasesUpdated(0, result.getPurchasesList());
    }

    public void onPurchasesUpdated(int responseCode, @Nullable List<Purchase> purchases) {
        if (responseCode == 0) {
            List list = purchases;
            if (list == null) {
                list = new ArrayList();
            }
            for (Purchase purchas : list) {
                this.handlePurchase(purchas);
            }
            this.mBillingUpdatesListener.onPurchasesUpdated((List<? extends Purchase>)this.mPurchases);
        } else if (responseCode == 1) {
            Log.i((String)this.TAG, (String)"onPurchasesUpdated() - user cancelled the purchase flow - skipping");
        } else {
            Log.w((String)this.TAG, (String)("onPurchasesUpdated() got unknown resultCode: " + responseCode));
        }
    }

    private final void handlePurchase(Purchase purchase) {
        String string = purchase.getOriginalJson();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"purchase.originalJson");
        String string2 = purchase.getSignature();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"purchase.signature");
        if (!this.verifyValidSignature(string, string2)) {
            Log.i((String)this.TAG, (String)("Got a purchase: " + purchase + "; but signature is bad. Skipping..."));
            return;
        }
        Log.d((String)this.TAG, (String)("Got a verified purchase: " + purchase));
        this.mPurchases.add(purchase);
    }

    private final boolean verifyValidSignature(String signedData, String signature) {
        if (StringsKt.contains$default((CharSequence)this.BASE_64_ENCODED_PUBLIC_KEY, (CharSequence)"CONSTRUCT_YOUR", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("Please update your app's public key at: BASE_64_ENCODED_PUBLIC_KEY");
        }
        try {
            return Security.verifyPurchase(this.BASE_64_ENCODED_PUBLIC_KEY, signedData, signature);
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("Got an exception trying to validate a purchase: " + e));
            return false;
        }
    }

    public final void querySkuDetailsAsync(@NotNull String itemType, @NotNull List<String> skuList, @NotNull SkuDetailsResponseListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)itemType, (String)"itemType");
        Intrinsics.checkParameterIsNotNull(skuList, (String)"skuList");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Runnable queryRequest2 = new Runnable(this, skuList, itemType, listener){
            final /* synthetic */ GooglePayManager this$0;
            final /* synthetic */ List $skuList;
            final /* synthetic */ String $itemType;
            final /* synthetic */ SkuDetailsResponseListener $listener;

            public final void run() {
                SkuDetailsParams.Builder params = SkuDetailsParams.newBuilder();
                params.setSkusList(this.$skuList).setType(this.$itemType);
                this.this$0.getMBillingClient().querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(this){
                    final /* synthetic */ querySkuDetailsAsync.queryRequest.1 this$0;

                    public final void onSkuDetailsResponse(int responseCode, List<SkuDetails> skuDetailsList) {
                        this.this$0.$listener.onSkuDetailsResponse(responseCode, skuDetailsList);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = googlePayManager;
                this.$skuList = list;
                this.$itemType = string;
                this.$listener = skuDetailsResponseListener;
            }
        };
        this.executeServiceRequest(queryRequest2);
    }

    @NotNull
    public final Activity getAct() {
        return this.act;
    }

    public final void setAct(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"<set-?>");
        this.act = activity;
    }

    @NotNull
    public final BillingUpdatesListener getMBillingUpdatesListener() {
        return this.mBillingUpdatesListener;
    }

    public final void setMBillingUpdatesListener(@NotNull BillingUpdatesListener billingUpdatesListener) {
        Intrinsics.checkParameterIsNotNull((Object)billingUpdatesListener, (String)"<set-?>");
        this.mBillingUpdatesListener = billingUpdatesListener;
    }

    public GooglePayManager(@NotNull Activity act, @NotNull BillingUpdatesListener mBillingUpdatesListener) {
        Intrinsics.checkParameterIsNotNull((Object)act, (String)"act");
        Intrinsics.checkParameterIsNotNull((Object)mBillingUpdatesListener, (String)"mBillingUpdatesListener");
        this.act = act;
        this.mBillingUpdatesListener = mBillingUpdatesListener;
        this.TAG = "GooglePay";
        BillingClient billingClient = BillingClient.newBuilder((Context)((Context)this.act)).setListener((PurchasesUpdatedListener)this).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)billingClient, (String)"BillingClient.newBuilder\u2026setListener(this).build()");
        this.mBillingClient = billingClient;
        this.mBillingClientResponseCode = -1;
        this.mPurchases = new ArrayList();
        this.BASE_64_ENCODED_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAi2vCWSaTqeYYczDu8Jz3tVeNKSjtLEleU6aTvMC/EVI7RHiTuqUOV00QJKj2Bkx86J68MbeAdSXywjkwPFplV+dA2z3lNCp09nNd8Lh5BA0NX7Zl2p5O4jEPD4rGpMu2QAKGHRYixMxTJ7HuMpzvytp0Fme6QYWtFWHukQJ9CNKoKK2kE42eUo62GeIctPHPAYBY6m+vovPaWuiIh25LzPEPjac2qpnDVhdk7AUnGK3Vn4TTH8QujuHWY+u5pN2BaK1ffd7FTb+cOoo7EvM3GTn5iPDuPBicAGFrP7m17V7iywpY0XkJbYD7w4cM+wmZurXJmySYnpQ1UCOda6xCeQIDAQAB";
        this.startServiceConnection(new Runnable(){

            @Override
            public final void run() {
                this.getMBillingUpdatesListener().onBillingClientSetupFinished();
                this.queryPurchases();
            }
        });
    }

    public static final /* synthetic */ void access$onQueryPurchasesFinished(GooglePayManager $this, @NotNull Purchase.PurchasesResult result) {
        $this.onQueryPurchasesFinished(result);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&\u00a8\u0006\r"}, d2={"Lcom/unitypay/billingmodule/GooglePayManager$BillingUpdatesListener;", "", "onBillingClientSetupFinished", "", "onConsumeFinished", "token", "", "result", "", "onPurchasesUpdated", "purchases", "", "Lcom/android/billingclient/api/Purchase;", "unitybuy_release"})
    public static interface BillingUpdatesListener {
        public void onBillingClientSetupFinished();

        public void onConsumeFinished(@NotNull String var1, int var2);

        public void onPurchasesUpdated(@NotNull List<? extends Purchase> var1);
    }
}

