/*
 * Decompiled with CFR 0.152.
 */
package com.unitypay.billingmodule;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingToto;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BillingToClient {
    @UiThread
    public static Builder newBuilder(@NonNull Context context) {
        return new Builder(context);
    }

    @UiThread
    public abstract int isFeatureSupported(String var1);

    @UiThread
    public abstract boolean isReady();

    @UiThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @UiThread
    public abstract void endConnection();

    @UiThread
    public abstract int launchBillingFlow(Activity var1, BillingFlowParams var2);

    @UiThread
    public abstract Purchase.PurchasesResult queryPurchases(String var1);

    @UiThread
    public abstract void querySkuDetailsAsync(SkuDetailsParams var1, SkuDetailsResponseListener var2);

    @UiThread
    public abstract void consumeAsync(String var1, ConsumeResponseListener var2);

    @UiThread
    public abstract void queryPurchaseHistoryAsync(String var1, PurchaseHistoryResponseListener var2);

    public static final class Builder {
        private final Context mContext;
        private PurchasesUpdatedListener mListener;

        private Builder(Context context) {
            this.mContext = context;
        }

        @UiThread
        public Builder setListener(PurchasesUpdatedListener listener) {
            this.mListener = listener;
            return this;
        }

        @UiThread
        public BillingToClient build() {
            if (this.mContext == null) {
                throw new IllegalArgumentException("Please provide a valid Context.");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
            }
            return new BillingToto(this.mContext, this.mListener);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponse {
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        public static final String SUBSCRIPTIONS = "subscriptions";
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        public static final String IN_APP_ITEMS_ON_VR = "inAppItemsOnVr";
        public static final String SUBSCRIPTIONS_ON_VR = "subscriptionsOnVr";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SkuType {
        public static final String INAPP = "inapp";
        public static final String SUBS = "subs";
    }
}

