/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.android.billingclient.api.BillingBroadcastManager;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingToto;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.LocalBroadcastManager;
import com.android.billingclient.api.ProxyBillingActivity;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.util.BillingHelper;
import com.android.vending.billing.IInAppBillingService;
import com.unitypay.billingmodule.BillingToClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0019\u0018\u0000 F2\u00020\u0001:\u0003DEFB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0004\u001a\u0004\u0018\u00010%H\u0003J\b\u0010'\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u001eH\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020$H\u0002J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020$H\u0016J\b\u00100\u001a\u00020\u000fH\u0016J\u0018\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u0002032\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u00104\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u00105\u001a\u00020\"2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u0004\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010-\u001a\u00020$H\u0016J\u0018\u00109\u001a\u0002082\u0006\u0010-\u001a\u00020$2\u0006\u0010:\u001a\u00020\u000fH\u0002J\u0018\u0010;\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020<2\u0006\u0010\u0004\u001a\u00020=H\u0016J \u0010>\u001a\u00020?2\u0006\u0010-\u001a\u00020$2\u000e\u0010@\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010AH\u0003J\u0010\u0010B\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020CH\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006G"}, d2={"Lcom/android/billingclient/api/BillingToto;", "Lcom/unitypay/billingmodule/BillingToClient;", "context", "Landroid/content/Context;", "listener", "Lcom/android/billingclient/api/PurchasesUpdatedListener;", "(Landroid/content/Context;Lcom/android/billingclient/api/PurchasesUpdatedListener;)V", "mApplicationContext", "mBroadcastManager", "Lcom/android/billingclient/api/BillingBroadcastManager;", "mClientState", "", "mExecutorService", "Ljava/util/concurrent/ExecutorService;", "mIABv6Supported", "", "mService", "Lcom/android/vending/billing/IInAppBillingService;", "mServiceConnection", "Landroid/content/ServiceConnection;", "mSubscriptionUpdateSupported", "mSubscriptionsSupported", "mUiThreadHandler", "Landroid/os/Handler;", "onPurchaseFinishedReceiver", "com/android/billingclient/api/BillingToto$onPurchaseFinishedReceiver$1", "Lcom/android/billingclient/api/BillingToto$onPurchaseFinishedReceiver$1;", "broadcastFailureAndReturnBillingResponse", "responseCode", "constructExtraParams", "Landroid/os/Bundle;", "params", "Lcom/android/billingclient/api/BillingFlowParams;", "consumeAsync", "", "purchaseToken", "", "Lcom/android/billingclient/api/ConsumeResponseListener;", "consumeInternal", "endConnection", "executeAsync", "runnable", "Ljava/lang/Runnable;", "generateVrBundle", "isBillingSupportedOnVr", "skuType", "isFeatureSupported", "feature", "isReady", "launchBillingFlow", "activity", "Landroid/app/Activity;", "postToUiThread", "queryPurchaseHistoryAsync", "Lcom/android/billingclient/api/PurchaseHistoryResponseListener;", "queryPurchases", "Lcom/android/billingclient/api/Purchase$PurchasesResult;", "queryPurchasesInternal", "queryHistory", "querySkuDetailsAsync", "Lcom/android/billingclient/api/SkuDetailsParams;", "Lcom/android/billingclient/api/SkuDetailsResponseListener;", "querySkuDetailsInternal", "Lcom/android/billingclient/api/SkuDetails$SkuDetailsResult;", "skuList", "", "startConnection", "Lcom/android/billingclient/api/BillingClientStateListener;", "BillingServiceConnection", "ClientState", "Companion", "unitybuy_release"})
public final class BillingToto
extends BillingToClient {
    private int mClientState;
    private final Handler mUiThreadHandler;
    private final Context mApplicationContext;
    private final BillingBroadcastManager mBroadcastManager;
    private IInAppBillingService mService;
    private ServiceConnection mServiceConnection;
    private boolean mSubscriptionsSupported;
    private boolean mSubscriptionUpdateSupported;
    private boolean mIABv6Supported;
    private ExecutorService mExecutorService;
    private final onPurchaseFinishedReceiver.1 onPurchaseFinishedReceiver;
    private static final String TAG = "BillingClient";
    private static final int MAX_SKU_DETAILS_ITEMS_PER_REQUEST = 20;
    private static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    private static final String LIBRARY_VERSION_KEY = "libraryVersion";
    private static final String LIBRARY_VERSION = "1.1";
    public static final Companion Companion = new Companion(null);

    @Override
    public int isFeatureSupported(@NotNull String feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        if (!this.isReady()) {
            return -1;
        }
        switch (feature) {
            case "subscriptions": {
                return this.mSubscriptionsSupported ? 0 : -2;
            }
            case "subscriptionsUpdate": {
                return this.mSubscriptionUpdateSupported ? 0 : -2;
            }
            case "inAppItemsOnVr": {
                return this.isBillingSupportedOnVr("inapp");
            }
            case "subscriptionsOnVr": {
                return this.isBillingSupportedOnVr("subs");
            }
        }
        BillingHelper.logWarn((String)TAG, (String)("Unsupported feature: " + feature));
        return 5;
    }

    @Override
    public boolean isReady() {
        return this.mClientState == 2 && this.mService != null && this.mServiceConnection != null;
    }

    @Override
    public void startConnection(@NotNull BillingClientStateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (this.isReady()) {
            BillingHelper.logVerbose((String)TAG, (String)"Service connection is valid. No need to re-initialize.");
            listener.onBillingSetupFinished(0);
            return;
        }
        if (this.mClientState == 1) {
            BillingHelper.logWarn((String)TAG, (String)"Client is already in the process of connecting to billing service.");
            listener.onBillingSetupFinished(5);
            return;
        }
        if (this.mClientState == 3) {
            BillingHelper.logWarn((String)TAG, (String)"Client was already closed and can't be reused. Please create another instance.");
            listener.onBillingSetupFinished(5);
            return;
        }
        this.mClientState = 1;
        this.mBroadcastManager.registerReceiver();
        IntentFilter purchaseIntent = new IntentFilter("proxy_activity_response_intent_action");
        LocalBroadcastManager.getInstance((Context)this.mApplicationContext).registerReceiver((BroadcastReceiver)this.onPurchaseFinishedReceiver, purchaseIntent);
        BillingHelper.logVerbose((String)TAG, (String)"Starting in-app billing setup.");
        this.mServiceConnection = new BillingServiceConnection(listener);
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        List intentServices = this.mApplicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (intentServices != null && !intentServices.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)intentServices.get(0);
            if (resolveInfo.serviceInfo != null) {
                String packageName = resolveInfo.serviceInfo.packageName;
                String className = resolveInfo.serviceInfo.name;
                if (Intrinsics.areEqual((Object)"com.android.vending", (Object)packageName) && className != null) {
                    ComponentName component = new ComponentName(packageName, className);
                    Intent explicitServiceIntent = new Intent(serviceIntent);
                    explicitServiceIntent.setComponent(component);
                    explicitServiceIntent.putExtra(LIBRARY_VERSION_KEY, LIBRARY_VERSION);
                    boolean connectionResult = this.mApplicationContext.bindService(explicitServiceIntent, this.mServiceConnection, 1);
                    if (connectionResult) {
                        BillingHelper.logVerbose((String)TAG, (String)"Service was bonded successfully.");
                        return;
                    }
                    BillingHelper.logWarn((String)TAG, (String)"Connection to Billing service is blocked.");
                } else {
                    BillingHelper.logWarn((String)TAG, (String)"The device doesn't have valid Play Store.");
                }
            }
        }
        this.mClientState = 0;
        BillingHelper.logVerbose((String)TAG, (String)"Billing service unavailable on device.");
        listener.onBillingSetupFinished(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endConnection() {
        try {
            LocalBroadcastManager.getInstance((Context)this.mApplicationContext).unregisterReceiver((BroadcastReceiver)this.onPurchaseFinishedReceiver);
            this.mBroadcastManager.destroy();
            if (this.mServiceConnection != null && this.mService != null) {
                BillingHelper.logVerbose((String)TAG, (String)"Unbinding from service.");
                this.mApplicationContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
            }
            this.mService = null;
            if (this.mExecutorService != null) {
                ExecutorService executorService = this.mExecutorService;
                if (executorService == null) {
                    Intrinsics.throwNpe();
                }
                executorService.shutdownNow();
                this.mExecutorService = null;
            }
        }
        catch (Exception ex) {
            BillingHelper.logWarn((String)TAG, (String)("There was an exception while ending connection: " + ex));
        }
        finally {
            this.mClientState = 3;
        }
    }

    @Override
    public int launchBillingFlow(@NotNull Activity activity, @NotNull BillingFlowParams params) {
        boolean isSubscriptionUpdate;
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (!this.isReady()) {
            return this.broadcastFailureAndReturnBillingResponse(-1);
        }
        String skuType = params.getSkuType();
        String newSku = params.getSku();
        if (newSku == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. SKU can't be null.");
            return this.broadcastFailureAndReturnBillingResponse(5);
        }
        if (skuType == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. SkuType can't be null.");
            return this.broadcastFailureAndReturnBillingResponse(5);
        }
        if (Intrinsics.areEqual((Object)skuType, (Object)"subs") && !this.mSubscriptionsSupported) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support subscriptions.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        boolean bl = isSubscriptionUpdate = params.getOldSku() != null;
        if (isSubscriptionUpdate && !this.mSubscriptionUpdateSupported) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support subscriptions update.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        if (params.hasExtraParams() && !this.mIABv6Supported) {
            BillingHelper.logWarn((String)TAG, (String)"Current client doesn't support extra params for buy intent.");
            return this.broadcastFailureAndReturnBillingResponse(-2);
        }
        try {
            Bundle buyIntentBundle;
            BillingHelper.logVerbose((String)TAG, (String)("Constructing buy intent for " + newSku + ", item type: " + skuType));
            if (this.mIABv6Supported) {
                Bundle extraParams = this.constructExtraParams(params);
                extraParams.putString(LIBRARY_VERSION_KEY, LIBRARY_VERSION);
                int apiVersion = params.getVrPurchaseFlow() ? 7 : 6;
                IInAppBillingService iInAppBillingService = this.mService;
                if (iInAppBillingService == null) {
                    Intrinsics.throwNpe();
                }
                Bundle bundle = iInAppBillingService.getBuyIntentExtraParams(apiVersion, this.mApplicationContext.getPackageName(), newSku, skuType, null, extraParams);
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"mService!!.getBuyIntentE\u2026             extraParams)");
                buyIntentBundle = bundle;
            } else if (isSubscriptionUpdate) {
                IInAppBillingService iInAppBillingService = this.mService;
                if (iInAppBillingService == null) {
                    Intrinsics.throwNpe();
                }
                Bundle bundle = iInAppBillingService.getBuyIntentToReplaceSkus(5, this.mApplicationContext.getPackageName(), Arrays.asList(params.getOldSku()), newSku, "subs", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"mService!!.getBuyIntentT\u2026lient.SkuType.SUBS, null)");
                buyIntentBundle = bundle;
            } else {
                IInAppBillingService iInAppBillingService = this.mService;
                if (iInAppBillingService == null) {
                    Intrinsics.throwNpe();
                }
                Bundle bundle = iInAppBillingService.getBuyIntent(3, this.mApplicationContext.getPackageName(), newSku, skuType, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"mService!!.getBuyIntent(\u2026           skuType, null)");
                buyIntentBundle = bundle;
            }
            int responseCode = BillingHelper.getResponseCodeFromBundle((Bundle)buyIntentBundle, (String)TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn((String)TAG, (String)("Unable to buy item, Error response code: " + responseCode));
                return this.broadcastFailureAndReturnBillingResponse(responseCode);
            }
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable("BUY_INTENT");
            intent.putExtra("BUY_INTENT", (Parcelable)pendingIntent);
            activity.startActivity(intent);
        }
        catch (RemoteException e) {
            String msg = "RemoteException while launching launching replace subscriptions flow: ; for sku: " + newSku + "; try to reconnect";
            BillingHelper.logWarn((String)TAG, (String)msg);
            return this.broadcastFailureAndReturnBillingResponse(-1);
        }
        return 0;
    }

    private final int broadcastFailureAndReturnBillingResponse(int responseCode) {
        this.mBroadcastManager.getListener().onPurchasesUpdated(responseCode, null);
        return responseCode;
    }

    @Override
    @NotNull
    public Purchase.PurchasesResult queryPurchases(@NotNull String skuType) {
        Intrinsics.checkParameterIsNotNull((Object)skuType, (String)"skuType");
        if (!this.isReady()) {
            return new Purchase.PurchasesResult(-1, null);
        }
        if (TextUtils.isEmpty((CharSequence)skuType)) {
            BillingHelper.logWarn((String)TAG, (String)"Please provide a valid SKU type.");
            return new Purchase.PurchasesResult(5, null);
        }
        return this.queryPurchasesInternal(skuType, false);
    }

    @Override
    public void querySkuDetailsAsync(@NotNull SkuDetailsParams params, @NotNull SkuDetailsResponseListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (!this.isReady()) {
            listener.onSkuDetailsResponse(-1, null);
            return;
        }
        String skuType = params.getSkuType();
        List skusList = params.getSkusList();
        if (TextUtils.isEmpty((CharSequence)skuType)) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. SKU type can't be empty.");
            listener.onSkuDetailsResponse(5, null);
            return;
        }
        if (skusList == null) {
            BillingHelper.logWarn((String)TAG, (String)"Please fix the input params. The list of SKUs can't be empty.");
            listener.onSkuDetailsResponse(5, null);
            return;
        }
        this.executeAsync(new Runnable(this, skuType, skusList, listener){
            final /* synthetic */ BillingToto this$0;
            final /* synthetic */ String $skuType;
            final /* synthetic */ List $skusList;
            final /* synthetic */ SkuDetailsResponseListener $listener;

            public final void run() {
                String string = this.$skuType;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"skuType");
                SkuDetails.SkuDetailsResult result = BillingToto.access$querySkuDetailsInternal(this.this$0, string, this.$skusList);
                BillingToto.access$postToUiThread(this.this$0, new Runnable(this, result){
                    final /* synthetic */ querySkuDetailsAsync.1 this$0;
                    final /* synthetic */ SkuDetails.SkuDetailsResult $result;

                    public final void run() {
                        this.this$0.$listener.onSkuDetailsResponse(this.$result.getResponseCode(), this.$result.getSkuDetailsList());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = skuDetailsResult;
                    }
                });
            }
            {
                this.this$0 = billingToto;
                this.$skuType = string;
                this.$skusList = list;
                this.$listener = skuDetailsResponseListener;
            }
        });
    }

    @Override
    public void consumeAsync(@NotNull String purchaseToken, @NotNull ConsumeResponseListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)purchaseToken, (String)"purchaseToken");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (!this.isReady()) {
            listener.onConsumeResponse(-1, null);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)purchaseToken)) {
            BillingHelper.logWarn((String)TAG, (String)"Please provide a valid purchase token got from queryPurchases result.");
            listener.onConsumeResponse(5, purchaseToken);
            return;
        }
        this.executeAsync(new Runnable(this, purchaseToken, listener){
            final /* synthetic */ BillingToto this$0;
            final /* synthetic */ String $purchaseToken;
            final /* synthetic */ ConsumeResponseListener $listener;

            public final void run() {
                BillingToto.access$consumeInternal(this.this$0, this.$purchaseToken, this.$listener);
            }
            {
                this.this$0 = billingToto;
                this.$purchaseToken = string;
                this.$listener = consumeResponseListener;
            }
        });
    }

    @Override
    public void queryPurchaseHistoryAsync(@NotNull String skuType, @NotNull PurchaseHistoryResponseListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)skuType, (String)"skuType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        if (!this.isReady()) {
            listener.onPurchaseHistoryResponse(-1, null);
            return;
        }
        this.executeAsync(new Runnable(this, skuType, listener){
            final /* synthetic */ BillingToto this$0;
            final /* synthetic */ String $skuType;
            final /* synthetic */ PurchaseHistoryResponseListener $listener;

            public final void run() {
                Purchase.PurchasesResult result = BillingToto.access$queryPurchasesInternal(this.this$0, this.$skuType, true);
                BillingToto.access$postToUiThread(this.this$0, new Runnable(this, result){
                    final /* synthetic */ queryPurchaseHistoryAsync.1 this$0;
                    final /* synthetic */ Purchase.PurchasesResult $result;

                    public final void run() {
                        this.this$0.$listener.onPurchaseHistoryResponse(this.$result.getResponseCode(), this.$result.getPurchasesList());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = purchasesResult;
                    }
                });
            }
            {
                this.this$0 = billingToto;
                this.$skuType = string;
                this.$listener = purchaseHistoryResponseListener;
            }
        });
    }

    private final Bundle constructExtraParams(BillingFlowParams params) {
        Bundle extraParams = new Bundle();
        if (params.getReplaceSkusProrationMode() != 0) {
            extraParams.putInt("prorationMode", params.getReplaceSkusProrationMode());
        }
        if (params.getAccountId() != null) {
            extraParams.putString("accountId", params.getAccountId());
        }
        if (params.getVrPurchaseFlow()) {
            extraParams.putBoolean("vr", true);
        }
        if (params.getOldSku() != null) {
            extraParams.putStringArrayList("skusToReplace", new ArrayList(Arrays.asList(params.getOldSku())));
        }
        return extraParams;
    }

    private final void executeAsync(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(BillingHelper.NUMBER_OF_CORES);
        }
        ExecutorService executorService = this.mExecutorService;
        if (executorService == null) {
            Intrinsics.throwNpe();
        }
        executorService.submit(runnable);
    }

    private final int isBillingSupportedOnVr(String skuType) {
        try {
            int supportedResult;
            IInAppBillingService iInAppBillingService = this.mService;
            if (iInAppBillingService == null) {
                Intrinsics.throwNpe();
            }
            return (supportedResult = iInAppBillingService.isBillingSupportedExtraParams(7, this.mApplicationContext.getPackageName(), skuType, this.generateVrBundle())) == 0 ? 0 : -2;
        }
        catch (RemoteException e) {
            BillingHelper.logWarn((String)TAG, (String)"RemoteException while checking if billing is supported; try to reconnect");
            return -1;
        }
    }

    private final Bundle generateVrBundle() {
        Bundle result = new Bundle();
        result.putBoolean("vr", true);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    private final SkuDetails.SkuDetailsResult querySkuDetailsInternal(String skuType, List<String> skuList) {
        ArrayList<SkuDetails> resultList = new ArrayList<SkuDetails>();
        int startIndex = 0;
        List<String> list = skuList;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int listSize = list.size();
        while (startIndex < listSize) {
            Bundle skuDetails;
            int endIndex = startIndex + MAX_SKU_DETAILS_ITEMS_PER_REQUEST;
            if (endIndex > listSize) {
                endIndex = listSize;
            }
            ArrayList curSkuList = new ArrayList(skuList.subList(startIndex, endIndex));
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, curSkuList);
            querySkus.putString(LIBRARY_VERSION_KEY, LIBRARY_VERSION);
            try {
                IInAppBillingService iInAppBillingService = this.mService;
                if (iInAppBillingService == null) {
                    Intrinsics.throwNpe();
                }
                skuDetails = iInAppBillingService.getSkuDetails(3, this.mApplicationContext.getPackageName(), skuType, querySkus);
            }
            catch (RemoteException e) {
                String msg = "querySkuDetailsAsync got a remote exception (try to reconnect): " + (Object)((Object)e);
                BillingHelper.logWarn((String)TAG, (String)msg);
                return new SkuDetails.SkuDetailsResult(-1, null);
            }
            if (skuDetails == null) {
                BillingHelper.logWarn((String)TAG, (String)"querySkuDetailsAsync got null sku details list");
                return new SkuDetails.SkuDetailsResult(4, null);
            }
            if (!skuDetails.containsKey("DETAILS_LIST")) {
                int responseCode = BillingHelper.getResponseCodeFromBundle((Bundle)skuDetails, (String)TAG);
                if (responseCode != 0) {
                    BillingHelper.logWarn((String)TAG, (String)("getSkuDetails() failed. Response code: " + responseCode));
                    return new SkuDetails.SkuDetailsResult(responseCode, (List)resultList);
                }
                BillingHelper.logWarn((String)TAG, (String)"getSkuDetails() returned a bundle with neither an error nor a detail list.");
                return new SkuDetails.SkuDetailsResult(6, (List)resultList);
            }
            ArrayList skuDetailsJsonList = skuDetails.getStringArrayList("DETAILS_LIST");
            if (skuDetailsJsonList == null) {
                BillingHelper.logWarn((String)TAG, (String)"querySkuDetailsAsync got null response list");
                return new SkuDetails.SkuDetailsResult(4, null);
            }
            int msg = 0;
            int n = ((Collection)skuDetailsJsonList).size();
            while (msg < n) {
                SkuDetails currentSkuDetails;
                void i;
                String thisResponse = (String)skuDetailsJsonList.get((int)i);
                try {
                    currentSkuDetails = new SkuDetails(thisResponse);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn((String)TAG, (String)"Got a JSON exception trying to decode SkuDetails");
                    return new SkuDetails.SkuDetailsResult(6, null);
                }
                BillingHelper.logVerbose((String)TAG, (String)("Got sku details: " + currentSkuDetails));
                resultList.add(currentSkuDetails);
                ++i;
            }
            startIndex += MAX_SKU_DETAILS_ITEMS_PER_REQUEST;
        }
        return new SkuDetails.SkuDetailsResult(0, (List)resultList);
    }

    /*
     * WARNING - void declaration
     */
    private final Purchase.PurchasesResult queryPurchasesInternal(String skuType, boolean queryHistory) {
        Bundle ownedItems;
        BillingHelper.logVerbose((String)TAG, (String)("Querying owned items, item type: " + skuType + "; history: " + queryHistory));
        String continueToken = null;
        ArrayList<Purchase> resultList = new ArrayList<Purchase>();
        do {
            try {
                if (queryHistory) {
                    if (!this.mIABv6Supported) {
                        BillingHelper.logWarn((String)TAG, (String)"getPurchaseHistory is not supported on current device");
                        return new Purchase.PurchasesResult(-2, null);
                    }
                    IInAppBillingService iInAppBillingService = this.mService;
                    if (iInAppBillingService == null) {
                        Intrinsics.throwNpe();
                    }
                    ownedItems = iInAppBillingService.getPurchaseHistory(6, this.mApplicationContext.getPackageName(), skuType, continueToken, null);
                } else {
                    IInAppBillingService iInAppBillingService = this.mService;
                    if (iInAppBillingService == null) {
                        Intrinsics.throwNpe();
                    }
                    ownedItems = iInAppBillingService.getPurchases(3, this.mApplicationContext.getPackageName(), skuType, continueToken);
                }
            }
            catch (RemoteException e) {
                BillingHelper.logWarn((String)TAG, (String)("Got exception trying to get purchases: " + (Object)((Object)e) + "; try to reconnect"));
                return new Purchase.PurchasesResult(-1, null);
            }
            if (ownedItems == null) {
                BillingHelper.logWarn((String)TAG, (String)"queryPurchases got null owned items list");
                return new Purchase.PurchasesResult(6, null);
            }
            int responseCode = BillingHelper.getResponseCodeFromBundle((Bundle)ownedItems, (String)TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn((String)TAG, (String)("getPurchases() failed. Response code: " + responseCode));
                return new Purchase.PurchasesResult(responseCode, null);
            }
            if (!(ownedItems.containsKey("INAPP_PURCHASE_ITEM_LIST") && ownedItems.containsKey("INAPP_PURCHASE_DATA_LIST") && ownedItems.containsKey("INAPP_DATA_SIGNATURE_LIST"))) {
                BillingHelper.logWarn((String)TAG, (String)"Bundle returned from getPurchases() doesn't contain required fields.");
                return new Purchase.PurchasesResult(6, null);
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList signatureList = ownedItems.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            if (ownedSkus == null) {
                BillingHelper.logWarn((String)TAG, (String)"Bundle returned from getPurchases() contains null SKUs list.");
                return new Purchase.PurchasesResult(6, null);
            }
            if (purchaseDataList == null) {
                BillingHelper.logWarn((String)TAG, (String)"Bundle returned from getPurchases() contains null purchases list.");
                return new Purchase.PurchasesResult(6, null);
            }
            if (signatureList == null) {
                BillingHelper.logWarn((String)TAG, (String)"Bundle returned from getPurchases() contains null signatures list.");
                return new Purchase.PurchasesResult(6, null);
            }
            int n = 0;
            int n2 = ((Collection)purchaseDataList).size();
            while (n < n2) {
                Purchase purchase;
                void i;
                String purchaseData = (String)purchaseDataList.get((int)i);
                String signature = (String)signatureList.get((int)i);
                String sku = (String)ownedSkus.get((int)i);
                BillingHelper.logVerbose((String)TAG, (String)("Sku is owned: " + sku));
                try {
                    purchase = new Purchase(purchaseData, signature);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn((String)TAG, (String)("Got an exception trying to decode the purchase: " + (Object)((Object)e)));
                    return new Purchase.PurchasesResult(6, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                    BillingHelper.logWarn((String)TAG, (String)"BUG: empty/null token!");
                }
                resultList.add(purchase);
                ++i;
            }
        } while (!TextUtils.isEmpty((CharSequence)(continueToken = ownedItems.getString("INAPP_CONTINUATION_TOKEN"))));
        return new Purchase.PurchasesResult(0, (List)resultList);
    }

    private final void postToUiThread(Runnable runnable) {
        this.mUiThreadHandler.post(runnable);
    }

    @WorkerThread
    private final void consumeInternal(String purchaseToken, ConsumeResponseListener listener) {
        try {
            int responseCode;
            BillingHelper.logVerbose((String)TAG, (String)("Consuming purchase with token: " + purchaseToken));
            IInAppBillingService iInAppBillingService = this.mService;
            if (iInAppBillingService == null) {
                Intrinsics.throwNpe();
            }
            if ((responseCode = iInAppBillingService.consumePurchase(3, this.mApplicationContext.getPackageName(), purchaseToken)) == 0) {
                BillingHelper.logVerbose((String)TAG, (String)"Successfully consumed purchase.");
                if (listener != null) {
                    this.postToUiThread(new Runnable(listener, responseCode, purchaseToken){
                        final /* synthetic */ ConsumeResponseListener $listener;
                        final /* synthetic */ int $responseCode;
                        final /* synthetic */ String $purchaseToken;

                        public final void run() {
                            this.$listener.onConsumeResponse(this.$responseCode, this.$purchaseToken);
                        }
                        {
                            this.$listener = consumeResponseListener;
                            this.$responseCode = n;
                            this.$purchaseToken = string;
                        }
                    });
                }
            } else {
                BillingHelper.logWarn((String)TAG, (String)("Error consuming purchase with token. Response code: " + responseCode));
                this.postToUiThread(new Runnable(listener, responseCode, purchaseToken){
                    final /* synthetic */ ConsumeResponseListener $listener;
                    final /* synthetic */ int $responseCode;
                    final /* synthetic */ String $purchaseToken;

                    public final void run() {
                        BillingHelper.logWarn((String)BillingToto.access$getTAG$cp(), (String)"Error consuming purchase.");
                        ConsumeResponseListener consumeResponseListener = this.$listener;
                        if (consumeResponseListener == null) {
                            Intrinsics.throwNpe();
                        }
                        consumeResponseListener.onConsumeResponse(this.$responseCode, this.$purchaseToken);
                    }
                    {
                        this.$listener = consumeResponseListener;
                        this.$responseCode = n;
                        this.$purchaseToken = string;
                    }
                });
            }
        }
        catch (RemoteException e) {
            this.postToUiThread(new Runnable(e, listener, purchaseToken){
                final /* synthetic */ RemoteException $e;
                final /* synthetic */ ConsumeResponseListener $listener;
                final /* synthetic */ String $purchaseToken;

                public final void run() {
                    BillingHelper.logWarn((String)BillingToto.access$getTAG$cp(), (String)("Error consuming purchase; ex: " + (Object)((Object)this.$e)));
                    ConsumeResponseListener consumeResponseListener = this.$listener;
                    if (consumeResponseListener == null) {
                        Intrinsics.throwNpe();
                    }
                    consumeResponseListener.onConsumeResponse(-1, this.$purchaseToken);
                }
                {
                    this.$e = remoteException;
                    this.$listener = consumeResponseListener;
                    this.$purchaseToken = string;
                }
            });
        }
    }

    @UiThread
    public BillingToto(@NotNull Context context, @NotNull PurchasesUpdatedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mUiThreadHandler = new Handler();
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this.mApplicationContext = context2;
        this.mBroadcastManager = new BillingBroadcastManager(this.mApplicationContext, listener);
        this.onPurchaseFinishedReceiver = new BroadcastReceiver(this){
            final /* synthetic */ BillingToto this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                PurchasesUpdatedListener purchasesUpdatedListener;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                BillingBroadcastManager billingBroadcastManager = BillingToto.access$getMBroadcastManager$p(this.this$0);
                Object object = purchasesUpdatedListener = billingBroadcastManager != null ? billingBroadcastManager.getListener() : null;
                if (purchasesUpdatedListener == null) {
                    BillingHelper.logWarn((String)BillingToto.access$getTAG$cp(), (String)"PurchasesUpdatedListener is null - no way to return the response.");
                    return;
                }
                int responseCode = intent.getIntExtra("response_code_key", 6);
                Bundle resultData = intent.getBundleExtra("response_bundle_key");
                List purchases = BillingHelper.extractPurchases((Bundle)resultData);
                purchasesUpdatedListener.onPurchasesUpdated(responseCode, purchases);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    static {
        TAG = TAG;
        MAX_SKU_DETAILS_ITEMS_PER_REQUEST = 20;
        GET_SKU_DETAILS_ITEM_LIST = GET_SKU_DETAILS_ITEM_LIST;
        LIBRARY_VERSION_KEY = LIBRARY_VERSION_KEY;
        LIBRARY_VERSION = LIBRARY_VERSION;
    }

    public static final /* synthetic */ int access$getMClientState$p(BillingToto $this) {
        return $this.mClientState;
    }

    public static final /* synthetic */ boolean access$getMSubscriptionsSupported$p(BillingToto $this) {
        return $this.mSubscriptionsSupported;
    }

    public static final /* synthetic */ boolean access$getMSubscriptionUpdateSupported$p(BillingToto $this) {
        return $this.mSubscriptionUpdateSupported;
    }

    @NotNull
    public static final /* synthetic */ SkuDetails.SkuDetailsResult access$querySkuDetailsInternal(BillingToto $this, @NotNull String skuType, @Nullable List skuList) {
        return $this.querySkuDetailsInternal(skuType, skuList);
    }

    public static final /* synthetic */ void access$postToUiThread(BillingToto $this, @NotNull Runnable runnable) {
        $this.postToUiThread(runnable);
    }

    public static final /* synthetic */ void access$consumeInternal(BillingToto $this, @NotNull String purchaseToken, @Nullable ConsumeResponseListener listener) {
        $this.consumeInternal(purchaseToken, listener);
    }

    @NotNull
    public static final /* synthetic */ Purchase.PurchasesResult access$queryPurchasesInternal(BillingToto $this, @NotNull String skuType, boolean queryHistory) {
        return $this.queryPurchasesInternal(skuType, queryHistory);
    }

    @NotNull
    public static final /* synthetic */ BillingBroadcastManager access$getMBroadcastManager$p(BillingToto $this) {
        return $this.mBroadcastManager;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/billingclient/api/BillingToto$ClientState;", "", "()V", "Companion", "unitybuy_release"})
    public static final class ClientState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
        public static final Companion Companion = new Companion(null);

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/billingclient/api/BillingToto$ClientState$Companion;", "", "()V", "CLOSED", "", "CONNECTED", "CONNECTING", "DISCONNECTED", "unitybuy_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/billingclient/api/BillingToto$BillingServiceConnection;", "Landroid/content/ServiceConnection;", "mListener", "Lcom/android/billingclient/api/BillingClientStateListener;", "(Lcom/android/billingclient/api/BillingToto;Lcom/android/billingclient/api/BillingClientStateListener;)V", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "unitybuy_release"})
    private final class BillingServiceConnection
    implements ServiceConnection {
        private final BillingClientStateListener mListener;

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            BillingHelper.logWarn((String)TAG, (String)"Billing service disconnected.");
            BillingToto.this.mService = null;
            BillingToto.this.mClientState = 0;
            this.mListener.onBillingServiceDisconnected();
        }

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
            BillingHelper.logVerbose((String)TAG, (String)"Billing service connected.");
            BillingToto.this.mService = IInAppBillingService.Stub.asInterface((IBinder)service);
            String packageName = BillingToto.this.mApplicationContext.getPackageName();
            BillingToto.this.mSubscriptionsSupported = false;
            BillingToto.this.mSubscriptionUpdateSupported = false;
            BillingToto.this.mIABv6Supported = false;
            try {
                int response;
                IInAppBillingService iInAppBillingService = BillingToto.this.mService;
                if (iInAppBillingService == null) {
                    Intrinsics.throwNpe();
                }
                if ((response = iInAppBillingService.isBillingSupported(6, packageName, "subs")) == 0) {
                    BillingHelper.logVerbose((String)TAG, (String)"In-app billing API version 6 with subs is supported.");
                    BillingToto.this.mIABv6Supported = true;
                    BillingToto.this.mSubscriptionsSupported = true;
                    BillingToto.this.mSubscriptionUpdateSupported = true;
                } else {
                    IInAppBillingService iInAppBillingService2 = BillingToto.this.mService;
                    if (iInAppBillingService2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((response = iInAppBillingService2.isBillingSupported(6, packageName, "inapp")) == 0) {
                        BillingHelper.logVerbose((String)TAG, (String)"In-app billing API without subs version 6 supported.");
                        BillingToto.this.mIABv6Supported = true;
                    }
                    IInAppBillingService iInAppBillingService3 = BillingToto.this.mService;
                    if (iInAppBillingService3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((response = iInAppBillingService3.isBillingSupported(5, packageName, "subs")) == 0) {
                        BillingHelper.logVerbose((String)TAG, (String)"In-app billing API version 5 supported.");
                        BillingToto.this.mSubscriptionUpdateSupported = true;
                        BillingToto.this.mSubscriptionsSupported = true;
                    } else {
                        IInAppBillingService iInAppBillingService4 = BillingToto.this.mService;
                        if (iInAppBillingService4 == null) {
                            Intrinsics.throwNpe();
                        }
                        if ((response = iInAppBillingService4.isBillingSupported(3, packageName, "subs")) == 0) {
                            BillingHelper.logVerbose((String)TAG, (String)"In-app billing API version 3 with subscriptions is supported.");
                            BillingToto.this.mSubscriptionsSupported = true;
                        } else if (BillingToto.this.mIABv6Supported) {
                            response = 0;
                        } else {
                            IInAppBillingService iInAppBillingService5 = BillingToto.this.mService;
                            if (iInAppBillingService5 == null) {
                                Intrinsics.throwNpe();
                            }
                            if ((response = iInAppBillingService5.isBillingSupported(3, packageName, "inapp")) == 0) {
                                BillingHelper.logVerbose((String)TAG, (String)"In-app billing API version 3 with in-app items is supported.");
                            } else {
                                BillingHelper.logWarn((String)TAG, (String)"Even billing API version 3 is not supported on this device.");
                            }
                        }
                    }
                }
                if (response == 0) {
                    BillingToto.this.mClientState = 2;
                } else {
                    BillingToto.this.mClientState = 0;
                    BillingToto.this.mService = null;
                }
                this.mListener.onBillingSetupFinished(response);
            }
            catch (RemoteException e) {
                BillingHelper.logWarn((String)TAG, (String)("RemoteException while setting up in-app billing" + (Object)((Object)e)));
                BillingToto.this.mClientState = 0;
                BillingToto.this.mService = null;
                this.mListener.onBillingSetupFinished(-1);
            }
        }

        public BillingServiceConnection(BillingClientStateListener mListener) {
            Intrinsics.checkParameterIsNotNull((Object)mListener, (String)"mListener");
            this.mListener = mListener;
            if (this.mListener == null) {
                throw (Throwable)new RuntimeException("Please specify a listener to know when init is done.");
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/billingclient/api/BillingToto$Companion;", "", "()V", "GET_SKU_DETAILS_ITEM_LIST", "", "LIBRARY_VERSION", "LIBRARY_VERSION_KEY", "MAX_SKU_DETAILS_ITEMS_PER_REQUEST", "", "TAG", "unitybuy_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

