package com.unitypay.billingmodule;

import android.text.TextUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;


public class Md5Util {

    public static String getFileMD5(File file) {

        if (!file.isFile()) {

            return null;

        }
        MessageDigest digest = null;
        FileInputStream in = null;

        byte buffer[] = new byte[1024];
        int len;

        try {

            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);

            while((len = in.read(buffer, 0, 1024)) != -1) {

                digest.update(buffer, 0, len);
            }

            in.close();
        } catch (Exception e) {

            return null;
        }
        return encodeHex(digest.digest());
    }

    public static String getPackageNameMd5(String packageName) {
        if (packageName == null) {
            return null;
        } else {
            return getStringMd5(packageName + "ijinshan");
        }
    }

    /***
     * 路径 md5
     * @param filePath 为空代表SDCard根目录
     *
     */

    public static String getFilePathMd5(String filePath) {

        // 去掉'/'，数据库路径加密不带最开始的'/'
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }

        if (TextUtils.isEmpty(filePath)) {
            return "";
        }

        String[] s = filePath.split("/");

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length; i++) {
            if (!TextUtils.isEmpty(s[i])) {

                sb.append(getStringMd5( s[i].toLowerCase() + "ijinshan"));
            }
            if (i != s.length - 1)
                sb.append('+');
        }
        return sb.toString();
    }


    public static String getStringMd5(String plainText) {

        MessageDigest md = null;

        try {

            md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());

        }catch(Exception e){

            return null;

        }

        return encodeHex(md.digest());

    }

    public static String getStreamMD5(InputStream in) {

        if (in == null){
            return null;
        }

        MessageDigest md = null;

        byte buffer[] = new byte[1024];
        int len;

        try {

            md = MessageDigest.getInstance("MD5");

            while((len = in.read(buffer, 0, 1024)) != -1) {

                md.update(buffer, 0, len);
            }

            in.close();
        } catch (Exception e) {

            return null;
        }

        return encodeHex(md.digest());

    }

    public static String getByteArrayMD5(byte[] data) {

        if (null == data) {
            return null;
        }

        MessageDigest md = null;

        try {

            md = MessageDigest.getInstance("MD5");
            md.update(data);

        }catch(Exception e){

            return null;

        }

        return encodeHex(md.digest());
    }


    public static String encodeHex(byte[] data) {

        if (data == null) {

            return null;
        }

        final String HEXES = "0123456789abcdef";
        int len = data.length;
        StringBuilder hex = new StringBuilder(len * 2);

        for(int i = 0; i < len; ++i) {

            hex.append(HEXES.charAt((data[i] & 0xF0) >>> 4));
            hex.append(HEXES.charAt((data[i] & 0x0F)));
        }

        return hex.toString();
    }
}

