package com.unitypay.billingmodule

import android.content.Context
import android.content.Context.MODE_PRIVATE
import org.json.JSONObject

class FileUtils {

    val FailName = "unityPayFaile.txt"

    fun saveFaileToken(context: Context, faileString: String) {
        val txtString = readFileData(context, FailName)
        if (txtString.isNotEmpty()) {
            val objects = JSONObject(txtString)
            val tokenString = objects.getString("token")
            if (tokenString.isNotEmpty()) {
                objects.put("token", faileString)
                writeFileData(context, objects.toString())
            }
        } else {
            val objects = JSONObject()
            objects.put("token", faileString)
            writeFileData(context, objects.toString())
        }
    }

    fun getFaileToken(context: Context): String {
        val txtString = readFileData(context, FailName)
        if (txtString.isNotEmpty()) {
            val objects = JSONObject(txtString)
            val tokenString = objects.getString("token")
            if (tokenString.isNotEmpty()) {
                return tokenString
            }
        }
        return ""
    }


    fun writeFileData(context: Context, json: String) {
        try {
            val fos = context.openFileOutput(FailName, MODE_PRIVATE);//获得FileOutputStream
            //将要写入的字符串转换为byte数组
            val bytes = json.toByteArray()
            fos.write(bytes);//将byte数组写入文件
            fos.close();//关闭文件输出流
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun readFileData(context: Context, fileName: String): String {
        var result = ""
        try {
            val fis = context.openFileInput(fileName)
            //获取文件长
            fis.buffered().reader().use {
                result = it.readText()
            }
            fis.close()
            //将byte数组转换成指定格式的字符串
        } catch (e: Exception) {
            e.printStackTrace();
        }

        return result;
    }
}