/*
 * Decompiled with CFR 0.152.
 */
package github.frosquivel.infinitescroll.Logic;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import github.frosquivel.infinitescroll.Logic.InfiniteScrollRecycler;
import github.frosquivel.infinitescroll.Model.InfiniteScrollObject;
import github.frosquivel.infinitescroll.Utils.InfiniteScrollUtil;

public abstract class InfiniteRecyclerOnScrollListener
extends InfiniteScrollRecycler {
    protected InfiniteScrollObject infiniteScrollObject;
    private LinearLayoutManager linearLayoutManager;
    private RecyclerView recyclerView;
    private static int scrollStatusCount;
    private static boolean scrollFinalStatus;

    public InfiniteRecyclerOnScrollListener(RecyclerView recyclerView, Activity activity, InfiniteScrollObject infiniteScrollObject) {
        this.recyclerView = recyclerView;
        this.infiniteScrollObject = infiniteScrollObject;
        this.infiniteScrollObject.setLoading(true);
        this.infiniteScrollObject.setPreviousTotalItemCount(0);
        this.infiniteScrollObject.setCurrentPage(this.infiniteScrollObject.getCurrentPage() + 1, false);
        this.linearLayoutManager = new LinearLayoutManager((Context)activity);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (newState == 1) {
            scrollStatusCount = 0;
        } else if (newState == 2) {
            ++scrollStatusCount;
        } else if (newState == 0) {
            ++scrollStatusCount;
        }
        if (scrollStatusCount == 1) {
            this.goneProgressBar();
        }
    }

    @Override
    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        this.infiniteScrollObject.setVisibleItemCount(recyclerView.getChildCount());
        this.infiniteScrollObject.setTotalItemCount(this.linearLayoutManager.getItemCount());
        this.infiniteScrollObject.setFirstVisibleItem(this.linearLayoutManager.findFirstVisibleItemPosition());
        if (this.infiniteScrollObject.isLoading() && this.infiniteScrollObject.getTotalItemCount() > this.infiniteScrollObject.getPreviousTotalItemCount()) {
            this.infiniteScrollObject.setLoading(false);
            this.infiniteScrollObject.setPreviousTotalItemCount(this.infiniteScrollObject.getTotalItemCount());
        }
        int size = 0;
        if (!this.infiniteScrollObject.isLoading() && this.infiniteScrollObject.getTotalItemCount() - this.infiniteScrollObject.getVisibleItemCount() <= this.infiniteScrollObject.getFirstVisibleItem() + this.infiniteScrollObject.getMinimunNumberRowLoadingMore() && InfiniteScrollUtil.isNetworkAvailable(this.infiniteScrollObject.getActivity())) {
            this.infiniteScrollObject.setCurrentPage(this.infiniteScrollObject.getCurrentPage() + 1, false);
            size = this.onLoadMore(this.infiniteScrollObject.getCurrentPage(), this.infiniteScrollObject.getTotalItemCount());
            this.infiniteScrollObject.setLoading(size > 0);
        }
        if (!scrollFinalStatus && this.infiniteScrollObject.getProgressBar() != null) {
            this.infiniteScrollObject.getProgressBar().setVisibility(this.infiniteScrollObject.isLoading() ? 0 : 8);
        }
        if (this.infiniteScrollObject.isLoading() && this.infiniteScrollObject.getVisibleItemCount() < 14 & this.infiniteScrollObject.getTotalItemCount() < 14) {
            this.goneProgressBar();
        }
    }

    private void goneProgressBar() {
        try {
            if (this.infiniteScrollObject.getProgressBar() != null) {
                this.infiniteScrollObject.getProgressBar().setVisibility(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract int onLoadMore(int var1, int var2);

    static {
        scrollFinalStatus = false;
    }
}

