/*
 * Decompiled with CFR 0.152.
 */
package github.frosquivel.infinitescroll.Logic;

import android.widget.AbsListView;
import android.widget.ListView;
import github.frosquivel.infinitescroll.Logic.InfiniteScrollList;
import github.frosquivel.infinitescroll.Model.InfiniteScrollObject;
import github.frosquivel.infinitescroll.Utils.InfiniteScrollUtil;

public abstract class InfiniteListOnScrollListener
extends InfiniteScrollList {
    protected InfiniteScrollObject infiniteScrollObject;
    private static int scrollStatusCount;

    public InfiniteListOnScrollListener(InfiniteScrollObject infiniteScrollObject) {
        this.infiniteScrollObject = infiniteScrollObject;
        scrollStatusCount = 0;
    }

    public abstract int onLoadMoreData(int var1, int var2, ListView var3);

    @Override
    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (InfiniteScrollUtil.isNetworkAvailable(this.infiniteScrollObject.getActivity())) {
            this.infiniteScrollObject.setFirstVisibleItem(firstVisibleItem);
            this.infiniteScrollObject.setVisibleItemCount(visibleItemCount);
            this.infiniteScrollObject.setTotalItemCount(totalItemCount);
            if (totalItemCount < this.infiniteScrollObject.getPreviousTotalItemCount()) {
                this.infiniteScrollObject.setCurrentPage(0, false);
                this.infiniteScrollObject.setPreviousTotalItemCount(totalItemCount);
                if (totalItemCount == 0) {
                    this.infiniteScrollObject.setLoading(true);
                }
            }
            int size = 0;
            if (InfiniteScrollUtil.isNetworkAvailable(this.infiniteScrollObject.getActivity()) && !this.infiniteScrollObject.isLoading() && firstVisibleItem + visibleItemCount + this.infiniteScrollObject.getMinimunNumberRowLoadingMore() >= totalItemCount) {
                size = this.onLoadMoreData(this.infiniteScrollObject.getCurrentPage() + 1, totalItemCount, (ListView)view);
                this.infiniteScrollObject.setLoading(size > 0);
            }
            if (this.infiniteScrollObject.getProgressBar() != null) {
                this.infiniteScrollObject.getProgressBar().setVisibility(this.infiniteScrollObject.isLoading() ? 0 : 8);
            }
            if (InfiniteScrollUtil.isNetworkAvailable(this.infiniteScrollObject.getActivity())) {
                if (this.infiniteScrollObject.isLoading() && totalItemCount > this.infiniteScrollObject.getPreviousTotalItemCount()) {
                    this.infiniteScrollObject.setLoading(false);
                    this.infiniteScrollObject.setPreviousTotalItemCount(totalItemCount);
                    this.infiniteScrollObject.setCurrentPage(this.infiniteScrollObject.getCurrentPage() + 1, false);
                } else if (scrollStatusCount == 2) {
                    this.goneProgressBar();
                }
            } else {
                this.infiniteScrollObject.setLoading(false);
            }
            if (this.infiniteScrollObject.isLoading() && visibleItemCount < 14 & totalItemCount < 14) {
                this.goneProgressBar();
            }
        } else {
            this.infiniteScrollObject.setLoading(false);
        }
    }

    @Override
    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 1) {
            scrollStatusCount = 0;
        } else if (scrollState == 0) {
            ++scrollStatusCount;
        } else if (scrollState == 2) {
            ++scrollStatusCount;
        }
        if (scrollStatusCount == 1) {
            this.goneProgressBar();
        }
    }

    private void goneProgressBar() {
        try {
            if (this.infiniteScrollObject.getProgressBar() != null) {
                this.infiniteScrollObject.getProgressBar().setVisibility(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

