/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.model;

import com.github.kilianB.sonos.ParserHelper;

public class TrackMetadata {
    private final String title;
    private final String creator;
    private final String albumArtist;
    private final String album;
    private final String albumArtURI;

    public TrackMetadata(String title, String creator, String albumArtist, String album, String albumArtURI) {
        this.title = title;
        this.creator = creator;
        this.albumArtist = albumArtist;
        this.album = album;
        this.albumArtURI = albumArtURI;
    }

    public static TrackMetadata parse(String metadata) {
        return new TrackMetadata(ParserHelper.findOne("<dc:title>(.*)</dc:title>", metadata), ParserHelper.findOne("<dc:creator>(.*)</dc:creator>", metadata), ParserHelper.findOne("<r:albumArtist>(.*)</r:albumArtist>", metadata), ParserHelper.findOne("<upnp:album>(.*)</upnp:album>", metadata), ParserHelper.findOne("<upnp:albumArtURI>(.*)</upnp:albumArtURI>", metadata));
    }

    public String getTitle() {
        return this.title;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtURI() {
        return this.albumArtURI;
    }

    public String toString() {
        return "TrackMetadata{title='" + this.title + "', creator='" + this.creator + "', albumArtist='" + this.albumArtist + "', album='" + this.album + "', albumArtURI='" + this.albumArtURI + "'}";
    }

    public String toDIDL() {
        return "<DIDL-Lite xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" xmlns:r=\"urn:schemas-rinconnetworks-com:metadata-1-0/\" xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\"><item><dc:title>" + this.title + "</dc:title><dc:creator>" + this.creator + "</dc:creator><dc:albumArtist>" + this.albumArtist + "</dc:albumArtist><upnp:album>" + this.album + "</upnp:album><upnp:albumArtURI>" + this.albumArtURI + "</upnp:albumArtURI></item></DIDL-Lite>";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.album == null ? 0 : this.album.hashCode());
        result = 31 * result + (this.albumArtURI == null ? 0 : this.albumArtURI.hashCode());
        result = 31 * result + (this.albumArtist == null ? 0 : this.albumArtist.hashCode());
        result = 31 * result + (this.creator == null ? 0 : this.creator.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackMetadata other = (TrackMetadata)obj;
        if (this.album == null ? other.album != null : !this.album.equals(other.album)) {
            return false;
        }
        if (this.albumArtURI == null ? other.albumArtURI != null : !this.albumArtURI.equals(other.albumArtURI)) {
            return false;
        }
        if (this.albumArtist == null ? other.albumArtist != null : !this.albumArtist.equals(other.albumArtist)) {
            return false;
        }
        if (this.creator == null ? other.creator != null : !this.creator.equals(other.creator)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

