/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;

public class NetworkUtil {
    public static InetAddress resolveSiteLocalAddress() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface curInterface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = curInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress curInetAddress = addresses.nextElement();
                if (!curInetAddress.isSiteLocalAddress()) continue;
                return curInetAddress;
            }
        }
        return InetAddress.getLocalHost();
    }

    public static String dumpReader(BufferedReader br) throws IOException {
        String temp;
        StringBuilder response = new StringBuilder();
        while ((temp = br.readLine()) != null) {
            response.append(temp).append(System.lineSeparator());
        }
        return response.toString();
    }

    public static String collectSocketAndClose(Socket s) throws IOException {
        String result = NetworkUtil.collectSocket(s);
        s.close();
        return result;
    }

    public static String collectSocket(Socket s) throws IOException {
        InputStream is = s.getInputStream();
        StringBuilder sb = new StringBuilder();
        while (is.available() > 0) {
            int b = is.read();
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static String collectSocketWithTimeout(Socket s, int msTimeout) throws IOException {
        int oldTimeout = s.getSoTimeout();
        s.setSoTimeout(msTimeout);
        InputStream is = s.getInputStream();
        StringBuilder sb = new StringBuilder();
        try {
            while (!s.isClosed()) {
                sb.append((char)is.read());
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        s.setSoTimeout(oldTimeout);
        return sb.toString();
    }
}

