/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.util;

import com.google.devtools.j2objc.J2ObjC;
import java.io.UnsupportedEncodingException;

public final class UnicodeUtils {
    private UnicodeUtils() {
    }

    public static String escapeCharLiteral(char c) {
        if (c >= ' ' && c <= '~') {
            switch (c) {
                case '\'': {
                    return "'\\''";
                }
                case '\\': {
                    return "'\\\\'";
                }
            }
            return "'" + c + "'";
        }
        return String.format("0x%04x", c);
    }

    public static String escapeStringLiteral(String string) {
        StringBuilder stringBuilder = null;
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = UnicodeUtils.escapeCharacterForStringLiteral(string.charAt(i), string, i);
            if (string2 == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (n2 < i) {
                stringBuilder.append(string.substring(n2, i));
            }
            n2 = i + 1;
            stringBuilder.append(string2);
        }
        if (stringBuilder != null) {
            stringBuilder.append(string.substring(n2, n));
            return stringBuilder.toString();
        }
        return string;
    }

    private static String escapeCharacterForStringLiteral(char c, String string, int n) {
        switch (c) {
            case '\\': {
                return "\\\\";
            }
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
        }
        if (c >= ' ' && c <= '~') {
            return null;
        }
        if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
            if (n + 1 < string.length() && UnicodeUtils.isHexChar(string.charAt(n + 1))) {
                return UnicodeUtils.escapeUtf8(c) + "\"\"";
            }
            return UnicodeUtils.escapeUtf8(c);
        }
        if (!UnicodeUtils.isValidCppCharacter(c)) {
            J2ObjC.error(String.format("Illegal C/C++ Unicode character \\u%4x in \"%s\"", c, string));
        }
        return "\\u" + String.format("%04x", c);
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static boolean hasValidCppCharacters(String string) {
        for (char c : string.toCharArray()) {
            if (UnicodeUtils.isValidCppCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private static String escapeUtf8(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Character.toString(c);
        try {
            for (byte by : string.getBytes("UTF-8")) {
                int n = by & 0xFF;
                stringBuilder.append("\\x");
                if (n < 16) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toHexString(n));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 is an unsupported encoding");
        }
        return stringBuilder.toString();
    }

    public static boolean isValidCppCharacter(char c) {
        return c < '\ud800' || c >= '\uf900' && c <= '\ufad9' || c >= '\ufb50' && c <= '\ufbc1' || c >= '\ufbd3' && c <= '\ufd3f' || c >= '\ufd5f' && c <= '\ufd8f' || c >= '\ufc92' && c <= '\ufdc7' || c >= '\ufdf0' && c <= '\ufdfd' || c >= '\ufe10' && c <= '\ufe19' || c >= '\ufe20' && c <= '\ufe26' || c >= '\ufe30' && c <= '\ufe4f' || c >= '\ufe50' && c <= '\ufe52' || c >= '\ufe54' && c <= '\ufe66' || c >= '\ufe68' && c <= '\ufe6b' || c >= '\ufe70' && c <= '\ufe74' || c >= '\ufe76' && c <= '\ufefc' || c == '\ufeff' || c >= '\uff01' && c <= '\uffbe' || c >= '\uffc2' && c <= '\uffc7' || c >= '\uffca' && c <= '\uffcf' || c >= '\uffd2' && c <= '\uffd7' || c >= '\uffda' && c <= '\uffdc' || c >= '\uffe0' && c <= '\uffe6' || c >= '\uffe8' && c <= '\uffee' || c >= '\ufff9' && c <= '\ufffd';
    }
}

