/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.base.Preconditions;
import com.google.devtools.j2objc.types.AbstractTypeBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class PointerTypeBinding
extends AbstractTypeBinding {
    private final ITypeBinding pointeeType;

    public PointerTypeBinding(ITypeBinding iTypeBinding) {
        this.pointeeType = (ITypeBinding)Preconditions.checkNotNull((Object)iTypeBinding);
    }

    public ITypeBinding getPointeeType() {
        return this.pointeeType;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public String getKey() {
        return this.pointeeType.getKey() + "*";
    }

    public String getName() {
        return this.pointeeType.getName() + "_p";
    }

    public String getQualifiedName() {
        return this.pointeeType.getQualifiedName() + "*";
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (!(iBinding instanceof PointerTypeBinding)) {
            return false;
        }
        return this.pointeeType.isEqualTo((IBinding)((PointerTypeBinding)iBinding).pointeeType);
    }

    public boolean isAssignmentCompatible(ITypeBinding iTypeBinding) {
        if (!(iTypeBinding instanceof PointerTypeBinding)) {
            return false;
        }
        return this.pointeeType.isAssignmentCompatible(((PointerTypeBinding)iTypeBinding).pointeeType);
    }
}

