/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.Sets;
import com.google.devtools.j2objc.types.GeneratedTypeBinding;
import com.google.devtools.j2objc.types.Import;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class ImplementationImportCollector
extends ErrorReportingASTVisitor {
    private String mainTypeName;
    private Set<Import> imports = Sets.newLinkedHashSet();
    private Set<Import> declaredTypes = Sets.newHashSet();

    public void collect(CompilationUnit compilationUnit, String string) {
        this.mainTypeName = NameTable.getMainTypeName(compilationUnit, string);
        this.run((ASTNode)compilationUnit);
        for (Import import_ : this.declaredTypes) {
            this.imports.remove(import_);
        }
    }

    public Set<Import> getImports() {
        return this.imports;
    }

    private void addImports(Type type) {
        if (type != null) {
            this.addImports(Types.getTypeBinding(type));
        }
    }

    private void addImports(ITypeBinding iTypeBinding) {
        Import.addImports(iTypeBinding, this.imports);
    }

    private void addDeclaredType(ITypeBinding iTypeBinding, boolean bl) {
        if (iTypeBinding != null && !NameTable.getFullName(iTypeBinding).equals(this.mainTypeName + (bl ? "Enum" : ""))) {
            Import.addImports(iTypeBinding, this.declaredTypes);
        }
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(annotationTypeDeclaration);
        this.addImports(iTypeBinding);
        this.addDeclaredType(iTypeBinding, false);
        this.addImports(Types.resolveIOSType("IOSClass"));
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        this.addImports(annotationTypeMemberDeclaration.getType());
        return true;
    }

    public boolean visit(Assignment assignment) {
        if (assignment.getOperator() == Assignment.Operator.PLUS_ASSIGN && Types.isJavaStringType(Types.getTypeBinding(assignment.getLeftHandSide())) && Types.isBooleanType(Types.getTypeBinding(assignment.getRightHandSide()))) {
            this.addImports(assignment.getAST().resolveWellKnownType("java.lang.Boolean"));
        }
        return true;
    }

    public boolean visit(CastExpression castExpression) {
        this.addImports(castExpression.getType());
        return true;
    }

    public boolean visit(CatchClause catchClause) {
        this.addImports(catchClause.getException().getType());
        return true;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.addImports(classInstanceCreation.getType());
        IMethodBinding iMethodBinding = Types.getMethodBinding(classInstanceCreation);
        if (iMethodBinding != null) {
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            for (int i = 0; i < classInstanceCreation.arguments().size(); ++i) {
                ITypeBinding iTypeBinding;
                ITypeBinding iTypeBinding2 = i < iTypeBindingArray.length ? iTypeBindingArray[i] : iTypeBindingArray[iTypeBindingArray.length - 1];
                if (!iTypeBinding2.equals(iTypeBinding = Types.getTypeBinding(classInstanceCreation.arguments().get(i))) && iTypeBinding.isAssignmentCompatible(iTypeBinding2)) {
                    this.addImports(iTypeBinding);
                    continue;
                }
                this.addImports(iTypeBinding2);
            }
        }
        return true;
    }

    public boolean visit(TryStatement tryStatement) {
        if (ASTUtil.getResources(tryStatement).size() > 0) {
            this.addImports(Types.mapTypeName("java.lang.Throwable"));
        }
        return true;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeLiteral.getType());
        if (iTypeBinding.isPrimitive()) {
            this.addImports(Types.getWrapperType(iTypeBinding));
        } else {
            this.addImports(iTypeBinding);
            this.addImports(Types.resolveIOSType("IOSClass"));
        }
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(enumDeclaration);
        this.addImports(iTypeBinding);
        this.addDeclaredType(iTypeBinding, true);
        this.addImports(Types.resolveIOSType("IOSClass"));
        this.addImports(GeneratedTypeBinding.newTypeBinding("java.lang.IllegalArgumentException", Types.resolveJavaType("java.lang.RuntimeException"), false));
        return true;
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.addImports(Types.getTypeBinding(fieldAccess.getName()));
        return true;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        this.addImports(fieldDeclaration.getType());
        return true;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        this.addImports(Types.getTypeBinding(instanceofExpression.getRightOperand()));
        return true;
    }

    public boolean visit(InfixExpression infixExpression) {
        if (Types.isJavaStringType(Types.getTypeBinding(infixExpression))) {
            boolean bl = false;
            if (Types.isBooleanType(Types.getTypeBinding(infixExpression.getLeftOperand())) || Types.isBooleanType(Types.getTypeBinding(infixExpression.getRightOperand()))) {
                bl = true;
            } else {
                for (Expression expression : ASTUtil.getExtendedOperands(infixExpression)) {
                    if (!Types.isBooleanType(Types.getTypeBinding(expression))) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.addImports(infixExpression.getAST().resolveWellKnownType("java.lang.Boolean"));
            }
        }
        return true;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        return this.visitAnnotation((Annotation)markerAnnotation);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.addImports(methodDeclaration.getReturnType2());
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        for (ITypeBinding iTypeBinding : iMethodBinding.getExceptionTypes()) {
            this.addImports(iTypeBinding);
            this.addImports(Types.resolveIOSType("IOSClass"));
        }
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        Expression expression;
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodInvocation);
        this.addImports(iMethodBinding.getReturnType());
        IMethodBinding iMethodBinding2 = Types.getMethodBinding(methodInvocation);
        if (iMethodBinding2 != null) {
            expression = iMethodBinding2.getParameterTypes();
            int n = ((Expression)expression).length;
            if (iMethodBinding2.isVarargs()) {
                this.addImports((ITypeBinding)expression[n - 1]);
                --n;
            }
            for (int i = 0; i < n; ++i) {
                Expression expression2 = expression[i];
                ITypeBinding iTypeBinding = Types.getTypeBinding(methodInvocation.arguments().get(i));
                if (expression2.equals(iTypeBinding) || !iTypeBinding.isAssignmentCompatible((ITypeBinding)expression2)) continue;
                this.addImports(iTypeBinding);
            }
        }
        if ((expression = methodInvocation.getExpression()) == null) {
            ITypeBinding iTypeBinding;
            if (iMethodBinding2 != null && (iTypeBinding = iMethodBinding2.getDeclaringClass()) != null) {
                this.addImports(iTypeBinding);
            }
        } else {
            IMethodBinding iMethodBinding3 = Types.getMethodBinding(expression);
            if (iMethodBinding3 != null && !iMethodBinding3.isConstructor()) {
                this.addImports(iMethodBinding3.getReturnType());
            }
            if (iMethodBinding3 == null) {
                IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
                if (iVariableBinding == null || iVariableBinding.isEnumConstant()) {
                    this.addImports(Types.getTypeBinding(expression));
                } else {
                    this.addImports(iVariableBinding.getType());
                }
            }
        }
        while (expression != null && expression instanceof Name) {
            ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
            if (iTypeBinding != null && iTypeBinding.isClass()) {
                this.addImports(iTypeBinding);
                break;
            }
            if (!(expression instanceof QualifiedName)) break;
            expression = ((QualifiedName)expression).getQualifier();
        }
        return true;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        return this.visitAnnotation((Annotation)normalAnnotation);
    }

    public boolean visit(QualifiedName qualifiedName) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(qualifiedName);
        if (iTypeBinding != null) {
            this.addImports(iTypeBinding);
        }
        return true;
    }

    public boolean visit(SimpleName simpleName) {
        ITypeBinding iTypeBinding;
        IVariableBinding iVariableBinding = Types.getVariableBinding(simpleName);
        if (iVariableBinding != null && Modifier.isStatic((int)iVariableBinding.getModifiers())) {
            iTypeBinding = iVariableBinding.getDeclaringClass();
            this.addImports(iTypeBinding);
        }
        if (BindingUtil.isRuntimeAnnotation(iTypeBinding = Types.getTypeBinding(simpleName))) {
            this.addImports(iTypeBinding);
            this.addImports(Types.resolveIOSType("IOSClass"));
        }
        return true;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        return this.visitAnnotation((Annotation)singleMemberAnnotation);
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.addImports(Types.getTypeBinding(singleVariableDeclaration));
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        this.addImports(iTypeBinding);
        this.addDeclaredType(iTypeBinding, false);
        return true;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        Type type = variableDeclarationExpression.getType();
        this.addImports(type);
        return true;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.addImports(variableDeclarationStatement.getType());
        return true;
    }

    private boolean visitAnnotation(Annotation annotation) {
        IAnnotationBinding iAnnotationBinding = Types.getAnnotationBinding(annotation);
        if (!BindingUtil.isRuntimeAnnotation(iAnnotationBinding)) {
            return false;
        }
        for (IMemberValuePairBinding iMemberValuePairBinding : iAnnotationBinding.getAllMemberValuePairs()) {
            if (!iMemberValuePairBinding.isDefault()) continue;
            Object object = iMemberValuePairBinding.getValue();
            if (object instanceof IVariableBinding) {
                this.addImports(((IVariableBinding)object).getType());
                continue;
            }
            if (!(object instanceof ITypeBinding)) continue;
            this.addImports((ITypeBinding)object);
        }
        return true;
    }
}

