/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.base.Preconditions;
import com.google.devtools.j2objc.types.AbstractBinding;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;

public class GeneratedVariableBinding
extends AbstractBinding
implements IVariableBinding {
    private final String name;
    private final int modifiers;
    private final ITypeBinding type;
    private ITypeBinding declaringClass;
    private IMethodBinding declaringMethod;
    private final boolean isParameter;
    private final boolean isField;
    private String typeQualifiers;
    public static final String PLACEHOLDER_NAME = "<placeholder-variable>";

    public GeneratedVariableBinding(String string, int n, ITypeBinding iTypeBinding, boolean bl, boolean bl2, @Nullable ITypeBinding iTypeBinding2, @Nullable IMethodBinding iMethodBinding) {
        Preconditions.checkNotNull((Object)string);
        this.name = string;
        this.modifiers = n;
        this.type = iTypeBinding;
        this.isParameter = bl2;
        this.declaringClass = iTypeBinding2;
        this.declaringMethod = iMethodBinding;
        this.isField = bl;
    }

    public GeneratedVariableBinding(IVariableBinding iVariableBinding) {
        this(iVariableBinding.getName(), iVariableBinding.getModifiers(), iVariableBinding.getType(), iVariableBinding.isField(), iVariableBinding.isParameter(), iVariableBinding.getDeclaringClass(), iVariableBinding.getDeclaringMethod());
    }

    public static GeneratedVariableBinding newPlaceholder() {
        return new GeneratedVariableBinding(PLACEHOLDER_NAME, 0, null, false, false, null, null);
    }

    public static boolean isPlaceholder(IVariableBinding iVariableBinding) {
        return iVariableBinding.getName().equals(PLACEHOLDER_NAME);
    }

    public void setTypeQualifiers(String string) {
        this.typeQualifiers = string;
    }

    public String getTypeQualifiers() {
        return this.typeQualifiers;
    }

    public int getKind() {
        return 3;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public String getKey() {
        throw new AssertionError((Object)"not implemented");
    }

    public boolean isEqualTo(IBinding iBinding) {
        return this.equals(iBinding);
    }

    public boolean isField() {
        return this.isField;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public String getName() {
        return this.name;
    }

    public ITypeBinding getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(ITypeBinding iTypeBinding) {
        this.declaringClass = iTypeBinding;
    }

    public ITypeBinding getType() {
        return this.type;
    }

    public int getVariableId() {
        throw new AssertionError((Object)"not implemented");
    }

    public Object getConstantValue() {
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        return this.declaringMethod;
    }

    public IVariableBinding getVariableDeclaration() {
        return this;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        n = 31 * n + (this.declaringMethod == null ? 0 : this.declaringMethod.getName().hashCode());
        n = 31 * n + (this.isParameter ? 1231 : 1237);
        n = 31 * n + this.modifiers;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return 31 * n + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneratedVariableBinding)) {
            return false;
        }
        GeneratedVariableBinding generatedVariableBinding = (GeneratedVariableBinding)object;
        if (!this.name.equals(generatedVariableBinding.name) || this.modifiers != generatedVariableBinding.modifiers || this.isParameter != generatedVariableBinding.isParameter || !this.type.equals(generatedVariableBinding.type)) {
            return false;
        }
        if (this.declaringClass == null ? generatedVariableBinding.declaringClass != null : !this.declaringClass.equals(generatedVariableBinding.declaringClass)) {
            return false;
        }
        return !(this.declaringMethod == null ? generatedVariableBinding.declaringMethod != null : !this.declaringMethod.toString().equals(generatedVariableBinding.declaringMethod.toString()));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        ASTNode.printModifiers((int)this.modifiers, (StringBuffer)stringBuffer);
        stringBuffer.append(this.type != null ? this.type.getName() : "<no type>");
        stringBuffer.append(" ");
        stringBuffer.append(this.name != null ? this.name : "<no name>");
        return stringBuffer.toString();
    }
}

