/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

class BindingMapVerifier
extends ErrorReportingASTVisitor {
    private final Map<Object, IBinding> bindingMap;

    public static void verify(ASTNode aSTNode, Map<Object, IBinding> map) {
        BindingMapVerifier bindingMapVerifier = new BindingMapVerifier(map);
        bindingMapVerifier.run(aSTNode);
    }

    private BindingMapVerifier(Map<Object, IBinding> map) {
        this.bindingMap = map;
    }

    private boolean verify(ASTNode aSTNode) {
        IBinding iBinding = this.bindingMap.get(aSTNode);
        assert (iBinding != null);
        if (iBinding instanceof IVariableBinding) assert (!GeneratedVariableBinding.isPlaceholder((IVariableBinding)iBinding));
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        return this.verify((ASTNode)annotationTypeMemberDeclaration);
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return this.verify((ASTNode)annotationTypeDeclaration);
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return this.verify((ASTNode)anonymousClassDeclaration);
    }

    public boolean visit(ArrayAccess arrayAccess) {
        return this.verify((ASTNode)arrayAccess);
    }

    public boolean visit(ArrayCreation arrayCreation) {
        return this.verify((ASTNode)arrayCreation);
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        return this.verify((ASTNode)arrayInitializer);
    }

    public boolean visit(ArrayType arrayType) {
        return this.verify((ASTNode)arrayType);
    }

    public boolean visit(Assignment assignment) {
        return this.verify((ASTNode)assignment);
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        return this.verify((ASTNode)booleanLiteral);
    }

    public boolean visit(CastExpression castExpression) {
        return this.verify((ASTNode)castExpression);
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        return this.verify((ASTNode)characterLiteral);
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        IBinding iBinding = this.bindingMap.get(classInstanceCreation);
        assert (iBinding instanceof IMethodBinding);
        assert (((IMethodBinding)iBinding).isVarargs() || classInstanceCreation.arguments().size() == ((IMethodBinding)iBinding).getParameterTypes().length);
        return this.verify((ASTNode)classInstanceCreation);
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        return this.verify((ASTNode)conditionalExpression);
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        IBinding iBinding = this.bindingMap.get(constructorInvocation);
        assert (iBinding instanceof IMethodBinding);
        return true;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        return this.verify((ASTNode)enumConstantDeclaration);
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return this.verify((ASTNode)enumDeclaration);
    }

    public boolean visit(FieldAccess fieldAccess) {
        return this.verify((ASTNode)fieldAccess);
    }

    public boolean visit(InfixExpression infixExpression) {
        return this.verify((ASTNode)infixExpression);
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        return this.verify((ASTNode)instanceofExpression);
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        return this.verify((ASTNode)markerAnnotation);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        IMethodBinding iMethodBinding = (IMethodBinding)this.bindingMap.get(methodDeclaration);
        assert (methodDeclaration.parameters().size() == iMethodBinding.getParameterTypes().length);
        return this.verify((ASTNode)methodDeclaration);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        IBinding iBinding = this.bindingMap.get(methodInvocation);
        assert (iBinding instanceof IMethodBinding);
        IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
        assert (iMethodBinding.isVarargs() || methodInvocation.arguments().size() == iMethodBinding.getParameterTypes().length || iBinding instanceof IOSMethodBinding);
        return true;
    }

    public boolean visit(MethodRef methodRef) {
        return this.verify((ASTNode)methodRef);
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        return this.verify((ASTNode)normalAnnotation);
    }

    public boolean visit(NullLiteral nullLiteral) {
        return this.verify((ASTNode)nullLiteral);
    }

    public boolean visit(NumberLiteral numberLiteral) {
        return this.verify((ASTNode)numberLiteral);
    }

    public boolean visit(ParameterizedType parameterizedType) {
        return this.verify((ASTNode)parameterizedType);
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        return this.verify((ASTNode)parenthesizedExpression);
    }

    public boolean visit(PostfixExpression postfixExpression) {
        return this.verify((ASTNode)postfixExpression);
    }

    public boolean visit(PrefixExpression prefixExpression) {
        return this.verify((ASTNode)prefixExpression);
    }

    public boolean visit(PrimitiveType primitiveType) {
        return this.verify((ASTNode)primitiveType);
    }

    public boolean visit(QualifiedName qualifiedName) {
        return this.verify((ASTNode)qualifiedName);
    }

    public boolean visit(QualifiedType qualifiedType) {
        return this.verify((ASTNode)qualifiedType);
    }

    public boolean visit(SimpleName simpleName) {
        return this.verify((ASTNode)simpleName);
    }

    public boolean visit(SimpleType simpleType) {
        return this.verify((ASTNode)simpleType);
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        return this.verify((ASTNode)singleMemberAnnotation);
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        return this.verify((ASTNode)singleVariableDeclaration);
    }

    public boolean visit(StringLiteral stringLiteral) {
        return this.verify((ASTNode)stringLiteral);
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        return this.verify((ASTNode)superConstructorInvocation);
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        return this.verify((ASTNode)superFieldAccess);
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        IBinding iBinding = this.bindingMap.get(superMethodInvocation);
        assert (iBinding instanceof IMethodBinding);
        IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
        assert (iMethodBinding.isVarargs() || superMethodInvocation.arguments().size() == iMethodBinding.getParameterTypes().length || iBinding instanceof IOSMethodBinding);
        return true;
    }

    public boolean visit(ThisExpression thisExpression) {
        return this.verify((ASTNode)thisExpression);
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        return this.verify((ASTNode)typeDeclaration);
    }

    public boolean visit(TypeLiteral typeLiteral) {
        return this.verify((ASTNode)typeLiteral);
    }

    public boolean visit(TypeParameter typeParameter) {
        return this.verify((ASTNode)typeParameter);
    }

    public boolean visit(UnionType unionType) {
        return this.verify((ASTNode)unionType);
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        return this.verify((ASTNode)variableDeclarationExpression);
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        return this.verify((ASTNode)variableDeclarationFragment);
    }
}

