/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.types;

import com.google.common.collect.Maps;
import com.google.devtools.j2objc.types.BindingMapVerifier;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

class BindingMapBuilder
extends ErrorReportingASTVisitor {
    private final Map<Object, IBinding> bindingMap = Maps.newHashMap();

    BindingMapBuilder() {
    }

    public static Map<Object, IBinding> buildBindingMap(CompilationUnit compilationUnit) {
        BindingMapBuilder bindingMapBuilder = new BindingMapBuilder();
        bindingMapBuilder.run((ASTNode)compilationUnit);
        BindingMapVerifier.verify((ASTNode)compilationUnit, bindingMapBuilder.bindingMap);
        return bindingMapBuilder.bindingMap;
    }

    private void put(ASTNode aSTNode, IBinding iBinding) {
        assert (iBinding != null);
        this.bindingMap.put(aSTNode, iBinding);
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        this.put((ASTNode)annotationTypeMemberDeclaration, (IBinding)annotationTypeMemberDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.put((ASTNode)annotationTypeDeclaration, (IBinding)annotationTypeDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.put((ASTNode)anonymousClassDeclaration, (IBinding)anonymousClassDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        this.put((ASTNode)arrayAccess, (IBinding)arrayAccess.resolveTypeBinding());
        return true;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        this.put((ASTNode)arrayCreation, (IBinding)arrayCreation.resolveTypeBinding());
        return true;
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        this.put((ASTNode)arrayInitializer, (IBinding)arrayInitializer.resolveTypeBinding());
        return true;
    }

    public boolean visit(ArrayType arrayType) {
        this.put((ASTNode)arrayType, (IBinding)arrayType.resolveBinding());
        return true;
    }

    public boolean visit(Assignment assignment) {
        this.put((ASTNode)assignment, (IBinding)assignment.resolveTypeBinding());
        return true;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        this.put((ASTNode)booleanLiteral, (IBinding)booleanLiteral.resolveTypeBinding());
        return true;
    }

    public boolean visit(BreakStatement breakStatement) {
        SimpleName simpleName = breakStatement.getLabel();
        if (simpleName != null) {
            this.put((ASTNode)simpleName, (IBinding)this.createLabelBinding(simpleName));
        }
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        this.put((ASTNode)castExpression, (IBinding)castExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        this.put((ASTNode)characterLiteral, (IBinding)characterLiteral.resolveTypeBinding());
        return true;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.put((ASTNode)classInstanceCreation, (IBinding)classInstanceCreation.resolveConstructorBinding());
        return true;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        this.put((ASTNode)conditionalExpression, (IBinding)conditionalExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.put((ASTNode)constructorInvocation, (IBinding)constructorInvocation.resolveConstructorBinding());
        return true;
    }

    public boolean visit(ContinueStatement continueStatement) {
        SimpleName simpleName = continueStatement.getLabel();
        if (simpleName != null) {
            this.put((ASTNode)simpleName, (IBinding)this.createLabelBinding(simpleName));
        }
        return false;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        this.put((ASTNode)enumConstantDeclaration, (IBinding)enumConstantDeclaration.resolveConstructorBinding());
        return true;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        this.put((ASTNode)enumDeclaration, (IBinding)enumDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.put((ASTNode)fieldAccess, (IBinding)fieldAccess.resolveFieldBinding());
        return true;
    }

    public boolean visit(InfixExpression infixExpression) {
        this.put((ASTNode)infixExpression, (IBinding)infixExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        this.put((ASTNode)instanceofExpression, (IBinding)instanceofExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        SimpleName simpleName = labeledStatement.getLabel();
        if (simpleName != null) {
            this.put((ASTNode)simpleName, (IBinding)this.createLabelBinding(simpleName));
        }
        labeledStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        this.put((ASTNode)markerAnnotation, (IBinding)markerAnnotation.resolveAnnotationBinding());
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.put((ASTNode)methodDeclaration, (IBinding)methodDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.put((ASTNode)methodInvocation, (IBinding)methodInvocation.resolveMethodBinding());
        return true;
    }

    public boolean visit(MethodRef methodRef) {
        this.put((ASTNode)methodRef, methodRef.resolveBinding());
        return true;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        this.put((ASTNode)normalAnnotation, (IBinding)normalAnnotation.resolveAnnotationBinding());
        return true;
    }

    public boolean visit(NullLiteral nullLiteral) {
        this.put((ASTNode)nullLiteral, (IBinding)nullLiteral.resolveTypeBinding());
        return true;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        this.put((ASTNode)numberLiteral, (IBinding)numberLiteral.resolveTypeBinding());
        return true;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        this.put((ASTNode)parameterizedType, (IBinding)parameterizedType.resolveBinding());
        return true;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.put((ASTNode)parenthesizedExpression, (IBinding)parenthesizedExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        this.put((ASTNode)postfixExpression, (IBinding)postfixExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.put((ASTNode)prefixExpression, (IBinding)prefixExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.put((ASTNode)primitiveType, (IBinding)primitiveType.resolveBinding());
        return true;
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.put((ASTNode)qualifiedName, qualifiedName.resolveBinding());
        return true;
    }

    public boolean visit(QualifiedType qualifiedType) {
        this.put((ASTNode)qualifiedType, (IBinding)qualifiedType.resolveBinding());
        return true;
    }

    public boolean visit(SimpleName simpleName) {
        this.put((ASTNode)simpleName, simpleName.resolveBinding());
        return true;
    }

    public boolean visit(SimpleType simpleType) {
        this.put((ASTNode)simpleType, (IBinding)simpleType.resolveBinding());
        return true;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        this.put((ASTNode)singleMemberAnnotation, (IBinding)singleMemberAnnotation.resolveAnnotationBinding());
        return true;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.put((ASTNode)singleVariableDeclaration, (IBinding)singleVariableDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.put((ASTNode)stringLiteral, (IBinding)stringLiteral.resolveTypeBinding());
        return true;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.put((ASTNode)superConstructorInvocation, (IBinding)superConstructorInvocation.resolveConstructorBinding());
        return true;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        this.put((ASTNode)superFieldAccess, (IBinding)superFieldAccess.resolveFieldBinding());
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        this.put((ASTNode)superMethodInvocation, (IBinding)superMethodInvocation.resolveMethodBinding());
        return true;
    }

    public boolean visit(ThisExpression thisExpression) {
        this.put((ASTNode)thisExpression, (IBinding)thisExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        this.put((ASTNode)typeDeclaration, (IBinding)typeDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        this.put((ASTNode)typeLiteral, (IBinding)typeLiteral.resolveTypeBinding());
        return true;
    }

    public boolean visit(TypeParameter typeParameter) {
        this.put((ASTNode)typeParameter, (IBinding)typeParameter.resolveBinding());
        return true;
    }

    public boolean visit(UnionType unionType) {
        this.put((ASTNode)unionType, (IBinding)unionType.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        this.put((ASTNode)variableDeclarationExpression, (IBinding)variableDeclarationExpression.resolveTypeBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        this.put((ASTNode)variableDeclarationFragment, (IBinding)variableDeclarationFragment.resolveBinding());
        return true;
    }

    private ITypeBinding createLabelBinding(SimpleName simpleName) {
        return IOSTypeBinding.newUnmappedClass(simpleName.getIdentifier());
    }
}

