/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SwitchCase;

public class StaticVarRewriter
extends ErrorReportingASTVisitor {
    private boolean useAccessor(ASTNode aSTNode, IVariableBinding iVariableBinding) {
        return BindingUtil.isStatic((IBinding)iVariableBinding) && !BindingUtil.isPrimitiveConstant(iVariableBinding) && !Types.getTypeBinding(ASTUtil.getOwningType(aSTNode)).getTypeDeclaration().isEqualTo((IBinding)iVariableBinding.getDeclaringClass().getTypeDeclaration());
    }

    public boolean visit(Assignment assignment) {
        AST aST = assignment.getAST();
        Expression expression = assignment.getLeftHandSide();
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        if (iVariableBinding != null && this.useAccessor((ASTNode)assignment, iVariableBinding)) {
            boolean bl = iVariableBinding.getType().isPrimitive();
            if (assignment.getOperator() == Assignment.Operator.ASSIGN && !bl) {
                Expression expression2 = NodeCopier.copySubtree(aST, assignment.getRightHandSide());
                ASTUtil.setProperty((ASTNode)assignment, (ASTNode)this.newSetterInvocation(aST, iVariableBinding, expression2));
                expression2.accept((ASTVisitor)this);
                return false;
            }
            if (bl) {
                ASTUtil.setProperty((ASTNode)expression, (ASTNode)this.newGetterInvocation(aST, expression, true));
            }
        }
        return true;
    }

    public boolean visit(SimpleName simpleName) {
        return this.visitName((Name)simpleName);
    }

    public boolean visit(QualifiedName qualifiedName) {
        return this.visitName((Name)qualifiedName);
    }

    private boolean visitName(Name name) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(name);
        if (iVariableBinding != null && this.useAccessor((ASTNode)name, iVariableBinding)) {
            ASTNode aSTNode = name.getParent();
            if (aSTNode instanceof QualifiedName && name == ((QualifiedName)aSTNode).getQualifier()) {
                FieldAccess fieldAccess = ASTFactory.convertToFieldAccess((QualifiedName)aSTNode);
                name = (Name)fieldAccess.getExpression();
            }
            ASTUtil.setProperty((ASTNode)name, (ASTNode)this.newGetterInvocation(name.getAST(), (Expression)name, false));
            return false;
        }
        return true;
    }

    public boolean visit(SwitchCase switchCase) {
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        boolean bl;
        Expression expression = postfixExpression.getOperand();
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        PostfixExpression.Operator operator = postfixExpression.getOperator();
        boolean bl2 = bl = operator == PostfixExpression.Operator.INCREMENT || operator == PostfixExpression.Operator.DECREMENT;
        if (bl && iVariableBinding != null && this.useAccessor((ASTNode)postfixExpression, iVariableBinding)) {
            postfixExpression.setOperand((Expression)this.newGetterInvocation(postfixExpression.getAST(), expression, true));
            return false;
        }
        return true;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        boolean bl;
        Expression expression = prefixExpression.getOperand();
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        boolean bl2 = bl = operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT;
        if (bl && iVariableBinding != null && this.useAccessor((ASTNode)prefixExpression, iVariableBinding)) {
            prefixExpression.setOperand((Expression)this.newGetterInvocation(prefixExpression.getAST(), expression, true));
            return false;
        }
        return true;
    }

    private MethodInvocation newGetterInvocation(AST aST, Expression expression, boolean bl) {
        IVariableBinding iVariableBinding = Types.getVariableBinding(expression);
        ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass().getTypeDeclaration();
        String string = iVariableBinding.isEnumConstant() ? NameTable.getName((IBinding)iVariableBinding) : NameTable.getStaticAccessorName(iVariableBinding.getName());
        ITypeBinding iTypeBinding2 = iVariableBinding.getType();
        if (bl) {
            string = string + "Ref";
            iTypeBinding2 = new PointerTypeBinding(iTypeBinding2);
        }
        IOSMethod iOSMethod = IOSMethod.create(NameTable.getFullName(iTypeBinding) + " " + string);
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, 9, iTypeBinding2, iTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iTypeBinding));
        if (bl) {
            methodInvocation = ASTFactory.newDereference(aST, (Expression)methodInvocation);
        }
        if (Types.hasNilCheck(expression)) {
            Types.addNilCheck((Expression)methodInvocation);
        }
        return methodInvocation;
    }

    private MethodInvocation newSetterInvocation(AST aST, IVariableBinding iVariableBinding, Expression expression) {
        ITypeBinding iTypeBinding = iVariableBinding.getType();
        ITypeBinding iTypeBinding2 = iVariableBinding.getDeclaringClass();
        IOSMethod iOSMethod = IOSMethod.create(String.format("%s set%s:(%s)value", NameTable.getFullName(iTypeBinding2), NameTable.capitalize(iVariableBinding.getName()), NameTable.getSpecificObjCType(iTypeBinding)));
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, 9, iTypeBinding, iTypeBinding2);
        iOSMethodBinding.addParameter(iTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iTypeBinding2));
        ASTUtil.getArguments(methodInvocation).add(expression);
        return methodInvocation;
    }
}

