/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class JavaToIOSTypeConverter
extends ErrorReportingASTVisitor {
    private void convertType(Type type) {
        ITypeBinding iTypeBinding;
        if (type == null) {
            return;
        }
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(type);
        if (iTypeBinding2 != (iTypeBinding = Types.mapType(iTypeBinding2))) {
            ASTUtil.setProperty((ASTNode)type, (ASTNode)ASTFactory.newType(type.getAST(), iTypeBinding));
        }
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        Object object;
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        if (iTypeBinding != Types.mapType(iTypeBinding)) {
            return;
        }
        if (!typeDeclaration.isInterface()) {
            object = typeDeclaration.getSuperclassType();
            if (object == null) {
                typeDeclaration.setSuperclassType(ASTFactory.newType(typeDeclaration.getAST(), Types.getNSObject()));
            } else {
                this.convertType((Type)object);
            }
        }
        object = ASTUtil.getSuperInterfaceTypes(typeDeclaration);
        for (int i = 0; i < object.size(); ++i) {
            this.convertType((Type)object.get(i));
        }
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.convertType(methodDeclaration.getReturnType2());
        for (SingleVariableDeclaration singleVariableDeclaration : ASTUtil.getParameters(methodDeclaration)) {
            this.convertType(singleVariableDeclaration.getType());
        }
    }

    public void endVisit(FieldDeclaration fieldDeclaration) {
        this.convertType(fieldDeclaration.getType());
    }

    public void endVisit(SingleVariableDeclaration singleVariableDeclaration) {
        this.convertType(singleVariableDeclaration.getType());
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        this.convertType(variableDeclarationStatement.getType());
    }

    public void endVisit(CastExpression castExpression) {
        this.convertType(castExpression.getType());
    }
}

