/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.J2ObjC;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.translate.OuterReferenceResolver;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.j2objc.annotations.WeakOuter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;

public class InnerClassExtractor
extends ErrorReportingASTVisitor {
    private final List<AbstractTypeDeclaration> unitTypes;
    private ArrayList<Integer> typeOrderStack = Lists.newArrayList();

    public InnerClassExtractor(CompilationUnit compilationUnit) {
        this.unitTypes = ASTUtil.getTypes(compilationUnit);
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        return this.handleType((AbstractTypeDeclaration)typeDeclaration);
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        this.endHandleType((AbstractTypeDeclaration)typeDeclaration);
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return this.handleType((AbstractTypeDeclaration)enumDeclaration);
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        this.endHandleType((AbstractTypeDeclaration)enumDeclaration);
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return this.handleType((AbstractTypeDeclaration)annotationTypeDeclaration);
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.endHandleType((AbstractTypeDeclaration)annotationTypeDeclaration);
    }

    private boolean handleType(AbstractTypeDeclaration abstractTypeDeclaration) {
        this.typeOrderStack.add(this.unitTypes.size());
        return true;
    }

    private void endHandleType(AbstractTypeDeclaration abstractTypeDeclaration) {
        int n = this.typeOrderStack.remove(this.typeOrderStack.size() - 1);
        ASTNode aSTNode = abstractTypeDeclaration.getParent();
        if (!(aSTNode instanceof CompilationUnit)) {
            Block block;
            if (aSTNode instanceof AbstractTypeDeclaration) {
                boolean bl = ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)aSTNode).remove(abstractTypeDeclaration);
                assert (bl);
            } else {
                TypeDeclarationStatement typeDeclarationStatement = (TypeDeclarationStatement)aSTNode;
                block = (Block)typeDeclarationStatement.getParent();
                boolean bl = ASTUtil.getStatements(block).remove(typeDeclarationStatement);
                assert (bl);
            }
            AbstractTypeDeclaration abstractTypeDeclaration2 = NodeCopier.copySubtree(abstractTypeDeclaration.getAST(), abstractTypeDeclaration);
            block = Types.getTypeBinding(abstractTypeDeclaration);
            if (!(block.isInterface() || block.isAnnotation() || Modifier.isStatic((int)block.getModifiers()))) {
                this.addOuterFields(abstractTypeDeclaration2);
                this.updateConstructors(abstractTypeDeclaration2);
            }
            this.removePrivateModifier(abstractTypeDeclaration2);
            this.unitTypes.add(n, abstractTypeDeclaration2);
            if (BindingUtil.isStatic((IBinding)block) && BindingUtil.hasAnnotation((IBinding)block, WeakOuter.class)) {
                J2ObjC.warning("static class " + block.getQualifiedName() + " has WeakOuter annotation");
            }
        }
    }

    private void removePrivateModifier(AbstractTypeDeclaration abstractTypeDeclaration) {
        Iterator<IExtendedModifier> iterator = ASTUtil.getModifiers((BodyDeclaration)abstractTypeDeclaration).iterator();
        while (iterator.hasNext()) {
            IExtendedModifier iExtendedModifier = iterator.next();
            if (!(iExtendedModifier instanceof Modifier) || !((Modifier)iExtendedModifier).isPrivate()) continue;
            iterator.remove();
            break;
        }
    }

    private void addOuterFields(AbstractTypeDeclaration abstractTypeDeclaration) {
        List<BodyDeclaration> list = ASTUtil.getBodyDeclarations(abstractTypeDeclaration);
        AST aST = abstractTypeDeclaration.getAST();
        ITypeBinding iTypeBinding = Types.getTypeBinding(abstractTypeDeclaration);
        assert (iTypeBinding.getDeclaringClass() != null);
        IVariableBinding iVariableBinding = OuterReferenceResolver.getOuterField(iTypeBinding);
        if (iVariableBinding != null) {
            list.add(0, (BodyDeclaration)ASTFactory.newFieldDeclaration(aST, iVariableBinding, null));
        }
        List<IVariableBinding> list2 = OuterReferenceResolver.getInnerFields(iTypeBinding);
        for (IVariableBinding iVariableBinding2 : list2) {
            ASTUtil.getBodyDeclarations(abstractTypeDeclaration).add((BodyDeclaration)ASTFactory.newFieldDeclaration(aST, iVariableBinding2, null));
        }
    }

    private void updateConstructors(AbstractTypeDeclaration abstractTypeDeclaration) {
        AST aST = abstractTypeDeclaration.getAST();
        boolean bl = true;
        for (MethodDeclaration methodDeclaration : ASTUtil.getMethodDeclarations(abstractTypeDeclaration)) {
            if (!methodDeclaration.isConstructor()) continue;
            bl = false;
            this.addOuterParameters(abstractTypeDeclaration, methodDeclaration);
        }
        if (bl) {
            MethodDeclaration methodDeclaration;
            GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newConstructor(Types.getTypeBinding(abstractTypeDeclaration), 0);
            methodDeclaration = ASTFactory.newMethodDeclaration(aST, generatedMethodBinding);
            methodDeclaration.setBody(aST.newBlock());
            this.addOuterParameters(abstractTypeDeclaration, methodDeclaration);
            ASTUtil.getBodyDeclarations(abstractTypeDeclaration).add((BodyDeclaration)methodDeclaration);
        }
    }

    private GeneratedVariableBinding addParameter(MethodDeclaration methodDeclaration, ITypeBinding iTypeBinding, String string, int n) {
        GeneratedMethodBinding generatedMethodBinding = Types.getGeneratedMethodBinding(methodDeclaration);
        GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding(string, 16, iTypeBinding, false, true, generatedMethodBinding.getDeclaringClass(), generatedMethodBinding);
        SingleVariableDeclaration singleVariableDeclaration = ASTFactory.newSingleVariableDeclaration(methodDeclaration.getAST(), generatedVariableBinding);
        if (n == -1) {
            ASTUtil.getParameters(methodDeclaration).add(singleVariableDeclaration);
            generatedMethodBinding.addParameter(iTypeBinding);
        } else {
            ASTUtil.getParameters(methodDeclaration).add(n, singleVariableDeclaration);
            generatedMethodBinding.addParameter(n, iTypeBinding);
        }
        return generatedVariableBinding;
    }

    protected void addOuterParameters(AbstractTypeDeclaration abstractTypeDeclaration, MethodDeclaration methodDeclaration) {
        Object object;
        IVariableBinding iVariableBinding22;
        AST aST = abstractTypeDeclaration.getAST();
        ITypeBinding iTypeBinding = Types.getTypeBinding(abstractTypeDeclaration);
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        GeneratedVariableBinding generatedVariableBinding = null;
        if (OuterReferenceResolver.needsOuterParam(iTypeBinding)) {
            generatedVariableBinding = this.addParameter(methodDeclaration, iTypeBinding2, "outer$", 0);
        }
        List<IVariableBinding> list = OuterReferenceResolver.getInnerFields(iTypeBinding);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        int n = 0;
        for (IVariableBinding iVariableBinding22 : list) {
            arrayList.add(this.addParameter(methodDeclaration, iVariableBinding22.getType(), "capture$" + n++, -1));
        }
        ConstructorInvocation constructorInvocation = null;
        iVariableBinding22 = null;
        List<Statement> list2 = ASTUtil.getStatements(methodDeclaration.getBody());
        for (Statement object2 : list2) {
            if (object2 instanceof ConstructorInvocation) {
                constructorInvocation = (ConstructorInvocation)object2;
                break;
            }
            if (!(object2 instanceof SuperConstructorInvocation)) continue;
            iVariableBinding22 = (SuperConstructorInvocation)object2;
            break;
        }
        if (constructorInvocation != null) {
            object = Types.getGeneratedMethodBinding(constructorInvocation);
            if (generatedVariableBinding != null) {
                ASTUtil.getArguments(constructorInvocation).add(0, (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
                ((GeneratedMethodBinding)object).addParameter(0, generatedVariableBinding.getType());
            }
            for (IVariableBinding iVariableBinding : arrayList) {
                ASTUtil.getArguments(constructorInvocation).add((Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding));
                ((GeneratedMethodBinding)object).addParameter(iVariableBinding.getType());
            }
        } else {
            object = iTypeBinding.getSuperclass().getTypeDeclaration();
            if (iVariableBinding22 == null) {
                iVariableBinding22 = ASTFactory.newSuperConstructorInvocation(aST, GeneratedMethodBinding.newConstructor((ITypeBinding)object, 1));
                list2.add(0, (Statement)iVariableBinding22);
            }
            this.passOuterParamToSuper(abstractTypeDeclaration, (SuperConstructorInvocation)iVariableBinding22, (ITypeBinding)object, generatedVariableBinding);
            IVariableBinding iVariableBinding = OuterReferenceResolver.getOuterField(iTypeBinding);
            int n2 = 0;
            if (iVariableBinding != null) {
                assert (generatedVariableBinding != null);
                list2.add(n2++, (Statement)aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)iVariableBinding), (Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding))));
            }
            for (int i = 0; i < list.size(); ++i) {
                list2.add(n2++, (Statement)aST.newExpressionStatement((Expression)ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)list.get(i)), (Expression)ASTFactory.newSimpleName(aST, (IBinding)arrayList.get(i)))));
            }
        }
        assert (methodDeclaration.parameters().size() == Types.getMethodBinding(methodDeclaration).getParameterTypes().length);
    }

    private void passOuterParamToSuper(AbstractTypeDeclaration abstractTypeDeclaration, SuperConstructorInvocation superConstructorInvocation, ITypeBinding iTypeBinding, IVariableBinding iVariableBinding) {
        if (iTypeBinding.getDeclaringClass() == null || Modifier.isStatic((int)iTypeBinding.getModifiers()) || superConstructorInvocation.getExpression() != null) {
            return;
        }
        assert (iVariableBinding != null);
        AST aST = abstractTypeDeclaration.getAST();
        GeneratedMethodBinding generatedMethodBinding = Types.getGeneratedMethodBinding(superConstructorInvocation);
        ArrayList arrayList = OuterReferenceResolver.getPath((ASTNode)abstractTypeDeclaration);
        assert (arrayList != null && arrayList.size() > 0);
        arrayList = Lists.newArrayList(arrayList);
        arrayList.set(0, iVariableBinding);
        Name name = ASTFactory.newName(aST, arrayList);
        ASTUtil.getArguments(superConstructorInvocation).add(0, (Expression)name);
        generatedMethodBinding.addParameter(0, iTypeBinding.getDeclaringClass());
    }
}

