/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Sets;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;

public class GwtConverter
extends ErrorReportingASTVisitor {
    private static final String GWT_CLASS = "com.google.gwt.core.client.GWT";
    private static final Set<String> compatibleAPIs = Sets.newHashSet((Object[])new String[]{"Array.newArray(Class, int)", "Array.newInstance(Class, int)", "Class.isInstance", "Class.isAssignableFrom", "CopyOnWriteArraySet", "InputStream", "java.io.BufferedReader", "java.io.Closeable,java.io.Flushable", "java.io.Writer", "java.lang.reflect", "java.lang.String.getBytes()", "java.lang.System#getProperty", "java.util.ArrayDeque", "java.util.BitSet", "java.util.Locale", "java.util.regex", "java.util.regex.Pattern", "java.util.String(byte[], Charset)", "MapMakerInternalMap", "NavigableMap", "NavigableAsMap", "NavigableSet", "Non-UTF-8 Charset", "OutputStream", "proto", "protos", "Readable", "Reader", "Reader,InputStream", "reflection", "regular expressions", "String.format()", "uses NavigableMap", "Writer", "Writer,OutputStream"});

    public boolean visit(ConditionalExpression conditionalExpression) {
        if (this.isGwtTest(conditionalExpression.getExpression())) {
            ASTUtil.setProperty((ASTNode)conditionalExpression, (ASTNode)NodeCopier.copySubtree(conditionalExpression.getAST(), conditionalExpression.getElseExpression()));
        }
        conditionalExpression.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        if (this.isGwtTest(ifStatement.getExpression())) {
            if (ifStatement.getElseStatement() != null) {
                ASTUtil.setProperty((ASTNode)ifStatement, (ASTNode)NodeCopier.copySubtree(ifStatement.getAST(), ifStatement.getElseStatement()));
                ifStatement.getElseStatement().accept((ASTVisitor)this);
            } else {
                ASTNode aSTNode = ifStatement.getParent();
                if (aSTNode instanceof Block) {
                    ASTUtil.getStatements((Block)aSTNode).remove(ifStatement);
                } else {
                    ASTUtil.setProperty((ASTNode)ifStatement, (ASTNode)ifStatement.getAST().newEmptyStatement());
                }
            }
            return false;
        }
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (Options.stripGwtIncompatibleMethods() && this.hasAnnotation(GwtIncompatible.class, ASTUtil.getModifiers((BodyDeclaration)methodDeclaration))) {
            ASTNode aSTNode = methodDeclaration.getParent();
            if (aSTNode instanceof TypeDeclarationStatement) {
                aSTNode = ((TypeDeclarationStatement)aSTNode).getDeclaration();
            }
            if (aSTNode instanceof AbstractTypeDeclaration) {
                ((AbstractTypeDeclaration)aSTNode).bodyDeclarations().remove(methodDeclaration);
            } else if (aSTNode instanceof AnonymousClassDeclaration) {
                ((AnonymousClassDeclaration)aSTNode).bodyDeclarations().remove(methodDeclaration);
            } else {
                throw new AssertionError((Object)("unknown parent type: " + aSTNode.getClass().getSimpleName()));
            }
        }
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        AST aST = methodInvocation.getAST();
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodInvocation);
        List<Expression> list = ASTUtil.getArguments(methodInvocation);
        if (iMethodBinding.getName().equals("create") && iMethodBinding.getDeclaringClass().getQualifiedName().equals(GWT_CLASS) && list.size() == 1) {
            SimpleName simpleName = aST.newSimpleName("newInstance");
            methodInvocation.setName(simpleName);
            Expression expression = (Expression)NodeCopier.copySubtree(aST, (ASTNode)list.get(0));
            list.remove(0);
            methodInvocation.setExpression(expression);
            IMethodBinding iMethodBinding2 = BindingUtil.findDeclaredMethod(aST.resolveWellKnownType("java.lang.Class"), "newInstance", new String[0]);
            Types.addBinding(simpleName, (IBinding)iMethodBinding2);
            Types.addBinding(methodInvocation, (IBinding)iMethodBinding2);
        } else if (this.isGwtTest((Expression)methodInvocation)) {
            BooleanLiteral booleanLiteral = ASTFactory.newBooleanLiteral(aST, false);
            ASTUtil.setProperty((ASTNode)methodInvocation, (ASTNode)booleanLiteral);
        }
        return true;
    }

    private boolean isGwtTest(Expression expression) {
        IMethodBinding iMethodBinding;
        IBinding iBinding = Types.getBinding(expression);
        if (iBinding instanceof IMethodBinding && (iMethodBinding = (IMethodBinding)iBinding).getDeclaringClass().getQualifiedName().equals(GWT_CLASS)) {
            String string = iMethodBinding.getName();
            return string.equals("isClient") || string.equals("isScript");
        }
        return false;
    }

    private boolean hasAnnotation(Class<?> clazz, List<IExtendedModifier> list) {
        String string = clazz.getSimpleName();
        for (IExtendedModifier iExtendedModifier : list) {
            Expression expression;
            Annotation annotation;
            String string2;
            if (!iExtendedModifier.isAnnotation() || !(string2 = (annotation = (Annotation)iExtendedModifier).getTypeName().getFullyQualifiedName()).equals(string)) continue;
            return !string.equals("GwtIncompatible") || !annotation.isSingleMemberAnnotation() || !((expression = ((SingleMemberAnnotation)annotation).getValue()) instanceof StringLiteral) || !compatibleAPIs.contains(((StringLiteral)expression).getLiteralValue());
        }
        return false;
    }
}

