/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class DestructorGenerator
extends ErrorReportingASTVisitor {
    private final String destructorName = Options.useGC() ? "finalize" : "dealloc";
    public static final String FINALIZE_METHOD = "finalize";
    public static final String DEALLOC_METHOD = "dealloc";

    /*
     * WARNING - void declaration
     */
    public boolean visit(TypeDeclaration typeDeclaration) {
        ErrorReportingASTVisitor errorReportingASTVisitor;
        final ArrayList arrayList = Lists.newArrayList();
        for (final FieldDeclaration fieldDeclaration : typeDeclaration.getFields()) {
            if (fieldDeclaration.getType().isPrimitiveType() || this.isStatic(fieldDeclaration)) continue;
            errorReportingASTVisitor = new ErrorReportingASTVisitor(){

                public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                    IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
                    if (!Modifier.isStatic((int)fieldDeclaration.getModifiers())) {
                        arrayList.add(iVariableBinding);
                    }
                    return true;
                }
            };
            errorReportingASTVisitor.run((ASTNode)fieldDeclaration);
        }
        if (!typeDeclaration.isInterface()) {
            void fieldDeclaration;
            Types.addReleaseableFields(arrayList);
            boolean bl = false;
            MethodDeclaration methodDeclaration = typeDeclaration.getMethods();
            int n = ((MethodDeclaration[])methodDeclaration).length;
            boolean i = false;
            while (fieldDeclaration < n) {
                errorReportingASTVisitor = methodDeclaration[fieldDeclaration];
                if (FINALIZE_METHOD.equals(errorReportingASTVisitor.getName().getIdentifier())) {
                    if (Options.useARC()) {
                        this.removeSuperFinalizeStatement(errorReportingASTVisitor.getBody());
                    }
                    this.addReleaseStatements((MethodDeclaration)errorReportingASTVisitor, arrayList);
                    bl = true;
                }
                ++fieldDeclaration;
            }
            if (!(bl || Options.useARC() || arrayList.isEmpty())) {
                methodDeclaration = this.buildFinalizeMethod(typeDeclaration.getAST(), Types.getTypeBinding(typeDeclaration), arrayList);
                ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration).add((BodyDeclaration)methodDeclaration);
            }
        }
        for (FieldDeclaration fieldDeclaration : typeDeclaration.getMethods()) {
            if (!this.needsRenaming(fieldDeclaration.getName())) continue;
            NameTable.rename(Types.getBinding(fieldDeclaration), this.destructorName);
        }
        return super.visit(typeDeclaration);
    }

    private void removeSuperFinalizeStatement(Block block) {
        block.accept(new ASTVisitor(){

            public boolean visit(ExpressionStatement expressionStatement) {
                IMethodBinding iMethodBinding;
                Expression expression = expressionStatement.getExpression();
                if (expression instanceof SuperMethodInvocation && !Modifier.isStatic((int)(iMethodBinding = Types.getMethodBinding(expression)).getModifiers()) && iMethodBinding.getName().equals(DestructorGenerator.FINALIZE_METHOD) && iMethodBinding.getParameterTypes().length == 0) {
                    assert (expressionStatement.getParent() instanceof Block);
                    ASTUtil.getStatements((Block)expressionStatement.getParent()).remove(expressionStatement);
                    return false;
                }
                return true;
            }
        });
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (this.needsRenaming(methodInvocation.getName())) {
            NameTable.rename(Types.getBinding(methodInvocation), this.destructorName);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        if (this.needsRenaming(superMethodInvocation.getName())) {
            NameTable.rename(Types.getBinding(superMethodInvocation), this.destructorName);
        }
        return true;
    }

    private boolean isStatic(FieldDeclaration fieldDeclaration) {
        return (fieldDeclaration.getModifiers() & 8) != 0;
    }

    private boolean needsRenaming(SimpleName simpleName) {
        return this.destructorName.equals(DEALLOC_METHOD) && FINALIZE_METHOD.equals(simpleName.getIdentifier());
    }

    private SuperMethodInvocation findSuperFinalizeInvocation(ASTNode aSTNode) {
        final SuperMethodInvocation[] superMethodInvocationArray = new SuperMethodInvocation[1];
        aSTNode.accept(new ASTVisitor(){

            public void endVisit(SuperMethodInvocation superMethodInvocation) {
                if (DestructorGenerator.FINALIZE_METHOD.equals(superMethodInvocation.getName().getIdentifier())) {
                    superMethodInvocationArray[0] = superMethodInvocation;
                }
            }
        });
        return superMethodInvocationArray[0];
    }

    private void addReleaseStatements(MethodDeclaration methodDeclaration, List<IVariableBinding> list) {
        ExpressionStatement expressionStatement;
        Assignment assignment;
        AST aST;
        SuperMethodInvocation superMethodInvocation = this.findSuperFinalizeInvocation((ASTNode)methodDeclaration);
        List<Statement> list2 = ASTUtil.getStatements(methodDeclaration.getBody());
        if (superMethodInvocation != null) {
            list2 = ASTUtil.asStatementList(ASTUtil.getOwningStatement((ASTNode)superMethodInvocation)).subList(0, 0);
        } else if (!list2.isEmpty() && list2.get(0) instanceof TryStatement && (aST = (TryStatement)list2.get(0)).getBody() != null) {
            list2 = ASTUtil.getStatements(aST.getBody());
        }
        aST = methodDeclaration.getAST();
        for (Object object : list) {
            if (object.getType().isPrimitive() || BindingUtil.isWeakReference(object)) continue;
            assignment = ASTFactory.newAssignment(aST, (Expression)ASTFactory.newSimpleName(aST, (IBinding)object), (Expression)ASTFactory.newNullLiteral(aST));
            expressionStatement = aST.newExpressionStatement((Expression)assignment);
            list2.add((Statement)expressionStatement);
        }
        if (Options.useReferenceCounting() && superMethodInvocation == null) {
            Object object;
            IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
            object = GeneratedMethodBinding.newMethod(this.destructorName, 1, Types.mapTypeName("void"), iMethodBinding.getDeclaringClass());
            assignment = ASTFactory.newSuperMethodInvocation(aST, (IMethodBinding)object);
            expressionStatement = aST.newExpressionStatement((Expression)assignment);
            list2.add((Statement)expressionStatement);
        }
    }

    private MethodDeclaration buildFinalizeMethod(AST aST, ITypeBinding iTypeBinding, List<IVariableBinding> list) {
        ITypeBinding iTypeBinding2 = Types.mapTypeName("void");
        int n = 4097;
        GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newMethod(this.destructorName, n, iTypeBinding2, iTypeBinding);
        MethodDeclaration methodDeclaration = ASTFactory.newMethodDeclaration(aST, generatedMethodBinding);
        methodDeclaration.setBody(aST.newBlock());
        this.addReleaseStatements(methodDeclaration, list);
        return methodDeclaration;
    }
}

