/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;

public class Autoboxer
extends ErrorReportingASTVisitor {
    private final AST ast;
    private static final String VALUE_METHOD = "Value";
    private static final String VALUEOF_METHOD = "valueOf";

    public Autoboxer(AST aST) {
        this.ast = aST;
    }

    private Expression box(Expression expression) {
        ITypeBinding iTypeBinding = Types.getWrapperType(Types.getTypeBinding(expression));
        if (iTypeBinding != null) {
            return this.newBoxExpression(expression, iTypeBinding);
        }
        return NodeCopier.copySubtree(this.ast, expression);
    }

    private Expression boxWithType(Expression expression, ITypeBinding iTypeBinding) {
        if (Types.isBoxedPrimitive(iTypeBinding)) {
            return this.newBoxExpression(expression, iTypeBinding);
        }
        return this.box(expression);
    }

    private Expression newBoxExpression(Expression expression, ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2 = Types.getPrimitiveType(iTypeBinding);
        assert (iTypeBinding2 != null);
        IMethodBinding iMethodBinding = BindingUtil.findDeclaredMethod(iTypeBinding, VALUEOF_METHOD, iTypeBinding2.getName());
        assert (iMethodBinding != null) : "could not find valueOf method for " + iTypeBinding;
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(this.ast, iMethodBinding, (Expression)ASTFactory.newSimpleName(this.ast, (IBinding)iTypeBinding));
        ASTUtil.getArguments(methodInvocation).add(NodeCopier.copySubtree(this.ast, expression));
        return methodInvocation;
    }

    private ITypeBinding findWrapperSuperclass(ITypeBinding iTypeBinding) {
        while (iTypeBinding != null) {
            if (Types.isBoxedPrimitive(iTypeBinding)) {
                return iTypeBinding;
            }
            iTypeBinding = iTypeBinding.getSuperclass();
        }
        return null;
    }

    private Expression unbox(Expression expression) {
        ITypeBinding iTypeBinding = this.findWrapperSuperclass(Types.getTypeBinding(expression));
        ITypeBinding iTypeBinding2 = Types.getPrimitiveType(iTypeBinding);
        if (iTypeBinding2 != null) {
            IMethodBinding iMethodBinding = BindingUtil.findDeclaredMethod(iTypeBinding, iTypeBinding2.getName() + VALUE_METHOD, new String[0]);
            assert (iMethodBinding != null) : "could not find value method for " + iTypeBinding;
            return ASTFactory.newMethodInvocation(this.ast, iMethodBinding, NodeCopier.copySubtree(this.ast, expression));
        }
        return NodeCopier.copySubtree(this.ast, expression);
    }

    public void endVisit(Assignment assignment) {
        Expression expression = assignment.getLeftHandSide();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        Expression expression2 = assignment.getRightHandSide();
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression2);
        Assignment.Operator operator = assignment.getOperator();
        if (operator != Assignment.Operator.ASSIGN && !iTypeBinding.isPrimitive() && !iTypeBinding.equals(assignment.getAST().resolveWellKnownType("java.lang.String"))) {
            assignment.setOperator(Assignment.Operator.ASSIGN);
            assignment.setRightHandSide(this.box((Expression)this.newInfixExpression(expression, expression2, operator, iTypeBinding)));
        } else if (iTypeBinding.isPrimitive() && !iTypeBinding2.isPrimitive()) {
            assignment.setRightHandSide(this.unbox(expression2));
        } else if (!iTypeBinding.isPrimitive() && iTypeBinding2.isPrimitive()) {
            assignment.setRightHandSide(this.boxWithType(expression2, iTypeBinding));
        }
    }

    private InfixExpression newInfixExpression(Expression expression, Expression expression2, Assignment.Operator operator, ITypeBinding iTypeBinding) {
        InfixExpression.Operator operator2;
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setLeftOperand(this.unbox(expression));
        infixExpression.setRightOperand(this.unbox(expression2));
        if (operator == Assignment.Operator.PLUS_ASSIGN) {
            operator2 = InfixExpression.Operator.PLUS;
        } else if (operator == Assignment.Operator.MINUS_ASSIGN) {
            operator2 = InfixExpression.Operator.MINUS;
        } else if (operator == Assignment.Operator.TIMES_ASSIGN) {
            operator2 = InfixExpression.Operator.TIMES;
        } else if (operator == Assignment.Operator.DIVIDE_ASSIGN) {
            operator2 = InfixExpression.Operator.DIVIDE;
        } else if (operator == Assignment.Operator.BIT_AND_ASSIGN) {
            operator2 = InfixExpression.Operator.AND;
        } else if (operator == Assignment.Operator.BIT_OR_ASSIGN) {
            operator2 = InfixExpression.Operator.OR;
        } else if (operator == Assignment.Operator.BIT_XOR_ASSIGN) {
            operator2 = InfixExpression.Operator.XOR;
        } else if (operator == Assignment.Operator.REMAINDER_ASSIGN) {
            operator2 = InfixExpression.Operator.REMAINDER;
        } else if (operator == Assignment.Operator.LEFT_SHIFT_ASSIGN) {
            operator2 = InfixExpression.Operator.LEFT_SHIFT;
        } else if (operator == Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN) {
            operator2 = InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        } else if (operator == Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) {
            operator2 = InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        } else {
            throw new IllegalArgumentException();
        }
        infixExpression.setOperator(operator2);
        Types.addBinding(infixExpression, (IBinding)Types.getPrimitiveType(iTypeBinding));
        return infixExpression;
    }

    public void endVisit(ArrayAccess arrayAccess) {
        Expression expression = arrayAccess.getIndex();
        if (!Types.getTypeBinding(expression).isPrimitive()) {
            arrayAccess.setIndex(this.unbox(expression));
        }
    }

    public void endVisit(ArrayInitializer arrayInitializer) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(arrayInitializer).getElementType();
        List<Expression> list = ASTUtil.getExpressions(arrayInitializer);
        for (int i = 0; i < list.size(); ++i) {
            Expression expression;
            Expression expression2 = list.get(i);
            if (expression2 == (expression = this.boxOrUnboxExpression(expression2, iTypeBinding))) continue;
            list.set(i, expression);
        }
    }

    public void endVisit(CastExpression castExpression) {
        Expression expression = this.boxOrUnboxExpression(castExpression.getExpression(), Types.getTypeBinding(castExpression));
        if (expression != castExpression.getExpression()) {
            ASTNode aSTNode = castExpression.getParent();
            if (aSTNode instanceof ParenthesizedExpression) {
                ASTUtil.setProperty(aSTNode, (ASTNode)expression);
            } else {
                ASTUtil.setProperty((ASTNode)castExpression, (ASTNode)expression);
            }
        }
    }

    public void endVisit(ClassInstanceCreation classInstanceCreation) {
        this.convertArguments(Types.getMethodBinding(classInstanceCreation), ASTUtil.getArguments(classInstanceCreation));
    }

    public void endVisit(ConditionalExpression conditionalExpression) {
        Expression expression = conditionalExpression.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (!iTypeBinding.isPrimitive()) {
            conditionalExpression.setExpression(this.unbox(expression));
        }
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(conditionalExpression);
        Expression expression2 = conditionalExpression.getThenExpression();
        ITypeBinding iTypeBinding3 = Types.getTypeBinding(expression2);
        Expression expression3 = conditionalExpression.getElseExpression();
        ITypeBinding iTypeBinding4 = Types.getTypeBinding(expression3);
        if (iTypeBinding3.isPrimitive() && !iTypeBinding2.isPrimitive()) {
            conditionalExpression.setThenExpression(this.box(expression2));
        } else if (!iTypeBinding3.isPrimitive() && iTypeBinding2.isPrimitive()) {
            conditionalExpression.setThenExpression(this.unbox(expression2));
        }
        if (iTypeBinding4.isPrimitive() && !iTypeBinding2.isPrimitive()) {
            conditionalExpression.setElseExpression(this.box(expression3));
        } else if (!iTypeBinding4.isPrimitive() && iTypeBinding2.isPrimitive()) {
            conditionalExpression.setElseExpression(this.unbox(expression3));
        }
    }

    public void endVisit(ConstructorInvocation constructorInvocation) {
        this.convertArguments(Types.getMethodBinding(constructorInvocation), ASTUtil.getArguments(constructorInvocation));
    }

    public void endVisit(DoStatement doStatement) {
        Expression expression = doStatement.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (!iTypeBinding.isPrimitive()) {
            doStatement.setExpression(this.unbox(expression));
        }
    }

    public void endVisit(EnumConstantDeclaration enumConstantDeclaration) {
        this.convertArguments(Types.getMethodBinding(enumConstantDeclaration), ASTUtil.getArguments(enumConstantDeclaration));
    }

    public void endVisit(IfStatement ifStatement) {
        Expression expression = ifStatement.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (!iTypeBinding.isPrimitive()) {
            ifStatement.setExpression(this.unbox(expression));
        }
    }

    public void endVisit(InfixExpression infixExpression) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(infixExpression);
        Expression expression = infixExpression.getLeftOperand();
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression);
        Expression expression2 = infixExpression.getRightOperand();
        ITypeBinding iTypeBinding3 = Types.getTypeBinding(expression2);
        InfixExpression.Operator operator = infixExpression.getOperator();
        if (!(operator != InfixExpression.Operator.EQUALS && operator != InfixExpression.Operator.NOT_EQUALS || iTypeBinding2.isPrimitive() || iTypeBinding3.isPrimitive())) {
            return;
        }
        if (operator == InfixExpression.Operator.PLUS && Types.isJavaStringType(iTypeBinding)) {
            return;
        }
        if (!iTypeBinding2.isPrimitive()) {
            infixExpression.setLeftOperand(this.unbox(expression));
        }
        if (!iTypeBinding3.isPrimitive()) {
            infixExpression.setRightOperand(this.unbox(expression2));
        }
        List<Expression> list = ASTUtil.getExtendedOperands(infixExpression);
        for (int i = 0; i < list.size(); ++i) {
            Expression expression3 = list.get(i);
            if (Types.getTypeBinding(expression3).isPrimitive()) continue;
            list.set(i, this.unbox(expression3));
        }
    }

    public void endVisit(MethodInvocation methodInvocation) {
        this.convertArguments(Types.getMethodBinding(methodInvocation), ASTUtil.getArguments(methodInvocation));
    }

    public void endVisit(PrefixExpression prefixExpression) {
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        Expression expression = prefixExpression.getOperand();
        if (operator == PrefixExpression.Operator.INCREMENT) {
            this.rewriteBoxedPrefixOrPostfix((ASTNode)prefixExpression, expression, "PreIncr");
        } else if (operator == PrefixExpression.Operator.DECREMENT) {
            this.rewriteBoxedPrefixOrPostfix((ASTNode)prefixExpression, expression, "PreDecr");
        } else if (!Types.getTypeBinding(expression).isPrimitive()) {
            prefixExpression.setOperand(this.unbox(expression));
        }
    }

    public void endVisit(PostfixExpression postfixExpression) {
        PostfixExpression.Operator operator = postfixExpression.getOperator();
        if (operator == PostfixExpression.Operator.INCREMENT) {
            this.rewriteBoxedPrefixOrPostfix((ASTNode)postfixExpression, postfixExpression.getOperand(), "PostIncr");
        } else if (operator == PostfixExpression.Operator.DECREMENT) {
            this.rewriteBoxedPrefixOrPostfix((ASTNode)postfixExpression, postfixExpression.getOperand(), "PostDecr");
        }
    }

    private void rewriteBoxedPrefixOrPostfix(ASTNode aSTNode, Expression expression, String string) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (!Types.isBoxedPrimitive(iTypeBinding)) {
            return;
        }
        AST aST = aSTNode.getAST();
        String string2 = string + NameTable.capitalize(Types.getPrimitiveType(iTypeBinding).getName());
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newFunction(string2, iTypeBinding, iTypeBinding, new PointerTypeBinding(iTypeBinding));
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        ASTUtil.getArguments(methodInvocation).add((Expression)ASTFactory.newAddressOf(aST, NodeCopier.copySubtree(aST, expression)));
        ASTUtil.setProperty(aSTNode, (ASTNode)methodInvocation);
    }

    public void endVisit(ReturnStatement returnStatement) {
        Expression expression = returnStatement.getExpression();
        if (expression != null) {
            ASTNode aSTNode = returnStatement.getParent();
            while (!(aSTNode instanceof MethodDeclaration)) {
                aSTNode = aSTNode.getParent();
            }
            ITypeBinding iTypeBinding = Types.getMethodBinding(aSTNode).getReturnType();
            ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression);
            if (iTypeBinding.isPrimitive() && !iTypeBinding2.isPrimitive()) {
                returnStatement.setExpression(this.unbox(expression));
            }
            if (!iTypeBinding.isPrimitive() && iTypeBinding2.isPrimitive()) {
                returnStatement.setExpression(this.box(expression));
            }
        }
    }

    public void endVisit(SuperConstructorInvocation superConstructorInvocation) {
        this.convertArguments(Types.getMethodBinding(superConstructorInvocation), ASTUtil.getArguments(superConstructorInvocation));
    }

    public void endVisit(SuperMethodInvocation superMethodInvocation) {
        this.convertArguments(Types.getMethodBinding(superMethodInvocation), ASTUtil.getArguments(superMethodInvocation));
    }

    public void endVisit(VariableDeclarationFragment variableDeclarationFragment) {
        Expression expression = variableDeclarationFragment.getInitializer();
        if (expression != null) {
            ITypeBinding iTypeBinding = Types.getTypeBinding(variableDeclarationFragment);
            ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression);
            if (iTypeBinding.isPrimitive() && !iTypeBinding2.isPrimitive()) {
                variableDeclarationFragment.setInitializer(this.unbox(expression));
            } else if (!iTypeBinding.isPrimitive() && iTypeBinding2.isPrimitive()) {
                variableDeclarationFragment.setInitializer(this.boxWithType(expression, iTypeBinding));
            }
        }
    }

    public void endVisit(WhileStatement whileStatement) {
        Expression expression = whileStatement.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (!iTypeBinding.isPrimitive()) {
            whileStatement.setExpression(this.unbox(expression));
        }
    }

    public void endVisit(SwitchStatement switchStatement) {
        Expression expression = switchStatement.getExpression();
        ITypeBinding iTypeBinding = Types.getTypeBinding(expression);
        if (!iTypeBinding.isPrimitive()) {
            switchStatement.setExpression(this.unbox(expression));
        }
    }

    private void convertArguments(IMethodBinding iMethodBinding, List<Expression> list) {
        if (iMethodBinding instanceof IOSMethodBinding) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        for (int i = 0; i < list.size(); ++i) {
            ITypeBinding iTypeBinding = iMethodBinding.isVarargs() && i >= iTypeBindingArray.length - 1 ? iTypeBindingArray[iTypeBindingArray.length - 1].getComponentType() : iTypeBindingArray[i];
            Expression expression = list.get(i);
            Expression expression2 = this.boxOrUnboxExpression(expression, iTypeBinding);
            if (expression2 == expression) continue;
            list.set(i, expression2);
        }
    }

    private Expression boxOrUnboxExpression(Expression expression, ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2 = Types.getTypeBinding(expression);
        if (iTypeBinding.isPrimitive() && !iTypeBinding2.isPrimitive()) {
            return this.unbox(expression);
        }
        if (!iTypeBinding.isPrimitive() && iTypeBinding2.isPrimitive()) {
            return this.box(expression);
        }
        return expression;
    }
}

