/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.types.GeneratedTypeBinding;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.IOSTypeBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.PointerTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeLiteral;

public class ArrayRewriter
extends ErrorReportingASTVisitor {
    private static final IOSTypeBinding ARRAY_BASE_TYPE = IOSTypeBinding.newUnmappedClass("IOSArray");
    private static final ImmutableMap<String, String> INIT_METHODS = ImmutableMap.builder().put((Object)"IOSBooleanArray", (Object)" arrayWithBooleans:(BOOL *)booleans count:(int)count").put((Object)"IOSByteArray", (Object)" arrayWithBytes:(char *)bytes count:(int)count").put((Object)"IOSCharArray", (Object)" arrayWithChars:(unichar *)chars count:(int)count").put((Object)"IOSDoubleArray", (Object)" arrayWithDoubles:(double *)doubles count:(int)count").put((Object)"IOSFloatArray", (Object)" arrayWithFloats:(float *)floats count:(int)count").put((Object)"IOSIntArray", (Object)" arrayWithInts:(int *)ints count:(int)count").put((Object)"IOSLongArray", (Object)" arrayWithLongs:(long long *)longs count:(int)count").put((Object)"IOSShortArray", (Object)" arrayWithShorts:(shorts *)shorts count:(int)count").put((Object)"IOSObjectArray", (Object)" arrayWithObjects:(id *)objects count:(int)count type:(IOSClass *)type").build();
    private static final IOSMethod IOSCLASS_METHOD = IOSMethod.create("IOSArray iosClass");
    private static final IOSMethod IOSCLASS_METHOD_DIM = IOSMethod.create("IOSArray iosClassWithDimensions:(NSUInteger)dimensions");
    private static final IOSMethod IOSCLASS_METHOD_OBJ = IOSMethod.create("IOSObjectArray iosClassWithType:(IOSClass *)type");
    private static final IOSMethod IOSCLASS_METHOD_OBJ_DIM = IOSMethod.create("IOSObjectArray iosClassWithDimensions:(NSUInteger)dimensions type:(IOSClass *)type");
    private static final IOSMethod ISINSTANCE_METHOD = IOSMethod.create("IOSClass isInstance:(id)object");
    private Map<IOSTypeBinding, IOSMethodBinding> initMethods = Maps.newHashMap();
    private Map<IOSTypeBinding, IOSMethodBinding> singleDimMethods = Maps.newHashMap();
    private Map<IOSTypeBinding, IOSMethodBinding> multiDimMethods = Maps.newHashMap();
    private final IOSMethodBinding arrayCountMethod = IOSMethodBinding.newMethod(IOSMethod.create("IOSArray count"), 1, Types.resolveJavaType("int"), (ITypeBinding)ARRAY_BASE_TYPE);
    private Map<String, IOSMethodBinding> accessFunctions = Maps.newHashMap();
    private IOSMethodBinding objectArrayAssignmentFunction = ArrayRewriter.createObjectArrayAssignmentFunction();

    public void endVisit(ArrayCreation arrayCreation) {
        ASTUtil.setProperty((ASTNode)arrayCreation, (ASTNode)this.createInvocation(arrayCreation));
    }

    private MethodInvocation createInvocation(ArrayCreation arrayCreation) {
        AST aST = arrayCreation.getAST();
        ITypeBinding iTypeBinding = Types.getTypeBinding(arrayCreation);
        assert (iTypeBinding.isArray());
        ArrayInitializer arrayInitializer = arrayCreation.getInitializer();
        if (arrayInitializer != null) {
            return this.newInitializedArrayInvocation(aST, iTypeBinding, ASTUtil.getExpressions(arrayInitializer));
        }
        List<Expression> list = ASTUtil.getDimensions(arrayCreation);
        if (list.size() == 1) {
            return this.newSingleDimensionArrayInvocation(aST, iTypeBinding, list.get(0));
        }
        return this.newMultiDimensionArrayInvocation(aST, iTypeBinding, list);
    }

    public void endVisit(ArrayInitializer arrayInitializer) {
        ASTNode aSTNode = arrayInitializer.getParent();
        if (!(aSTNode instanceof ArrayCreation)) {
            ASTUtil.setProperty((ASTNode)arrayInitializer, (ASTNode)this.newInitializedArrayInvocation(arrayInitializer.getAST(), Types.getTypeBinding(arrayInitializer), ASTUtil.getExpressions(arrayInitializer)));
        }
    }

    private void rewriteVarargs(IMethodBinding iMethodBinding, List<Expression> list, AST aST) {
        Object object;
        if (!(iMethodBinding = iMethodBinding.getMethodDeclaration()).isVarargs() || IOSMethodBinding.hasVarArgsTarget(iMethodBinding)) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        ITypeBinding iTypeBinding = iTypeBindingArray[iTypeBindingArray.length - 1];
        assert (iTypeBinding.isArray());
        int n = list.size() - iTypeBindingArray.length + 1;
        if (n == 1) {
            object = Types.getTypeBinding(list.get(list.size() - 1));
            if (iTypeBinding.getDimensions() == object.getDimensions()) {
                return;
            }
        }
        object = list.subList(iTypeBindingArray.length - 1, list.size());
        ArrayList arrayList = Lists.newArrayList((Iterable)object);
        object.clear();
        if (arrayList.isEmpty()) {
            list.add((Expression)this.newSingleDimensionArrayInvocation(aST, iTypeBinding, ASTFactory.makeIntLiteral(aST, 0)));
        } else {
            ArrayInitializer arrayInitializer = aST.newArrayInitializer();
            Types.addBinding(arrayInitializer, (IBinding)iTypeBinding);
            ASTUtil.getExpressions(arrayInitializer).addAll(arrayList);
            list.add((Expression)arrayInitializer);
        }
    }

    private MethodInvocation newInitializedArrayInvocation(AST aST, ITypeBinding iTypeBinding, List<Expression> list) {
        ITypeBinding iTypeBinding2 = iTypeBinding.getComponentType();
        IOSTypeBinding iOSTypeBinding = Types.resolveArrayType(iTypeBinding2);
        IOSMethodBinding iOSMethodBinding = this.getInitializeMethod(iOSTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(aST, iOSTypeBinding));
        ArrayInitializer arrayInitializer = aST.newArrayInitializer();
        Types.addBinding(arrayInitializer, (IBinding)iTypeBinding);
        for (Expression expression : list) {
            ASTUtil.getExpressions(arrayInitializer).add(NodeCopier.copySubtree(aST, expression));
        }
        ASTUtil.getArguments(methodInvocation).add((Expression)arrayInitializer);
        ASTUtil.getArguments(methodInvocation).add(ASTFactory.makeIntLiteral(aST, arrayInitializer.expressions().size()));
        if (!iTypeBinding2.isPrimitive()) {
            ASTUtil.getArguments(methodInvocation).add(ArrayRewriter.newTypeLiteral(aST, iTypeBinding2));
        }
        return methodInvocation;
    }

    private IOSMethodBinding getInitializeMethod(IOSTypeBinding iOSTypeBinding) {
        IOSMethodBinding iOSMethodBinding = this.initMethods.get(iOSTypeBinding);
        if (iOSMethodBinding != null) {
            return iOSMethodBinding;
        }
        String string = (String)INIT_METHODS.get((Object)iOSTypeBinding.getName());
        assert (string != null);
        IOSMethod iOSMethod = IOSMethod.create(iOSTypeBinding.getName() + string);
        iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, 9, (ITypeBinding)iOSTypeBinding, (ITypeBinding)iOSTypeBinding);
        iOSMethodBinding.addParameter(iOSTypeBinding);
        iOSMethodBinding.addParameter(Types.resolveJavaType("int"));
        if (iOSTypeBinding.getName().equals("IOSObjectArray")) {
            iOSMethodBinding.addParameter(Types.getIOSClass());
        }
        this.initMethods.put(iOSTypeBinding, iOSMethodBinding);
        return iOSMethodBinding;
    }

    private MethodInvocation newSingleDimensionArrayInvocation(AST aST, ITypeBinding iTypeBinding, Expression expression) {
        ITypeBinding iTypeBinding2 = iTypeBinding.getComponentType();
        IOSTypeBinding iOSTypeBinding = Types.resolveArrayType(iTypeBinding2);
        IOSMethodBinding iOSMethodBinding = this.getSingleDimensionMethod(iOSTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(aST, iOSTypeBinding));
        ASTUtil.getArguments(methodInvocation).add(NodeCopier.copySubtree(aST, expression));
        if (!iTypeBinding2.isPrimitive()) {
            ASTUtil.getArguments(methodInvocation).add(ArrayRewriter.newTypeLiteral(aST, iTypeBinding2));
        }
        return methodInvocation;
    }

    private IOSMethodBinding getSingleDimensionMethod(IOSTypeBinding iOSTypeBinding) {
        IOSMethodBinding iOSMethodBinding = this.singleDimMethods.get(iOSTypeBinding);
        if (iOSMethodBinding != null) {
            return iOSMethodBinding;
        }
        boolean bl = iOSTypeBinding.getName().equals("IOSObjectArray");
        IOSMethod iOSMethod = IOSMethod.create(iOSTypeBinding.getName() + " arrayWithLength:(int)length" + (bl ? " type:(IOSClass *)type" : ""));
        iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, 9, (ITypeBinding)iOSTypeBinding, (ITypeBinding)iOSTypeBinding);
        iOSMethodBinding.addParameter(Types.resolveJavaType("int"));
        if (bl) {
            iOSMethodBinding.addParameter(Types.getIOSClass());
        }
        this.singleDimMethods.put(iOSTypeBinding, iOSMethodBinding);
        return iOSMethodBinding;
    }

    private MethodInvocation newMultiDimensionArrayInvocation(AST aST, ITypeBinding iTypeBinding, List<Expression> list) {
        assert (list.size() > 1);
        ITypeBinding iTypeBinding2 = iTypeBinding;
        for (int i = 0; i < list.size(); ++i) {
            iTypeBinding2 = iTypeBinding2.getComponentType();
        }
        IOSTypeBinding iOSTypeBinding = Types.resolveArrayType(iTypeBinding2);
        IOSMethodBinding iOSMethodBinding = this.getMultiDimensionMethod(iOSTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(aST, iOSTypeBinding));
        ASTUtil.getArguments(methodInvocation).add(ASTFactory.makeIntLiteral(aST, list.size()));
        ArrayInitializer arrayInitializer = aST.newArrayInitializer();
        Types.addBinding(arrayInitializer, GeneratedTypeBinding.newArrayType(Types.resolveJavaType("int")));
        for (Expression expression : list) {
            ASTUtil.getExpressions(arrayInitializer).add(NodeCopier.copySubtree(aST, expression));
        }
        ASTUtil.getArguments(methodInvocation).add((Expression)arrayInitializer);
        if (!iTypeBinding2.isPrimitive()) {
            ASTUtil.getArguments(methodInvocation).add(ArrayRewriter.newTypeLiteral(aST, iTypeBinding2));
        }
        return methodInvocation;
    }

    private IOSMethodBinding getMultiDimensionMethod(IOSTypeBinding iOSTypeBinding) {
        IOSMethodBinding iOSMethodBinding = this.multiDimMethods.get(iOSTypeBinding);
        if (iOSMethodBinding != null) {
            return iOSMethodBinding;
        }
        boolean bl = iOSTypeBinding.getName().equals("IOSObjectArray");
        IOSMethod iOSMethod = IOSMethod.create(iOSTypeBinding.getName() + " arrayWithDimensions:(int)dimensionCount lengths:(int *)dimensionLengths" + (bl ? " type:(IOSClass *)type" : ""));
        iOSMethodBinding = IOSMethodBinding.newMethod(iOSMethod, 9, Types.resolveIOSType("IOSObjectArray"), (ITypeBinding)iOSTypeBinding);
        ITypeBinding iTypeBinding = Types.resolveJavaType("int");
        iOSMethodBinding.addParameter(iTypeBinding);
        iOSMethodBinding.addParameter(GeneratedTypeBinding.newArrayType(iTypeBinding));
        if (bl) {
            iOSMethodBinding.addParameter(Types.getIOSClass());
        }
        this.multiDimMethods.put(iOSTypeBinding, iOSMethodBinding);
        return iOSMethodBinding;
    }

    public void endVisit(ArrayAccess arrayAccess) {
        AST aST = arrayAccess.getAST();
        ITypeBinding iTypeBinding = Types.getTypeBinding(arrayAccess.getArray());
        assert (iTypeBinding.isArray());
        ITypeBinding iTypeBinding2 = iTypeBinding.getComponentType();
        IOSTypeBinding iOSTypeBinding = Types.resolveArrayType(iTypeBinding2);
        Assignment assignment = ArrayRewriter.getArrayAssignment(arrayAccess);
        if (assignment != null && !iTypeBinding2.isPrimitive()) {
            assignment.getRightHandSide().accept((ASTVisitor)this);
            ASTUtil.setProperty((ASTNode)assignment, (ASTNode)this.newArrayAssignment(aST, assignment, arrayAccess, iTypeBinding2));
        } else {
            boolean bl = assignment != null || ArrayRewriter.needsAssignableAccess(arrayAccess);
            ASTUtil.setProperty((ASTNode)arrayAccess, (ASTNode)this.newArrayAccess(aST, arrayAccess, iTypeBinding2, iOSTypeBinding, bl));
        }
    }

    private static Assignment getArrayAssignment(ArrayAccess arrayAccess) {
        Assignment assignment;
        ASTNode aSTNode = arrayAccess.getParent();
        if (aSTNode instanceof Assignment && arrayAccess == (assignment = (Assignment)aSTNode).getLeftHandSide()) {
            return assignment;
        }
        return null;
    }

    private static boolean needsAssignableAccess(ArrayAccess arrayAccess) {
        PrefixExpression.Operator operator;
        PostfixExpression.Operator operator2;
        ASTNode aSTNode = arrayAccess.getParent();
        return aSTNode instanceof PostfixExpression ? (operator2 = ((PostfixExpression)aSTNode).getOperator()) == PostfixExpression.Operator.INCREMENT || operator2 == PostfixExpression.Operator.DECREMENT : aSTNode instanceof PrefixExpression && ((operator = ((PrefixExpression)aSTNode).getOperator()) == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT);
    }

    private IOSMethodBinding getArrayAccessBinding(ITypeBinding iTypeBinding, IOSTypeBinding iOSTypeBinding, boolean bl) {
        IOSMethodBinding iOSMethodBinding;
        String string = iOSTypeBinding.getName() + "_Get";
        if (bl) {
            string = string + "Ref";
        }
        if ((iOSMethodBinding = this.accessFunctions.get(string)) == null) {
            ITypeBinding iTypeBinding2;
            ITypeBinding iTypeBinding3 = iTypeBinding2 = iTypeBinding.isPrimitive() ? iTypeBinding : Types.resolveIOSType("id");
            if (bl) {
                iTypeBinding2 = new PointerTypeBinding(iTypeBinding2);
            }
            iOSMethodBinding = IOSMethodBinding.newFunction(string, iTypeBinding2, iOSTypeBinding, iOSTypeBinding, Types.resolveJavaType("int"));
            this.accessFunctions.put(string, iOSMethodBinding);
        }
        return iOSMethodBinding;
    }

    private MethodInvocation newArrayAccess(AST aST, ArrayAccess arrayAccess, ITypeBinding iTypeBinding, IOSTypeBinding iOSTypeBinding, boolean bl) {
        IOSMethodBinding iOSMethodBinding = this.getArrayAccessBinding(iTypeBinding, iOSTypeBinding, bl);
        if (!iTypeBinding.isPrimitive()) {
            iOSMethodBinding = IOSMethodBinding.newTypedInvocation(iOSMethodBinding, iTypeBinding);
        }
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        ASTUtil.getArguments(methodInvocation).add(NodeCopier.copySubtree(aST, arrayAccess.getArray()));
        ASTUtil.getArguments(methodInvocation).add(NodeCopier.copySubtree(aST, arrayAccess.getIndex()));
        if (bl) {
            methodInvocation = ASTFactory.newDereference(aST, (Expression)methodInvocation);
        }
        return methodInvocation;
    }

    private static IOSMethodBinding createObjectArrayAssignmentFunction() {
        ITypeBinding iTypeBinding = Types.resolveIOSType("id");
        ITypeBinding iTypeBinding2 = Types.resolveIOSType("IOSObjectArray");
        return IOSMethodBinding.newFunction("IOSObjectArray_Set", iTypeBinding, iTypeBinding2, iTypeBinding2, Types.resolveJavaType("int"), iTypeBinding);
    }

    private MethodInvocation newArrayAssignment(AST aST, Assignment assignment, ArrayAccess arrayAccess, ITypeBinding iTypeBinding) {
        Assignment.Operator operator = assignment.getOperator();
        assert (!iTypeBinding.isPrimitive());
        assert (operator == Assignment.Operator.ASSIGN);
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newTypedInvocation(this.objectArrayAssignmentFunction, iTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, null);
        List<Expression> list = ASTUtil.getArguments(methodInvocation);
        list.add(NodeCopier.copySubtree(aST, arrayAccess.getArray()));
        list.add(NodeCopier.copySubtree(aST, arrayAccess.getIndex()));
        list.add(NodeCopier.copySubtree(aST, assignment.getRightHandSide()));
        return methodInvocation;
    }

    public void endVisit(FieldAccess fieldAccess) {
        this.maybeRewriteArrayLength((Expression)fieldAccess, fieldAccess.getName(), fieldAccess.getExpression());
    }

    public void endVisit(QualifiedName qualifiedName) {
        this.maybeRewriteArrayLength((Expression)qualifiedName, qualifiedName.getName(), (Expression)qualifiedName.getQualifier());
    }

    private void maybeRewriteArrayLength(Expression expression, SimpleName simpleName, Expression expression2) {
        if (simpleName.getIdentifier().equals("length") && Types.getTypeBinding(expression2).isArray()) {
            AST aST = expression.getAST();
            ASTUtil.setProperty((ASTNode)expression, (ASTNode)ASTFactory.newCastExpression(aST, (Expression)ASTFactory.newMethodInvocation(aST, this.arrayCountMethod, NodeCopier.copySubtree(aST, expression2)), Types.resolveJavaType("int")));
        }
    }

    public void endVisit(InstanceofExpression instanceofExpression) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(instanceofExpression.getRightOperand());
        if (!iTypeBinding.isArray() || iTypeBinding.getComponentType().isPrimitive()) {
            return;
        }
        AST aST = instanceofExpression.getAST();
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMethod(ISINSTANCE_METHOD, 1, Types.resolveJavaType("boolean"), Types.getIOSClass());
        iOSMethodBinding.addParameter(Types.resolveIOSType("id"));
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ArrayRewriter.newTypeLiteralInvocation(aST, iTypeBinding));
        ASTUtil.getArguments(methodInvocation).add(NodeCopier.copySubtree(aST, instanceofExpression.getLeftOperand()));
        ASTUtil.setProperty((ASTNode)instanceofExpression, (ASTNode)methodInvocation);
    }

    public void endVisit(TypeLiteral typeLiteral) {
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeLiteral.getType());
        if (iTypeBinding.isArray()) {
            ASTUtil.setProperty((ASTNode)typeLiteral, (ASTNode)ArrayRewriter.newTypeLiteralInvocation(typeLiteral.getAST(), iTypeBinding));
        }
    }

    private static Expression newTypeLiteral(AST aST, ITypeBinding iTypeBinding) {
        if (iTypeBinding.isArray()) {
            return ArrayRewriter.newTypeLiteralInvocation(aST, iTypeBinding);
        }
        return ASTFactory.newTypeLiteral(aST, iTypeBinding);
    }

    private static MethodInvocation newTypeLiteralInvocation(AST aST, ITypeBinding iTypeBinding) {
        assert (iTypeBinding.isArray());
        ITypeBinding iTypeBinding2 = iTypeBinding.getElementType();
        IOSTypeBinding iOSTypeBinding = Types.resolveArrayType(iTypeBinding2);
        int n = iTypeBinding.getDimensions();
        IOSMethodBinding iOSMethodBinding = IOSMethodBinding.newMethod(ArrayRewriter.getTypeLiteralMethod(iTypeBinding2, n), 9, Types.getIOSClass(), (ITypeBinding)iOSTypeBinding);
        MethodInvocation methodInvocation = ASTFactory.newMethodInvocation(aST, iOSMethodBinding, (Expression)ASTFactory.newSimpleName(aST, iOSTypeBinding));
        if (n > 1) {
            iOSMethodBinding.addParameter(Types.resolveJavaType("int"));
            ASTUtil.getArguments(methodInvocation).add(ASTFactory.makeLiteral(aST, n, Types.resolveJavaType("int")));
        }
        if (!iTypeBinding2.isPrimitive()) {
            iOSMethodBinding.addParameter(Types.getIOSClass());
            ASTUtil.getArguments(methodInvocation).add(ArrayRewriter.newTypeLiteral(aST, iTypeBinding2));
        }
        return methodInvocation;
    }

    private static IOSMethod getTypeLiteralMethod(ITypeBinding iTypeBinding, int n) {
        if (iTypeBinding.isPrimitive()) {
            if (n > 1) {
                return IOSCLASS_METHOD_DIM;
            }
            return IOSCLASS_METHOD;
        }
        if (n > 1) {
            return IOSCLASS_METHOD_OBJ_DIM;
        }
        return IOSCLASS_METHOD_OBJ;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.rewriteVarargs(Types.getMethodBinding(classInstanceCreation), ASTUtil.getArguments(classInstanceCreation), classInstanceCreation.getAST());
        return true;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.rewriteVarargs(Types.getMethodBinding(constructorInvocation), ASTUtil.getArguments(constructorInvocation), constructorInvocation.getAST());
        return true;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        this.rewriteVarargs(Types.getMethodBinding(enumConstantDeclaration), ASTUtil.getArguments(enumConstantDeclaration), enumConstantDeclaration.getAST());
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.rewriteVarargs(Types.getMethodBinding(methodInvocation), ASTUtil.getArguments(methodInvocation), methodInvocation.getAST());
        return true;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.rewriteVarargs(Types.getMethodBinding(superConstructorInvocation), ASTUtil.getArguments(superConstructorInvocation), superConstructorInvocation.getAST());
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        this.rewriteVarargs(Types.getMethodBinding(superMethodInvocation), ASTUtil.getArguments(superMethodInvocation), superMethodInvocation.getAST());
        return true;
    }
}

