/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.translate;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.j2objc.translate.ASTFactory;
import com.google.devtools.j2objc.translate.OuterReferenceResolver;
import com.google.devtools.j2objc.types.GeneratedMethodBinding;
import com.google.devtools.j2objc.types.GeneratedVariableBinding;
import com.google.devtools.j2objc.types.NodeCopier;
import com.google.devtools.j2objc.types.RenamedTypeBinding;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.ErrorReportingASTVisitor;
import com.google.devtools.j2objc.util.NameTable;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class AnonymousClassConverter
extends ErrorReportingASTVisitor {
    private final CompilationUnit unit;

    public AnonymousClassConverter(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        this.preProcessUnit(compilationUnit);
        return true;
    }

    @VisibleForTesting
    void preProcessUnit(CompilationUnit compilationUnit) {
        compilationUnit.accept((ASTVisitor)new AnonymousClassRenamer());
    }

    public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
        Object object;
        List<Expression> list;
        ITypeBinding iTypeBinding = Types.getTypeBinding(anonymousClassDeclaration);
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        ASTNode aSTNode = anonymousClassDeclaration.getParent();
        ClassInstanceCreation classInstanceCreation = null;
        EnumConstantDeclaration enumConstantDeclaration = null;
        Expression expression = null;
        String string = iTypeBinding.getName();
        ITypeBinding iTypeBinding3 = RenamedTypeBinding.rename(string, iTypeBinding2, iTypeBinding, 0);
        if (aSTNode instanceof ClassInstanceCreation) {
            classInstanceCreation = (ClassInstanceCreation)aSTNode;
            list = ASTUtil.getArguments(classInstanceCreation);
            expression = classInstanceCreation.getExpression();
            classInstanceCreation.setExpression(null);
        } else if (aSTNode instanceof EnumConstantDeclaration) {
            enumConstantDeclaration = (EnumConstantDeclaration)aSTNode;
            list = ASTUtil.getArguments(enumConstantDeclaration);
        } else {
            throw new AssertionError((Object)("unknown anonymous class declaration parent: " + aSTNode.getClass().getName()));
        }
        AST aST = anonymousClassDeclaration.getAST();
        TypeDeclaration typeDeclaration = aST.newTypeDeclaration();
        Types.addBinding(typeDeclaration, (IBinding)iTypeBinding3);
        typeDeclaration.setName(aST.newSimpleName(string));
        Types.addBinding(typeDeclaration.getName(), (IBinding)iTypeBinding3);
        typeDeclaration.setSourceRange(anonymousClassDeclaration.getStartPosition(), anonymousClassDeclaration.getLength());
        Type type = ASTFactory.newType(aST, Types.mapType(iTypeBinding3.getSuperclass()));
        typeDeclaration.setSuperclassType(type);
        for (ITypeBinding iTypeBinding4 : iTypeBinding3.getInterfaces()) {
            ASTUtil.getSuperInterfaceTypes(typeDeclaration).add(ASTFactory.newType(aST, Types.mapType(iTypeBinding4)));
        }
        for (Object e : anonymousClassDeclaration.bodyDeclarations()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)e;
            ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration).add(NodeCopier.copySubtree(aST, bodyDeclaration));
        }
        if (!list.isEmpty() || expression != null) {
            object = this.addDefaultConstructor(typeDeclaration, list, expression);
            Types.addBinding(aSTNode, (IBinding)object);
            if (expression != null) {
                list.add(0, NodeCopier.copySubtree(aST, expression));
            }
            assert (((GeneratedMethodBinding)object).getParameterTypes().length == list.size());
        }
        if (classInstanceCreation != null) {
            classInstanceCreation.setAnonymousClassDeclaration(null);
            classInstanceCreation.setType(ASTFactory.newType(aST, iTypeBinding3));
            object = Types.getMethodBinding(classInstanceCreation);
            if (object != null) {
                GeneratedMethodBinding generatedMethodBinding = new GeneratedMethodBinding((IMethodBinding)object);
                generatedMethodBinding.setDeclaringClass(iTypeBinding3);
                Types.addBinding(classInstanceCreation, generatedMethodBinding);
            }
        } else {
            enumConstantDeclaration.setAnonymousClassDeclaration(null);
        }
        if (iTypeBinding2.isAnonymous()) {
            object = aSTNode.getParent();
            while (!(object instanceof AnonymousClassDeclaration) && !(object instanceof TypeDeclaration)) {
                object = object.getParent();
            }
            if (object instanceof AnonymousClassDeclaration) {
                AnonymousClassDeclaration anonymousClassDeclaration2 = (AnonymousClassDeclaration)object;
                ASTUtil.getBodyDeclarations(anonymousClassDeclaration2).add((BodyDeclaration)typeDeclaration);
            }
        } else {
            object = (AbstractTypeDeclaration)this.unit.findDeclaringNode((IBinding)iTypeBinding2);
            ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)object).add((BodyDeclaration)typeDeclaration);
        }
        OuterReferenceResolver.copyNode((ASTNode)anonymousClassDeclaration, (ASTNode)typeDeclaration);
        super.endVisit(anonymousClassDeclaration);
    }

    private GeneratedMethodBinding addDefaultConstructor(TypeDeclaration typeDeclaration, List<Expression> list, Expression expression) {
        AST aST = typeDeclaration.getAST();
        ITypeBinding iTypeBinding = Types.getTypeBinding(typeDeclaration);
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setConstructor(true);
        ITypeBinding iTypeBinding2 = aST.resolveWellKnownType("void");
        GeneratedMethodBinding generatedMethodBinding = GeneratedMethodBinding.newConstructor(iTypeBinding, 0);
        Types.addBinding(methodDeclaration, generatedMethodBinding);
        Types.addBinding(methodDeclaration.getReturnType2(), (IBinding)iTypeBinding2);
        SimpleName simpleName = aST.newSimpleName("init");
        Types.addBinding(simpleName, generatedMethodBinding);
        methodDeclaration.setName(simpleName);
        methodDeclaration.setBody(aST.newBlock());
        IMethodBinding iMethodBinding = this.findSuperConstructorBinding(iTypeBinding.getSuperclass(), list);
        SuperConstructorInvocation superConstructorInvocation = ASTFactory.newSuperConstructorInvocation(aST, iMethodBinding);
        if (expression != null) {
            ITypeBinding iTypeBinding3 = Types.getTypeBinding(expression);
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("superOuter$", 16, iTypeBinding3, false, true, iTypeBinding, generatedMethodBinding);
            ASTUtil.getParameters(methodDeclaration).add(0, ASTFactory.newSingleVariableDeclaration(aST, generatedVariableBinding));
            generatedMethodBinding.addParameter(0, iTypeBinding3);
            superConstructorInvocation.setExpression((Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        }
        int n = 0;
        for (Expression expression2 : list) {
            ITypeBinding iTypeBinding4 = expression2 instanceof NullLiteral ? Types.getNSObject() : Types.getTypeBinding(expression2);
            GeneratedVariableBinding generatedVariableBinding = new GeneratedVariableBinding("arg$" + n++, 0, iTypeBinding4, false, true, iTypeBinding, generatedMethodBinding);
            ASTUtil.getParameters(methodDeclaration).add(ASTFactory.newSingleVariableDeclaration(aST, generatedVariableBinding));
            generatedMethodBinding.addParameter(iTypeBinding4);
            ASTUtil.getArguments(superConstructorInvocation).add((Expression)ASTFactory.newSimpleName(aST, generatedVariableBinding));
        }
        assert (superConstructorInvocation.arguments().size() == iMethodBinding.getParameterTypes().length);
        ASTUtil.getStatements(methodDeclaration.getBody()).add((Statement)superConstructorInvocation);
        ASTUtil.getBodyDeclarations((AbstractTypeDeclaration)typeDeclaration).add((BodyDeclaration)methodDeclaration);
        assert (methodDeclaration.parameters().size() == generatedMethodBinding.getParameterTypes().length);
        return generatedMethodBinding;
    }

    private IMethodBinding findSuperConstructorBinding(ITypeBinding iTypeBinding, List<Expression> list) {
        if (iTypeBinding == null) {
            throw new AssertionError((Object)"could not find constructor");
        }
        block0: for (IMethodBinding iMethodBinding : iTypeBinding.getDeclaredMethods()) {
            if (!iMethodBinding.isConstructor()) continue;
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            if (list.size() != iTypeBindingArray.length) continue;
            for (int i = 0; i < iTypeBindingArray.length; ++i) {
                ITypeBinding iTypeBinding2 = Types.getTypeBinding(list.get(i)).getErasure();
                if (!iTypeBinding2.isAssignmentCompatible(iTypeBindingArray[i].getErasure())) continue block0;
            }
            return iMethodBinding;
        }
        return this.findSuperConstructorBinding(iTypeBinding.getSuperclass(), list);
    }

    static class AnonymousClassRenamer
    extends ASTVisitor {
        final Stack<Frame> classIndex = new Stack();

        AnonymousClassRenamer() {
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return this.processType((AbstractTypeDeclaration)typeDeclaration);
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            return this.processType((AbstractTypeDeclaration)enumDeclaration);
        }

        private boolean processType(AbstractTypeDeclaration abstractTypeDeclaration) {
            this.classIndex.push(new Frame());
            return true;
        }

        public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
            Frame frame = this.classIndex.peek();
            String string = "$" + ++frame.classCount;
            ITypeBinding iTypeBinding = this.renameClass(string, Types.getTypeBinding(anonymousClassDeclaration));
            Types.addBinding(anonymousClassDeclaration, (IBinding)iTypeBinding);
            NameTable.rename((IBinding)Types.getTypeBinding(anonymousClassDeclaration), string);
            this.classIndex.push(new Frame());
            return true;
        }

        private ITypeBinding renameClass(String string, ITypeBinding iTypeBinding) {
            ITypeBinding iTypeBinding2 = Types.getRenamedBinding(iTypeBinding.getDeclaringClass());
            NameTable.rename((IBinding)iTypeBinding, string);
            ITypeBinding iTypeBinding3 = Types.renameTypeBinding(string, iTypeBinding2, iTypeBinding);
            assert (iTypeBinding3.getName().equals(string));
            return iTypeBinding3;
        }

        public void endVisit(TypeDeclaration typeDeclaration) {
            this.classIndex.pop();
        }

        public void endVisit(EnumDeclaration enumDeclaration) {
            this.classIndex.pop();
        }

        public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
            this.classIndex.pop();
        }

        private static class Frame {
            int classCount = 0;

            private Frame() {
            }
        }
    }
}

