/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.j2objc.gen;

import com.google.common.collect.Lists;
import com.google.devtools.j2objc.Options;
import com.google.devtools.j2objc.gen.SourceFileGenerator;
import com.google.devtools.j2objc.types.IOSMethod;
import com.google.devtools.j2objc.types.IOSMethodBinding;
import com.google.devtools.j2objc.types.IOSParameter;
import com.google.devtools.j2objc.types.Types;
import com.google.devtools.j2objc.util.ASTUtil;
import com.google.devtools.j2objc.util.BindingUtil;
import com.google.devtools.j2objc.util.NameTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public abstract class ObjectiveCSourceFileGenerator
extends SourceFileGenerator {
    protected ObjectiveCSourceFileGenerator(String string, String string2, CompilationUnit compilationUnit, boolean bl) {
        super(string, string2, compilationUnit, bl);
    }

    public void generate(AbstractTypeDeclaration abstractTypeDeclaration) {
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            this.generate((TypeDeclaration)abstractTypeDeclaration);
        } else if (abstractTypeDeclaration instanceof EnumDeclaration) {
            this.generate((EnumDeclaration)abstractTypeDeclaration);
        } else if (abstractTypeDeclaration instanceof AnnotationTypeDeclaration) {
            this.generate((AnnotationTypeDeclaration)abstractTypeDeclaration);
        }
    }

    protected abstract void generate(TypeDeclaration var1);

    protected abstract void generate(EnumDeclaration var1);

    protected abstract void generate(AnnotationTypeDeclaration var1);

    public void save(CompilationUnit compilationUnit) {
        this.save(this.getOutputFileName(compilationUnit));
    }

    protected void printStaticFieldAccessors(List<FieldDeclaration> list, List<MethodDeclaration> list2, boolean bl) {
        this.printStaticFieldAccessors(this.getStaticFieldsNeedingAccessors(list, bl), list2);
    }

    protected void printStaticFieldAccessors(List<IVariableBinding> list, List<MethodDeclaration> list2) {
        for (IVariableBinding iVariableBinding : list) {
            if (this.needsGetter(iVariableBinding, list2)) {
                this.printStaticFieldGetter(iVariableBinding);
            }
            if (Modifier.isFinal((int)iVariableBinding.getModifiers())) continue;
            if (iVariableBinding.getType().isPrimitive()) {
                this.printStaticFieldReferenceGetter(iVariableBinding);
                continue;
            }
            this.printStaticFieldSetter(iVariableBinding);
        }
    }

    protected List<IVariableBinding> getStaticFieldsNeedingAccessors(List<FieldDeclaration> list, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        for (FieldDeclaration fieldDeclaration : list) {
            if (!Modifier.isStatic((int)fieldDeclaration.getModifiers()) && !bl) continue;
            for (VariableDeclarationFragment variableDeclarationFragment : ASTUtil.getFragments(fieldDeclaration)) {
                IVariableBinding iVariableBinding = Types.getVariableBinding(variableDeclarationFragment);
                arrayList.add(iVariableBinding);
            }
        }
        return arrayList;
    }

    private boolean needsGetter(IVariableBinding iVariableBinding, List<MethodDeclaration> list) {
        String string = NameTable.getStaticAccessorName(iVariableBinding.getName());
        ITypeBinding iTypeBinding = iVariableBinding.getType();
        for (MethodDeclaration methodDeclaration : list) {
            IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
            if (!iMethodBinding.getName().equals(string) || !iMethodBinding.getReturnType().isEqualTo((IBinding)iTypeBinding) || iMethodBinding.getParameterTypes().length != 0) continue;
            return false;
        }
        return true;
    }

    protected void printStaticFieldGetter(IVariableBinding iVariableBinding) {
        this.printf(this.staticFieldGetterSignature(iVariableBinding), new Object[0]);
    }

    protected String staticFieldGetterSignature(IVariableBinding iVariableBinding) {
        String string = NameTable.getObjCType(iVariableBinding.getType());
        String string2 = NameTable.getStaticAccessorName(iVariableBinding.getName());
        return String.format("+ (%s)%s", string, string2);
    }

    protected void printStaticFieldReferenceGetter(IVariableBinding iVariableBinding) {
        this.printf(this.staticFieldReferenceGetterSignature(iVariableBinding), new Object[0]);
    }

    protected String staticFieldReferenceGetterSignature(IVariableBinding iVariableBinding) {
        String string = NameTable.getObjCType(iVariableBinding.getType());
        String string2 = NameTable.getStaticAccessorName(iVariableBinding.getName());
        return String.format("+ (%s *)%sRef", string, string2);
    }

    protected void printStaticFieldSetter(IVariableBinding iVariableBinding) {
        this.printf(this.staticFieldSetterSignature(iVariableBinding), new Object[0]);
    }

    protected String staticFieldSetterSignature(IVariableBinding iVariableBinding) {
        String string = NameTable.getObjCType(iVariableBinding.getType());
        String string2 = NameTable.getName((IBinding)iVariableBinding);
        return String.format("+ (void)set%s:(%s)%s", NameTable.capitalize(iVariableBinding.getName()), string, string2);
    }

    protected void printMethods(List<MethodDeclaration> list) {
        for (MethodDeclaration methodDeclaration : list) {
            this.printMethod(methodDeclaration);
        }
    }

    protected void printMethod(MethodDeclaration methodDeclaration) {
        this.syncLineNumbers((ASTNode)methodDeclaration.getName());
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        IOSMethod iOSMethod = IOSMethodBinding.getIOSMethod(iMethodBinding);
        if (iOSMethod != null) {
            this.print(this.mappedMethodDeclaration(methodDeclaration, iOSMethod));
        } else if (methodDeclaration.isConstructor()) {
            this.print(this.constructorDeclaration(methodDeclaration));
        } else if (Modifier.isStatic((int)methodDeclaration.getModifiers()) && "initialize".equals(methodDeclaration.getName().getIdentifier())) {
            this.printStaticConstructorDeclaration(methodDeclaration);
        } else {
            this.printNormalMethod(methodDeclaration);
        }
    }

    protected void printNormalMethod(MethodDeclaration methodDeclaration) {
        this.print(this.methodDeclaration(methodDeclaration));
    }

    protected String mappedMethodDeclaration(MethodDeclaration methodDeclaration, IOSMethod iOSMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = iOSMethod.getName().equals("hash") ? "- (NSUInteger)hash" : String.format("%c (%s)%s", Character.valueOf(Modifier.isStatic((int)methodDeclaration.getModifiers()) ? (char)'+' : '-'), NameTable.getObjCType(Types.getTypeBinding(methodDeclaration.getReturnType2())), iOSMethod.getName());
        stringBuffer.append(string);
        Iterator<IOSParameter> iterator = iOSMethod.getParameters().iterator();
        if (iterator.hasNext()) {
            List<SingleVariableDeclaration> list = ASTUtil.getParameters(methodDeclaration);
            IOSParameter iOSParameter = iterator.next();
            SingleVariableDeclaration singleVariableDeclaration = list.get(iOSParameter.getIndex());
            this.addTypeAndName(iOSParameter, singleVariableDeclaration, stringBuffer);
            if (iterator.hasNext()) {
                stringBuffer.append(iOSMethod.isVarArgs() ? ", " : " ");
                IOSParameter iOSParameter2 = iterator.next();
                stringBuffer.append(iOSParameter2.getParameterName());
                singleVariableDeclaration = list.get(iOSParameter2.getIndex());
                this.addTypeAndName(iOSParameter2, singleVariableDeclaration, stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    private void addTypeAndName(IOSParameter iOSParameter, SingleVariableDeclaration singleVariableDeclaration, StringBuffer stringBuffer) {
        stringBuffer.append(":(");
        stringBuffer.append(iOSParameter.getType());
        stringBuffer.append(')');
        stringBuffer.append(singleVariableDeclaration.getName().getIdentifier());
    }

    protected String methodDeclaration(MethodDeclaration methodDeclaration) {
        assert (!methodDeclaration.isConstructor());
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Modifier.isStatic((int)methodDeclaration.getModifiers());
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        String string = NameTable.getName((IBinding)iMethodBinding);
        String string2 = String.format("%c (%s)%s", Character.valueOf(bl ? (char)'+' : '-'), NameTable.getObjCType(iMethodBinding.getReturnType()), string);
        stringBuffer.append(string2);
        this.parametersDeclaration(iMethodBinding, ASTUtil.getParameters(methodDeclaration), string2, stringBuffer);
        return stringBuffer.toString();
    }

    protected String constructorDeclaration(MethodDeclaration methodDeclaration) {
        return this.constructorDeclaration(methodDeclaration, false);
    }

    protected String constructorDeclaration(MethodDeclaration methodDeclaration, boolean bl) {
        assert (methodDeclaration.isConstructor());
        StringBuffer stringBuffer = new StringBuffer();
        IMethodBinding iMethodBinding = Types.getMethodBinding(methodDeclaration);
        String string = "- (id)init";
        if (bl) {
            string = string + NameTable.getFullName(iMethodBinding.getDeclaringClass());
        }
        stringBuffer.append(string);
        this.parametersDeclaration(iMethodBinding, ASTUtil.getParameters(methodDeclaration), string, stringBuffer);
        return stringBuffer.toString();
    }

    protected String annotationConstructorDeclaration(ITypeBinding iTypeBinding) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("- (id)init");
        IMethodBinding[] iMethodBindingArray = BindingUtil.getSortedAnnotationMembers(iTypeBinding);
        for (int i = 0; i < iMethodBindingArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append("With");
            } else {
                stringBuffer.append(" with");
            }
            IMethodBinding iMethodBinding = iMethodBindingArray[i];
            stringBuffer.append(NameTable.capitalize(iMethodBinding.getName()));
            stringBuffer.append(":(");
            stringBuffer.append(NameTable.getSpecificObjCType(iMethodBinding.getReturnType()));
            stringBuffer.append(')');
            stringBuffer.append(iMethodBinding.getName());
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    protected abstract void printStaticConstructorDeclaration(MethodDeclaration var1);

    private void parametersDeclaration(IMethodBinding iMethodBinding, List<SingleVariableDeclaration> list, String string, StringBuffer stringBuffer) throws AssertionError {
        Object object;
        iMethodBinding = BindingUtil.getOriginalMethodBinding(iMethodBinding);
        if (!list.isEmpty()) {
            object = iMethodBinding.getParameterTypes();
            boolean bl = true;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                SingleVariableDeclaration singleVariableDeclaration = list.get(i);
                String string2 = this.getParameterName(singleVariableDeclaration);
                if (string2.equals("__empty_parameter__")) {
                    string2 = "";
                }
                Object object2 = object[i];
                String string3 = NameTable.parameterKeyword((ITypeBinding)object2);
                if (bl) {
                    stringBuffer.append(NameTable.capitalize(string3));
                    string = string + string3;
                    bl = false;
                } else {
                    stringBuffer.append(this.pad(string.length() - string3.length()));
                    stringBuffer.append(string3);
                }
                stringBuffer.append(String.format(":(%s)%s", NameTable.getSpecificObjCType(Types.getTypeBinding(singleVariableDeclaration)), string2));
                if (i + 1 >= n) continue;
                stringBuffer.append('\n');
            }
        }
        if (iMethodBinding.isConstructor() && iMethodBinding.getDeclaringClass().isEnum()) {
            if (list.isEmpty()) {
                stringBuffer.append("WithNSString:(NSString *)__name withInt:(int)__ordinal");
            } else {
                stringBuffer.append('\n');
                object = "withNSString";
                stringBuffer.append(this.pad(string.length() - ((String)object).length()));
                stringBuffer.append((String)object);
                stringBuffer.append(":(NSString *)__name\n");
                object = "withInt";
                stringBuffer.append(this.pad(string.length() - ((String)object).length()));
                stringBuffer.append((String)object);
                stringBuffer.append(":(int)__ordinal");
            }
        }
    }

    protected String getParameterName(SingleVariableDeclaration singleVariableDeclaration) {
        String string = NameTable.getName(singleVariableDeclaration.getName());
        if (NameTable.isReservedName(string)) {
            string = string + "Arg";
        }
        return string;
    }

    protected void pushIgnoreDeprecatedDeclarationsPragma() {
        if (Options.generateDeprecatedDeclarations()) {
            this.printf("#pragma clang diagnostic push\n", new Object[0]);
            this.printf("#pragma GCC diagnostic ignored \"-Wdeprecated-declarations\"\n", new Object[0]);
        }
    }

    protected void popIgnoreDeprecatedDeclarationsPragma() {
        if (Options.generateDeprecatedDeclarations()) {
            this.printf("#pragma clang diagnostic pop\n", new Object[0]);
        }
    }
}

