/*
 * Decompiled with CFR 0.152.
 */
package fr.wseduc.cron;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.quartz.CronExpression;

public class CronTrigger
implements Handler<Long>,
Serializable {
    private final transient Vertx vertx;
    private final CronExpression expression;
    private transient Handler<Long> handler;
    private long timerId;

    public CronTrigger(Vertx vertx, String cronExpression) throws ParseException {
        this.vertx = vertx;
        this.expression = new CronExpression(cronExpression);
    }

    public CronTrigger schedule(Handler<Long> handler) throws ParseException {
        if (handler == null) {
            throw new IllegalArgumentException("Handler is null.");
        }
        this.handler = handler;
        long delay = this.getDelay(this.expression);
        this.timerId = this.vertx.setTimer(delay, (Handler)this);
        return this;
    }

    private long getDelay(CronExpression expression) {
        Date now = new Date();
        Date next = expression.getNextValidTimeAfter(now);
        return next.getTime() - now.getTime();
    }

    public void handle(Long timerId) {
        long delay = this.getDelay(this.expression);
        timerId = this.vertx.setTimer(delay, (Handler)this);
        this.handler.handle((Object)timerId);
    }

    public void cancel() {
        this.vertx.cancelTimer(this.timerId);
    }
}

