/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.template.formatter.DirectivesStack;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractDocumentFormatter
implements IDocumentFormatter {
    public static final String NO_ESCAPE = "___NoEscape";
    private String startDocumentDirective;
    private String endDocumentDirective;

    public String extractItemNameList(String content, String fieldName, boolean forceAsField) {
        if (!forceAsField && !this.isModelField(content, fieldName)) {
            return null;
        }
        int dotIndex = fieldName.indexOf(46);
        if (dotIndex != -1) {
            return this.getItemToken() + fieldName.substring(0, dotIndex);
        }
        return this.getItemToken() + fieldName;
    }

    public String getStartDocumentDirective() {
        return this.startDocumentDirective;
    }

    public void setStartDocumentDirective(String startDocumentDirective) {
        this.startDocumentDirective = startDocumentDirective;
    }

    public String getEndDocumentDirective() {
        return this.endDocumentDirective;
    }

    public void setEndDocumentDirective(String endDocumentDirective) {
        this.endDocumentDirective = endDocumentDirective;
    }

    public String getStartLoopDirective(String itemNameList) {
        return this.getStartLoopDirective(itemNameList, itemNameList.substring(this.getItemToken().length()));
    }

    public int extractListDirectiveInfo(String content, DirectivesStack directives) {
        return this.extractListDirectiveInfo(content, directives, false);
    }

    protected abstract String getItemToken();

    protected abstract boolean isModelField(String var1, String var2);

    protected DirectiveToParse getDirectiveToParse(int startLoopIndex, int endLoopIndex, int startIfIndex, int endIfIndex) {
        int minIndex = this.getMinIndex(startLoopIndex, endLoopIndex, startIfIndex, endIfIndex);
        if (minIndex == -1) {
            return null;
        }
        if (minIndex == startLoopIndex) {
            return DirectiveToParse.START_LOOP;
        }
        if (minIndex == endLoopIndex) {
            return DirectiveToParse.END_LOOP;
        }
        if (minIndex == startIfIndex) {
            return DirectiveToParse.START_IF;
        }
        if (minIndex == endIfIndex) {
            return DirectiveToParse.END_IF;
        }
        return null;
    }

    public int getMinIndex(int startLoopIndex, int endLoopIndex, int startIfIndex, int endIfIndex) {
        ArrayList<Integer> coll = new ArrayList<Integer>();
        if (startLoopIndex != -1) {
            coll.add(startLoopIndex);
        }
        if (endLoopIndex != -1) {
            coll.add(endLoopIndex);
        }
        if (startIfIndex != -1) {
            coll.add(startIfIndex);
        }
        if (endIfIndex != -1) {
            coll.add(endIfIndex);
        }
        if (coll.size() == 0) {
            return -1;
        }
        if (coll.size() == 1) {
            return (Integer)coll.get(0);
        }
        return (Integer)Collections.min(coll);
    }

    protected String getVariableName(long variableIndex) {
        StringBuilder key = new StringBuilder(NO_ESCAPE);
        key.append(variableIndex);
        return key.toString();
    }

    public String formatAsSimpleField(boolean encloseInDirective, String ... fields) {
        return this.formatAsSimpleField(false, encloseInDirective, fields);
    }

    public String getFunctionDirective(boolean encloseInDirective, String key, String methodName, String ... parameters) {
        return this.getFunctionDirective(false, encloseInDirective, key, methodName, parameters);
    }

    public String getFunctionDirective(String key, String methodName, String ... parameters) {
        return this.getFunctionDirective(true, key, methodName, parameters);
    }

    public String getSetDirective(String name, String value) {
        return this.getSetDirective(name, value, true);
    }

    public String getStartIfDirective(String fieldName) {
        return this.getStartIfDirective(fieldName, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DirectiveToParse {
        START_LOOP,
        END_LOOP,
        START_IF,
        END_IF;

    }
}

