/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.pptx.preprocessor;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.pptx.preprocessor.ARBufferedRegion;
import fr.opensagres.xdocreport.document.pptx.preprocessor.PPTXSlideDocument;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APBufferedRegion
extends BufferedElement {
    private final PPTXSlideDocument document;
    private final List<ARBufferedRegion> arBufferedRegions;
    private Integer level;
    private String itemNameList;
    private List<String> ignoreStartLoopDirective;

    public APBufferedRegion(PPTXSlideDocument document, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.document = document;
        this.arBufferedRegions = new ArrayList<ARBufferedRegion>();
        this.ignoreStartLoopDirective = null;
    }

    public void addRegion(ISavable region) {
        if (region instanceof ARBufferedRegion) {
            this.arBufferedRegions.add((ARBufferedRegion)region);
        } else {
            super.addRegion(region);
        }
    }

    public void process() {
        ArrayList<BufferedElement> toRemove = new ArrayList<BufferedElement>();
        int size = this.arBufferedRegions.size();
        String s = null;
        StringBuilder fullContent = new StringBuilder();
        ARBufferedRegion currentAR = null;
        ARBufferedRegion lastAR = null;
        boolean hasField = false;
        boolean fieldParsing = false;
        for (int i = 0; i < size; ++i) {
            currentAR = this.arBufferedRegions.get(i);
            s = currentAR.getTContent();
            boolean bl = hasField = s != null && s.indexOf("$") != -1;
            if (fieldParsing) {
                boolean bl2 = fieldParsing = s == null || s.length() == 0 || Character.isWhitespace(s.charAt(0));
                if (!fieldParsing) {
                    if (hasField) {
                        this.update(toRemove, fullContent, lastAR);
                        fieldParsing = true;
                        fullContent.append(s);
                        toRemove.add(currentAR);
                    } else {
                        fullContent.append(s);
                        this.update(toRemove, fullContent, currentAR);
                    }
                } else {
                    fullContent.append(s);
                    toRemove.add(currentAR);
                }
            } else if (hasField) {
                fieldParsing = true;
                fullContent.append(s);
                toRemove.add(currentAR);
            }
            lastAR = currentAR;
        }
        this.update(toRemove, fullContent, lastAR);
        super.removeAll(toRemove);
    }

    private void update(Collection<BufferedElement> toRemove, StringBuilder fullContent, ARBufferedRegion lastAR) {
        if (fullContent.length() > 0) {
            String content = fullContent.toString();
            String itemNameList = this.getItemNameList(content);
            lastAR.setTContent(itemNameList != null ? itemNameList : content);
            fullContent.setLength(0);
            toRemove.remove((Object)lastAR);
        }
    }

    private String getItemNameList(String content) {
        IDocumentFormatter formatter = this.document.getFormatter();
        FieldsMetadata fieldsMetadata = this.document.getFieldsMetadata();
        if (formatter != null && fieldsMetadata != null) {
            Collection fieldsAsList = fieldsMetadata.getFieldsAsList();
            for (String fieldName : fieldsAsList) {
                if (!content.contains(fieldName)) continue;
                this.itemNameList = formatter.extractItemNameList(content, fieldName, true);
                if (!StringUtils.isNotEmpty((String)this.itemNameList)) continue;
                if (!this.isIgnoreStartLoopDirective(this.itemNameList)) {
                    this.setStartLoopDirective(formatter.getStartLoopDirective(this.itemNameList));
                    this.addIgnoreStartLoopDirective(this.itemNameList);
                }
                return formatter.formatAsFieldItemList(content, fieldName, true);
            }
        }
        return null;
    }

    public void setEndLoopDirective(String itemNameList) {
        IDocumentFormatter formatter = this.document.getFormatter();
        this.endTagElement.setAfter(formatter.getEndLoopDirective(itemNameList));
    }

    private void setStartLoopDirective(String startLoopDirective) {
        this.startTagElement.setBefore(startLoopDirective);
    }

    public String getItemNameList() {
        return this.itemNameList;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void addIgnoreStartLoopDirective(String itemNameList) {
        if (this.ignoreStartLoopDirective == null) {
            this.ignoreStartLoopDirective = new ArrayList<String>();
        }
        this.ignoreStartLoopDirective.add(itemNameList);
    }

    public boolean isIgnoreStartLoopDirective(String itemNameList) {
        if (this.ignoreStartLoopDirective == null) {
            return false;
        }
        return this.ignoreStartLoopDirective.contains(itemNameList);
    }
}

