/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.pptx.preprocessor.txbody;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.pptx.preprocessor.APBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class TxBodyBufferedRegion
extends BufferedElement {
    private List<APBufferedRegion> apBufferedRegions = new ArrayList<APBufferedRegion>();
    private List<String> ignoreEndLoopDirective;

    public TxBodyBufferedRegion(BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
    }

    public void addRegion(ISavable region) {
        if (region instanceof APBufferedRegion) {
            this.apBufferedRegions.add((APBufferedRegion)region);
        } else {
            super.addRegion(region);
        }
    }

    public void process() {
        APBufferedRegion p = null;
        String itemNameList = null;
        int size = this.apBufferedRegions.size();
        Integer level = null;
        for (int i = 0; i < size; ++i) {
            p = this.apBufferedRegions.get(i);
            p.process();
            itemNameList = p.getItemNameList();
            if (!StringUtils.isNotEmpty((String)itemNameList)) continue;
            level = p.getLevel();
            APBufferedRegion nextP = null;
            if (i < size) {
                nextP = this.getNextPInferiorToLevel(i + 1, level);
            }
            if (nextP != null) {
                nextP.addIgnoreStartLoopDirective(itemNameList);
                if (this.isIgnoreEndLoopDirective(itemNameList)) continue;
                nextP.setEndLoopDirective(itemNameList);
                this.addIgnoreEndLoopDirective(itemNameList);
                continue;
            }
            if (this.isIgnoreEndLoopDirective(itemNameList)) continue;
            p.setEndLoopDirective(itemNameList);
            this.addIgnoreEndLoopDirective(itemNameList);
        }
    }

    private APBufferedRegion getNextPInferiorToLevel(int start, Integer level) {
        APBufferedRegion p = null;
        APBufferedRegion lastP = null;
        for (int i = start; i < this.apBufferedRegions.size(); ++i) {
            p = this.apBufferedRegions.get(i);
            if (p.getLevel() == null) {
                return lastP;
            }
            if (level != null && p.getLevel() >= level) {
                return lastP;
            }
            lastP = p;
        }
        return lastP;
    }

    public void addIgnoreEndLoopDirective(String itemNameList) {
        if (this.ignoreEndLoopDirective == null) {
            this.ignoreEndLoopDirective = new ArrayList<String>();
        }
        this.ignoreEndLoopDirective.add(itemNameList);
    }

    public boolean isIgnoreEndLoopDirective(String itemNameList) {
        if (this.ignoreEndLoopDirective == null) {
            return false;
        }
        return this.ignoreEndLoopDirective.contains(itemNameList);
    }
}

