/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.pptx;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.pptx.PPTXConstants;
import fr.opensagres.xdocreport.document.pptx.images.PPTXImageRegistry;
import fr.opensagres.xdocreport.document.pptx.preprocessor.PPTXSlidePreprocessor;

public class PPTXReport
extends AbstractXDocReport {
    private static final String PPT_REGEXP = "ppt*";
    private static final long serialVersionUID = -8323654563409226895L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"ppt/presentation.xml", "ppt/slides/slide*.xml"};

    public String getKind() {
        return DocumentKind.PPTX.name();
    }

    protected void registerPreprocessors() {
        super.addPreprocessor("ppt/slides/slide*.xml", PPTXSlidePreprocessor.INSTANCE);
    }

    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    public MimeMapping getMimeMapping() {
        return PPTXConstants.MIME_MAPPING;
    }

    public static boolean isPPTX(XDocArchive documentArchive) {
        if (!documentArchive.hasEntry("[Content_Types].xml")) {
            return false;
        }
        return documentArchive.getEntryNames(PPT_REGEXP).size() > 0;
    }

    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new PPTXImageRegistry(readerProvider, writerProvider, outputStreamProvider, this.getFieldsMetadata());
    }
}

