/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.util.Objects;

public final class RelativeHoliday
implements Holiday {
    private final Holiday base;
    private final int plusDays;

    public RelativeHoliday(Holiday base, int plusDays) {
        this.base = Objects.requireNonNull(base);
        this.plusDays = plusDays;
    }

    @Override
    public boolean check(LocalDate date) {
        return this.base.check(date.minusDays(this.plusDays));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeHoliday that = (RelativeHoliday)o;
        return this.plusDays == that.plusDays && this.base.equals(that.base);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.plusDays);
    }

    public String toString() {
        return "RelativeHoliday{base=" + this.base + ", plusDays=" + this.plusDays + '}';
    }
}

