/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import fr.marcwrobel.jbanking.calendar.MonthDayHoliday;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class MovedHoliday
implements Holiday {
    private final Holiday base;
    private final Map<LocalDate, LocalDate> replacements;
    private final Map<LocalDate, LocalDate> invertedReplacements;

    public MovedHoliday(Holiday base, LocalDate ... replacements) {
        this.base = Objects.requireNonNull(base);
        this.replacements = new HashMap<LocalDate, LocalDate>(0);
        this.invertedReplacements = new HashMap<LocalDate, LocalDate>(0);
        for (int i = 0; i < replacements.length / 2; ++i) {
            LocalDate from = replacements[i * 2];
            LocalDate to = replacements[i * 2 + 1];
            if (from.equals(to)) continue;
            this.replacements.put(from, to);
            this.invertedReplacements.put(to, from);
        }
    }

    public MovedHoliday(MonthDay base, MonthDay replacement, int ... replacedYears) {
        this.base = new MonthDayHoliday(base);
        this.replacements = new HashMap<LocalDate, LocalDate>(0);
        this.invertedReplacements = new HashMap<LocalDate, LocalDate>(0);
        for (int year : replacedYears) {
            LocalDate to;
            LocalDate from = base.atYear(year);
            if (from.equals(to = replacement.atYear(year))) continue;
            this.replacements.put(from, to);
            this.invertedReplacements.put(to, from);
        }
    }

    @Override
    public boolean check(LocalDate date) {
        if (this.replacements.containsKey(date)) {
            return false;
        }
        return this.base.check(this.invertedReplacements.getOrDefault(date, date));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MovedHoliday that = (MovedHoliday)o;
        return this.base.equals(that.base) && this.replacements.equals(that.replacements);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.replacements);
    }

    public String toString() {
        return "MovedHoliday{base=" + this.base + ", replacements=" + this.replacements + '}';
    }
}

