/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class FixedHoliday
implements Holiday {
    private final Set<LocalDate> dates;

    public FixedHoliday(Collection<LocalDate> dates) {
        this.dates = new HashSet<LocalDate>(dates);
    }

    public FixedHoliday(LocalDate ... dates) {
        this(Arrays.asList(dates));
    }

    @Override
    public boolean check(LocalDate date) {
        return this.dates.contains(Objects.requireNonNull(date));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedHoliday that = (FixedHoliday)o;
        return this.dates.equals(that.dates);
    }

    public int hashCode() {
        return Objects.hash(this.dates);
    }

    public String toString() {
        return "FixedHoliday{dates=" + this.dates + '}';
    }
}

