/*
 * Decompiled with CFR 0.152.
 */
package fr.lixbox.orm.entity.validator.constraint;

import fr.lixbox.common.exceptions.BusinessException;
import fr.lixbox.common.model.ConteneurEvenement;
import fr.lixbox.common.model.Evenement;
import fr.lixbox.orm.entity.model.ValidatedDao;
import fr.lixbox.orm.entity.validator.constraint.Validate;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidateValidator
implements ConstraintValidator<Validate, Object> {
    public void initialize(Validate arg0) {
    }

    public boolean isValid(Object value, ConstraintValidatorContext ctx) {
        ConteneurEvenement conteneur;
        ctx.disableDefaultConstraintViolation();
        if (value instanceof Iterable) {
            conteneur = new ConteneurEvenement();
            for (Object item : (Iterable)value) {
                conteneur.addAll(this.validateObject((ValidatedDao)item));
            }
        } else {
            conteneur = this.validateObject((ValidatedDao)value);
        }
        if (conteneur.getSize() > 0L) {
            for (Evenement event : conteneur.getEvenements()) {
                ctx.buildConstraintViolationWithTemplate(event.getLibelle()).addConstraintViolation();
            }
        }
        return conteneur.getSize() == 0L;
    }

    protected ConteneurEvenement validateObject(ValidatedDao value) {
        ConteneurEvenement conteneur;
        try {
            conteneur = value != null ? value.validate() : new ConteneurEvenement();
        }
        catch (BusinessException be) {
            conteneur = be.getConteneur();
        }
        return conteneur;
    }
}

