/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.configuration;

import fr.inria.gforge.spoon.SpoonModel;
import fr.inria.gforge.spoon.SpoonMojoGenerate;
import fr.inria.gforge.spoon.configuration.AbstractSpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.util.LogWrapper;
import fr.inria.gforge.spoon.util.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class XMLSpoonConfiguration
extends AbstractSpoonConfigurationBuilder {
    private SpoonModel model;

    public XMLSpoonConfiguration(SpoonMojoGenerate spoon, ReportBuilder reportBuilder, SpoonModel model) {
        super(spoon, reportBuilder);
        this.model = model;
    }

    @Override
    public SpoonConfigurationBuilder addProcessors() {
        if (this.model != null && this.model.getProcessors() != null && !this.model.getProcessors().isEmpty()) {
            String[] processors = this.model.getProcessors().toArray(new String[this.model.getProcessors().size()]);
            this.parameters.add("-p");
            this.parameters.add(this.buildProcessors(processors));
            this.reportBuilder.setProcessors(processors);
        }
        return this;
    }

    private String buildProcessors(String[] processors) {
        return this.implode(processors, File.pathSeparator);
    }

    @Override
    public SpoonConfigurationBuilder addTemplates() {
        if (this.model != null && this.model.getTemplates() != null && !this.model.getTemplates().isEmpty()) {
            this.parameters.add("-t");
            this.parameters.add(this.buildTemplates());
        }
        return this;
    }

    private String buildTemplates() {
        String[] templateString = new String[this.model.getTemplates().size()];
        for (int i = 0; i < this.model.getTemplates().size(); ++i) {
            String templateLoaded = this.loadTemplateFile(this.model.getTemplates().get(i));
            if (templateLoaded == null) continue;
            templateString[i] = templateLoaded;
        }
        return this.implode(templateString, File.pathSeparator);
    }

    private String loadTemplateFile(String templateName) {
        String name = templateName.replace('.', '/') + ".java";
        InputStream in = SpoonMojoGenerate.class.getClassLoader().getResourceAsStream(name);
        String packageName = templateName.substring(0, templateName.lastIndexOf(46));
        String fileName = templateName.substring(templateName.lastIndexOf(46) + 1) + ".java";
        try {
            return TemplateLoader.loadToTmpFolder(in, packageName, fileName).getAbsolutePath();
        }
        catch (IOException e) {
            LogWrapper.warn(this.spoon, String.format("Template %s cannot be loaded.", templateName), e);
            return null;
        }
    }
}

