/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.configuration;

import fr.inria.gforge.spoon.SpoonMojoGenerate;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.SpoonMavenPluginException;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.util.LogWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

abstract class AbstractSpoonConfigurationBuilder
implements SpoonConfigurationBuilder {
    protected final List<String> parameters = new LinkedList<String>();
    protected final SpoonMojoGenerate spoon;
    protected final ReportBuilder reportBuilder;

    protected AbstractSpoonConfigurationBuilder(SpoonMojoGenerate spoon, ReportBuilder reportBuilder) {
        this.spoon = spoon;
        this.reportBuilder = reportBuilder;
        if (this.spoon.getLog().isDebugEnabled()) {
            this.parameters.add("--level");
            this.parameters.add("DEBUG");
        } else if (this.spoon.getLog().isInfoEnabled()) {
            this.parameters.add("--level");
            this.parameters.add("INFO");
        }
    }

    @Override
    public SpoonConfigurationBuilder addInputFolder() throws SpoonMavenPluginException {
        ArrayList<File> srcDir = new ArrayList<File>();
        if (this.spoon.isIncludeSrcDirectories()) {
            srcDir.add(new File(this.spoon.getProject().getBuild().getSourceDirectory()));
            if (!this.spoon.getSkipGeneratedSources()) {
                for (String s : this.spoon.getProject().getCompileSourceRoots()) {
                    srcDir.add(new File(s));
                }
            }
        }
        if (this.spoon.isIncludeTestDirectories()) {
            srcDir.add(new File(this.spoon.getProject().getBuild().getTestSourceDirectory()));
            if (!this.spoon.getSkipGeneratedSources()) {
                for (String s : this.spoon.getProject().getTestCompileSourceRoots()) {
                    srcDir.add(new File(s));
                }
            }
        }
        srcDir.removeIf(file -> !file.exists());
        if (srcDir.isEmpty()) {
            throw new SpoonMavenPluginException(String.format("No source directory for %s project.", this.spoon.getProject().getName()));
        }
        String inputs = srcDir.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        this.parameters.add("-i");
        this.parameters.add(inputs);
        this.reportBuilder.setInput(inputs);
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addOutputFolder() {
        if (!this.spoon.getOutFolder().exists()) {
            this.spoon.getOutFolder().mkdirs();
        }
        this.parameters.add("-o");
        this.parameters.add(this.spoon.getOutFolder().getAbsolutePath());
        if (!this.spoon.isCompileOriginalSources()) {
            this.spoon.getProject().getCompileSourceRoots().clear();
            this.spoon.getProject().addCompileSourceRoot(this.spoon.getOutFolder().getAbsolutePath());
        }
        this.reportBuilder.setOutput(this.spoon.getOutFolder().getAbsolutePath());
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addEnableComments() {
        if (!this.spoon.isEnableComments()) {
            this.parameters.add("--disable-comments");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addCompliance() {
        this.parameters.add("--compliance");
        this.parameters.add("" + this.spoon.getCompliance());
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addSourceClasspath() throws SpoonMavenPluginException {
        int i;
        List testClasspath;
        List compileClasspath;
        MavenProject project = this.spoon.getProject();
        try {
            compileClasspath = project.getCompileClasspathElements();
            testClasspath = project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new SpoonMavenPluginException("Cannot get compile classpath elements.", e);
        }
        StringBuilder classpath = new StringBuilder();
        if (compileClasspath.size() > 1) {
            for (i = 1; i < compileClasspath.size(); ++i) {
                classpath.append((String)compileClasspath.get(i)).append(File.pathSeparatorChar);
            }
        }
        if (testClasspath.size() > 2) {
            for (i = 2; i < testClasspath.size(); ++i) {
                classpath.append((String)testClasspath.get(i)).append(File.pathSeparatorChar);
            }
        }
        if (classpath.length() != 0) {
            LogWrapper.debug(this.spoon, String.format("Source classpath: %s", classpath.toString()));
            this.parameters.add("--source-classpath");
            this.parameters.add(classpath.toString());
            this.reportBuilder.setSourceClasspath(classpath.toString());
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addNoClasspath() {
        if (this.spoon.isNoClasspath()) {
            this.parameters.add("--cpmode");
            this.parameters.add("NOCLASSPATH");
        } else {
            this.parameters.add("--cpmode");
            this.parameters.add("FULLCLASSPATH");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addWithImports() {
        if (this.spoon.isWithImports()) {
            this.parameters.add("--with-imports");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addBuildOnlyOutdatedFiles() {
        if (this.spoon.isBuildOnlyOutdatedFiles()) {
            this.parameters.add("--buildOnlyOutdatedFiles");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addNoCopyResources() {
        if (this.spoon.isNoCopyResources()) {
            this.parameters.add("--no-copy-resources");
        }
        return this;
    }

    @Override
    public SpoonConfigurationBuilder addOutputType() {
        this.parameters.add("--output-type");
        this.parameters.add(this.spoon.getOutputType());
        return this;
    }

    @Override
    public String[] build() {
        LogWrapper.info(this.spoon, "Running spoon with parameters:");
        LogWrapper.info(this.spoon, this.parameters.toString());
        return this.parameters.toArray(new String[this.parameters.size()]);
    }

    protected String implode(String[] tabToConcatenate, String pathSeparator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tabToConcatenate.length; ++i) {
            builder.append(tabToConcatenate[i]);
            if (i >= tabToConcatenate.length - 1) continue;
            builder.append(pathSeparator);
        }
        return builder.toString();
    }
}

