/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon;

import fr.inria.gforge.spoon.ProcessorProperties;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationFactory;
import fr.inria.gforge.spoon.configuration.SpoonMavenPluginException;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.logging.ReportFactory;
import fr.inria.gforge.spoon.metrics.PerformanceDecorator;
import fr.inria.gforge.spoon.util.LogWrapper;
import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import spoon.Launcher;
import spoon.compiler.Environment;
import spoon.processing.ProcessorPropertiesImpl;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class SpoonMojoGenerate
extends AbstractMojo {
    @Parameter(property="enableComments", defaultValue="true")
    private boolean enableComments;
    @Parameter(property="folder.out", defaultValue="${project.build.directory}/generated-sources/spoon")
    private File outFolder;
    @Parameter(property="noClasspath", defaultValue="false")
    private boolean noClasspath;
    @Parameter(property="withImports", defaultValue="false")
    private boolean withImports;
    @Parameter(property="buildOnlyOutdatedFiles", defaultValue="false")
    private boolean buildOnlyOutdatedFiles;
    @Parameter(property="noCopyResources", defaultValue="false")
    private boolean noCopyResources;
    @Parameter(property="processors")
    private String[] processors;
    @Parameter(property="Debug mode", defaultValue="false")
    private boolean debug;
    @Parameter(property="Compile original sources and not source spooned", defaultValue="false")
    private boolean compileOriginalSources;
    @Parameter(property="Java version for spoon", defaultValue="8")
    private int compliance;
    @Parameter(property="Output type", defaultValue="classes")
    private String outputType;
    @Parameter(property="Skip the generated sources as source input for Spoon", defaultValue="false")
    private boolean skipGeneratedSources;
    @Parameter(property="Prevent the build from crashing in case of Spoon error: a warning will only be triggered", defaultValue="false")
    private boolean skipSpoonErrors;
    @Parameter
    private ProcessorProperties[] processorProperties;
    @Parameter(property="Include test directories as input. Test directories are resolved by maven.", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="Include source directories as input. Source directories are resolved by maven.", defaultValue="true")
    private boolean includeSource;
    @Parameter(property="spoon.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    protected ReportBuilder reportBuilder;
    protected Launcher spoonLauncher;

    protected String[] buildArguments(SpoonConfigurationBuilder spoonConfigurationBuilder) throws SpoonMavenPluginException {
        spoonConfigurationBuilder.addInputFolder().addOutputFolder().addCompliance().addNoClasspath().addWithImports().addBuildOnlyOutdatedFiles().addNoCopyResources().addSourceClasspath().addEnableComments().addProcessors().addTemplates().addOutputType();
        return spoonConfigurationBuilder.build();
    }

    protected void initMojo() throws Exception {
        try {
            this.reportBuilder = ReportFactory.newReportBuilder(this);
        }
        catch (RuntimeException e) {
            LogWrapper.warn(this, e.getMessage(), e);
            return;
        }
        SpoonConfigurationBuilder spoonBuilder = SpoonConfigurationFactory.getConfig(this, this.reportBuilder);
        this.reportBuilder.setProjectName(this.project.getName());
        this.reportBuilder.setModuleName(this.project.getName());
        this.spoonLauncher = new Launcher();
        this.spoonLauncher.setArgs(this.buildArguments(spoonBuilder));
        if (this.processorProperties != null) {
            this.initSpoonProperties(this.spoonLauncher);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.project.getPackaging().equals("pom")) {
            return;
        }
        try {
            this.initMojo();
            PerformanceDecorator performance = new PerformanceDecorator(this.reportBuilder, this.spoonLauncher);
            performance.execute();
            this.reportBuilder.buildReport();
        }
        catch (SpoonMavenPluginException e) {
            if (this.getSkipSpoonErrors()) {
                LogWrapper.warn(this, e.getMessage() + "\n This project will be ignored.", e);
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            LogWrapper.error(this, e.getMessage(), e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void initSpoonProperties(Launcher launcher) throws MojoExecutionException {
        Environment environment = launcher.getEnvironment();
        for (ProcessorProperties processorProperties : this.getProcessorProperties()) {
            ProcessorPropertiesImpl properties = new ProcessorPropertiesImpl();
            Properties xmlProperties = processorProperties.getProperties();
            for (Object key : xmlProperties.keySet()) {
                String sKey = (String)key;
                String value = (String)xmlProperties.get(key);
                properties.set(sKey, (Object)value);
            }
            environment.setProcessorProperties(processorProperties.getName(), (spoon.processing.ProcessorProperties)properties);
        }
    }

    public File getOutFolder() {
        return this.outFolder;
    }

    public boolean isNoClasspath() {
        return this.noClasspath;
    }

    public boolean isWithImports() {
        return this.withImports;
    }

    public boolean isBuildOnlyOutdatedFiles() {
        return this.buildOnlyOutdatedFiles;
    }

    public boolean isNoCopyResources() {
        return this.noCopyResources;
    }

    public String[] getProcessorsPath() {
        return this.processors;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isCompileOriginalSources() {
        return this.compileOriginalSources;
    }

    public int getCompliance() {
        return this.compliance;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setEnableComments(boolean enableComments) {
        this.enableComments = enableComments;
    }

    public boolean isEnableComments() {
        return this.enableComments;
    }

    public ProcessorProperties[] getProcessorProperties() {
        return this.processorProperties;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public boolean getSkipGeneratedSources() {
        return this.skipGeneratedSources;
    }

    public boolean isIncludeSrcDirectories() {
        return this.includeSource;
    }

    public boolean isIncludeTestDirectories() {
        return this.includeTest;
    }

    public boolean getSkipSpoonErrors() {
        return this.skipSpoonErrors;
    }
}

