/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public final class TemplateLoader {
    private static File tmpFolder;

    private TemplateLoader() {
    }

    private static File getTmpFolder() {
        if (tmpFolder == null) {
            try {
                tmpFolder = Files.createTempDirectory("Spoon", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tmpFolder;
    }

    public static File loadToTmpFolder(InputStream in, String packageName, String fileName) throws IOException {
        File tmpFolder = TemplateLoader.getTmpFolder();
        String[] packageData = packageName.split("\\.");
        File f = tmpFolder;
        for (String p : packageData) {
            if ((f = new File(f, p)).exists()) continue;
            f.mkdir();
        }
        File javaFile = new File(f, fileName);
        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(javaFile));
        return javaFile;
    }
}

