/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.gforge.spoon;

import fr.inria.gforge.spoon.configuration.SpoonConfigurationBuilder;
import fr.inria.gforge.spoon.configuration.SpoonConfigurationFactory;
import fr.inria.gforge.spoon.logging.ReportBuilder;
import fr.inria.gforge.spoon.logging.ReportFactory;
import fr.inria.gforge.spoon.metrics.PerformanceDecorator;
import fr.inria.gforge.spoon.util.ClasspathHacker;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import spoon.Launcher;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class Spoon
extends AbstractMojo {
    @Parameter(property="folder.src")
    private File srcFolder;
    @Parameter(property="folder.out", defaultValue="${project.build.directory}/generated-sources/spoon")
    private File outFolder;
    @Parameter(property="formatting.preserve", defaultValue="false")
    private boolean preserveFormatting;
    @Parameter(property="processors")
    private String[] processors;
    @Parameter(property="jar.files")
    private String[] jarFiles;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            URL[] urlClassLoader;
            String resultFilename = this.project.getBuild().getDirectory() + File.separator + "spoon-maven-plugin" + File.separator + "result-spoon.xml";
            File resultFile = new File(resultFilename);
            if (resultFile.exists()) {
                this.getLog().warn((CharSequence)"Project already spooned.");
                return;
            }
            ReportBuilder reportBuilder = ReportFactory.newReportBuilder(this);
            SpoonConfigurationBuilder spoonBuilder = SpoonConfigurationFactory.getConfig(this, reportBuilder);
            reportBuilder.setProjectName(this.project.getName());
            reportBuilder.setModuleName(this.project.getName());
            try {
                spoonBuilder.addInputFolder().addOutputFolder().addCompliance().addPreserveFormatting().addSourceClasspath().addProcessors().addTemplates();
            }
            catch (RuntimeException e) {
                this.getLog().warn((CharSequence)e.getMessage());
                return;
            }
            for (String jarFile : this.jarFiles) {
                ClasspathHacker.addFile(jarFile);
            }
            if (this.project.getArtifacts() == null || this.project.getArtifacts().isEmpty()) {
                this.getLog().info((CharSequence)"There is not artifact in this project");
            } else {
                for (Artifact artifact : this.project.getArtifacts()) {
                    this.getLog().info((CharSequence)("Add dependency to classpath : " + artifact));
                    this.getLog().info((CharSequence)("Add file to classpath : " + artifact.getFile()));
                    ClasspathHacker.addFile(artifact.getFile());
                }
            }
            this.getLog().info((CharSequence)"Running spoon with classpath : ");
            for (URL currentURL : urlClassLoader = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()) {
                this.getLog().info((CharSequence)("" + currentURL));
            }
            Launcher spoonLauncher = new Launcher();
            spoonLauncher.setArgs(spoonBuilder.build());
            PerformanceDecorator performance = new PerformanceDecorator(reportBuilder, spoonLauncher);
            performance.execute();
            reportBuilder.buildReport();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File getOutFolder() {
        return this.outFolder;
    }

    public boolean isPreserveFormatting() {
        return this.preserveFormatting;
    }

    public String[] getProcessorsPath() {
        return this.processors;
    }

    public MavenProject getProject() {
        return this.project;
    }
}

