/*
 * Decompiled with CFR 0.152.
 */
package fr.hmil.roshttp.response;

import fr.hmil.roshttp.BackendConfig;
import fr.hmil.roshttp.exceptions.ResponseException;
import fr.hmil.roshttp.response.HttpResponseFactory;
import fr.hmil.roshttp.response.HttpResponseHeader;
import fr.hmil.roshttp.response.SimpleHttpResponse;
import fr.hmil.roshttp.util.Utils$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class SimpleHttpResponse$
implements HttpResponseFactory<SimpleHttpResponse> {
    public static SimpleHttpResponse$ MODULE$;

    static {
        new SimpleHttpResponse$();
    }

    @Override
    public Future<SimpleHttpResponse> apply(HttpResponseHeader header, Observable<ByteBuffer> bodyStream, BackendConfig config, Scheduler scheduler) {
        String charset = Utils$.MODULE$.charsetFromContentType((String)header.headers().getOrElse("content-type", (Function0 & Serializable & scala.Serializable)() -> null));
        Queue buffers = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        Promise promise = Promise$.MODULE$.apply();
        CancelableFuture streamCollector = bodyStream.foreach((Function1 & Serializable & scala.Serializable)elem -> {
            buffers.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ByteBuffer[]{elem}));
            return BoxedUnit.UNIT;
        }, scheduler).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            String body = this.recomposeBody((Queue<ByteBuffer>)buffers, config.maxChunkSize(), charset);
            return new SimpleHttpResponse(header.statusCode(), header.headers(), body);
        }, (ExecutionContext)scheduler);
        streamCollector.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SimpleHttpResponse$.$anonfun$apply$4(header, promise, x0$1)), (ExecutionContext)scheduler);
        return promise.future();
    }

    private String recomposeBody(Queue<ByteBuffer> seq, int maxChunkSize, String charset) {
        ByteBuffer buffer = ByteBuffer.allocate(seq.length() * maxChunkSize);
        int totalBytes = BoxesRunTime.unboxToInt((Object)seq.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(count, chunk) -> BoxesRunTime.boxToInteger((int)SimpleHttpResponse$.$anonfun$recomposeBody$1(buffer, BoxesRunTime.unboxToInt((Object)count), chunk))));
        buffer.limit(totalBytes);
        return Utils$.MODULE$.getStringFromBuffer(buffer, charset);
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(HttpResponseHeader header$1, Promise promise$1, Try x0$1) {
        boolean bl;
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            bl = promise$1.trySuccess(success.value());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            bl = promise$1.tryFailure((Throwable)new ResponseException(failure.exception(), header$1));
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$recomposeBody$1(ByteBuffer buffer$1, int count, ByteBuffer chunk) {
        buffer$1.put(chunk);
        return count + chunk.limit();
    }

    private SimpleHttpResponse$() {
        MODULE$ = this;
    }
}

