/*
 * Decompiled with CFR 0.152.
 */
package fr.hmil.roshttp;

import fr.hmil.roshttp.ByteBufferChopper$;
import fr.hmil.roshttp.ByteBufferQueue;
import fr.hmil.roshttp.Converters$;
import fr.hmil.roshttp.DriverTrait;
import fr.hmil.roshttp.HttpRequest;
import fr.hmil.roshttp.Protocol;
import fr.hmil.roshttp.Protocol$;
import fr.hmil.roshttp.exceptions.HttpException$;
import fr.hmil.roshttp.exceptions.RequestException;
import fr.hmil.roshttp.exceptions.UploadStreamException;
import fr.hmil.roshttp.node.Modules$;
import fr.hmil.roshttp.node.buffer.Buffer;
import fr.hmil.roshttp.node.http.Agent;
import fr.hmil.roshttp.node.http.ClientRequest;
import fr.hmil.roshttp.node.http.Http;
import fr.hmil.roshttp.node.http.IncomingMessage;
import fr.hmil.roshttp.node.http.RequestOptions$;
import fr.hmil.roshttp.response.HttpResponse;
import fr.hmil.roshttp.response.HttpResponseFactory;
import fr.hmil.roshttp.response.HttpResponseHeader;
import fr.hmil.roshttp.util.HeaderMap$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import monix.execution.Ack;
import monix.execution.Scheduler;
import monix.reactive.Observer;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Dictionary;
import scala.scalajs.js.Dictionary$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.Function1;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.JavaScriptException;
import scala.scalajs.js.UndefOr;
import scala.scalajs.js.UndefOr$;

public final class NodeDriver$
implements DriverTrait {
    public static NodeDriver$ MODULE$;

    static {
        new NodeDriver$();
    }

    public <T extends HttpResponse> void makeRequest(HttpRequest req, HttpResponseFactory<T> factory, Promise<T> p, Scheduler scheduler) {
        Protocol protocol = req.protocol();
        Protocol protocol2 = Protocol$.MODULE$.HTTP();
        Http module = !(protocol != null ? !((Object)protocol).equals(protocol2) : protocol2 != null) ? Modules$.MODULE$.http() : Modules$.MODULE$.https();
        Map headers = req.headers();
        if (!req.backendConfig().allowChunkedRequestBody()) {
            headers = headers.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Transfer-Encoding"), (Object)""));
        }
        UndefOr x$1 = UndefOr$.MODULE$.any2undefOrA((Object)req.host());
        UndefOr x$2 = JSConverters.JSRichOption$.MODULE$.orUndefined$extension(JSConverters$.MODULE$.JSRichOption(req.port()));
        UndefOr x$3 = UndefOr$.MODULE$.any2undefOrA((Object)req.method().toString());
        UndefOr x$4 = UndefOr$.MODULE$.any2undefOrA((Object)Dictionary$.MODULE$.apply(headers.toSeq()));
        UndefOr x$5 = UndefOr$.MODULE$.any2undefOrA((Object)req.longPath());
        UndefOr<String> x$6 = RequestOptions$.MODULE$.apply$default$1();
        UndefOr<String> x$7 = RequestOptions$.MODULE$.apply$default$2();
        UndefOr<Object> x$8 = RequestOptions$.MODULE$.apply$default$4();
        UndefOr<String> x$9 = RequestOptions$.MODULE$.apply$default$6();
        UndefOr<String> x$10 = RequestOptions$.MODULE$.apply$default$7();
        UndefOr<String> x$11 = RequestOptions$.MODULE$.apply$default$11();
        UndefOr<Agent> x$12 = RequestOptions$.MODULE$.apply$default$12();
        ClientRequest nodeRequest = module.request(RequestOptions$.MODULE$.apply(x$6, x$7, (UndefOr<String>)x$1, x$8, (UndefOr<Object>)x$2, x$9, x$10, (UndefOr<String>)x$3, (UndefOr<String>)x$5, (UndefOr<Dictionary<String>>)x$4, x$11, x$12), (Function1<IncomingMessage, BoxedUnit>)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)message -> {
            this.handleResponse(req, factory, p, message, scheduler);
            return BoxedUnit.UNIT;
        }));
        nodeRequest.on("error", new Function1<Dynamic, BoxedUnit>(p){
            private final Promise p$1;

            public final void apply(Dynamic arg1) {
                NodeDriver$.fr$hmil$roshttp$NodeDriver$$$anonfun$makeRequest$2(arg1, this.p$1);
            }
            {
                this.p$1 = p$1;
                super((Seq)Nil$.MODULE$);
            }
        });
        if (req.body().isDefined()) {
            req.body().foreach((scala.Function1 & Serializable & scala.Serializable)part -> part.content().subscribe((Observer)new Observer<ByteBuffer>(p, nodeRequest){
                private final Promise p$1;
                private final ClientRequest nodeRequest$1;

                public void onError(Throwable ex) {
                    this.p$1.tryFailure((Throwable)new UploadStreamException(ex));
                    this.nodeRequest$1.abort();
                }

                public void onComplete() {
                    this.nodeRequest$1.end();
                }

                public Future<Ack> onNext(ByteBuffer elem) {
                    this.nodeRequest$1.write(Converters$.MODULE$.byteBufferToNodeBuffer(elem));
                    return Ack.Continue$.MODULE$;
                }
                {
                    this.p$1 = p$1;
                    this.nodeRequest$1 = nodeRequest$1;
                }
            }, scheduler));
        } else {
            nodeRequest.end();
        }
    }

    public <T extends HttpResponse> void handleResponse(HttpRequest req, HttpResponseFactory<T> factory, Promise<T> p, IncomingMessage message, Scheduler scheduler) {
        BoxedUnit boxedUnit;
        if (message.statusCode() >= 300 && message.statusCode() < 400 && Any$.MODULE$.wrapDictionary(message.headers()).contains("location")) {
            this.makeRequest(req.withURL((String)Any$.MODULE$.wrapDictionary(message.headers()).apply("location")), factory, p, scheduler);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Map headers = Any$.MODULE$.wrapDictionary(message.headers()).toMap(Predef$.MODULE$.$conforms());
            ByteBufferQueue bufferQueue = new ByteBufferQueue(req.backendConfig().internalBufferLength(), new ByteBufferQueue.Feeder(message){
                private final IncomingMessage message$1;

                public void onFlush() {
                    this.message$1.resume();
                }

                public void onFull() {
                    this.message$1.pause();
                }
                {
                    this.message$1 = message$1;
                }
            }, (ExecutionContext)scheduler);
            message.on("data", new Function1<Dynamic, BoxedUnit>(req, bufferQueue){
                private final HttpRequest req$2;
                private final ByteBufferQueue bufferQueue$1;

                public final void apply(Dynamic arg1) {
                    NodeDriver$.MODULE$.fr$hmil$roshttp$NodeDriver$$$anonfun$handleResponse$1(arg1, this.req$2, this.bufferQueue$1);
                }
                {
                    this.req$2 = req$2;
                    this.bufferQueue$1 = bufferQueue$1;
                    super((Seq)Nil$.MODULE$);
                }
            });
            message.on("end", new Function1<Dynamic, BoxedUnit>(bufferQueue){
                private final ByteBufferQueue bufferQueue$1;

                public final void apply(Dynamic arg1) {
                    NodeDriver$.fr$hmil$roshttp$NodeDriver$$$anonfun$handleResponse$3(arg1, this.bufferQueue$1);
                }
                {
                    this.bufferQueue$1 = bufferQueue$1;
                    super((Seq)Nil$.MODULE$);
                }
            });
            message.on("error", new Function1<Dynamic, BoxedUnit>(bufferQueue){
                private final ByteBufferQueue bufferQueue$1;

                public final void apply(Dynamic arg1) {
                    NodeDriver$.fr$hmil$roshttp$NodeDriver$$$anonfun$handleResponse$4(arg1, this.bufferQueue$1);
                }
                {
                    this.bufferQueue$1 = bufferQueue$1;
                    super((Seq)Nil$.MODULE$);
                }
            });
            boxedUnit = p.completeWith(factory.apply(new HttpResponseHeader(message.statusCode(), HeaderMap$.MODULE$.apply((Map<String, String>)headers)), bufferQueue.observable(), req.backendConfig(), scheduler).map((scala.Function1 & Serializable & scala.Serializable)response -> {
                if (message.statusCode() >= 400) {
                    throw HttpException$.MODULE$.badStatus(response);
                }
                return response;
            }, (ExecutionContext)scheduler));
        }
    }

    @Override
    public <T extends HttpResponse> Future<T> send(HttpRequest req, HttpResponseFactory<T> factory, Scheduler scheduler) {
        Promise p = Promise$.MODULE$.apply();
        this.makeRequest(req, factory, p, scheduler);
        return p.future();
    }

    private Seq<ByteBuffer> convertAndChopBuffer(Any nodeBuffer, int maxChunkSize) {
        ByteBuffer buffer = Converters$.MODULE$.nodeBufferToByteBuffer((Buffer)nodeBuffer);
        return ByteBufferChopper$.MODULE$.chop(buffer, maxChunkSize);
    }

    public static final /* synthetic */ void fr$hmil$roshttp$NodeDriver$$$anonfun$makeRequest$2(Dynamic s, Promise p$1) {
        p$1.tryFailure((Throwable)new RequestException(new IOException(s.toString())));
    }

    public final /* synthetic */ void fr$hmil$roshttp$NodeDriver$$$anonfun$handleResponse$1(Dynamic nodeBuffer, HttpRequest req$2, ByteBufferQueue bufferQueue$1) {
        this.convertAndChopBuffer((Any)nodeBuffer, req$2.backendConfig().maxChunkSize()).foreach((scala.Function1 & Serializable & scala.Serializable)buffer -> {
            bufferQueue$1.push(buffer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void fr$hmil$roshttp$NodeDriver$$$anonfun$handleResponse$3(Dynamic s, ByteBufferQueue bufferQueue$1) {
        bufferQueue$1.end();
    }

    public static final /* synthetic */ void fr$hmil$roshttp$NodeDriver$$$anonfun$handleResponse$4(Dynamic s, ByteBufferQueue bufferQueue$1) {
        bufferQueue$1.pushError(new JavaScriptException((Object)s));
    }

    private NodeDriver$() {
        MODULE$ = this;
    }
}

