/*
 * Decompiled with CFR 0.152.
 */
package fr.hmil.roshttp;

import fr.hmil.roshttp.BackendConfig;
import fr.hmil.roshttp.CrossPlatformUtils$;
import fr.hmil.roshttp.HttpDriver$;
import fr.hmil.roshttp.HttpRequest$;
import fr.hmil.roshttp.Method;
import fr.hmil.roshttp.Method$;
import fr.hmil.roshttp.Protocol;
import fr.hmil.roshttp.Protocol$;
import fr.hmil.roshttp.body.BodyPart;
import fr.hmil.roshttp.exceptions.TimeoutException;
import fr.hmil.roshttp.exceptions.TimeoutException$;
import fr.hmil.roshttp.response.HttpResponse;
import fr.hmil.roshttp.response.HttpResponseFactory;
import fr.hmil.roshttp.response.SimpleHttpResponse;
import fr.hmil.roshttp.response.SimpleHttpResponse$;
import fr.hmil.roshttp.response.StreamHttpResponse;
import fr.hmil.roshttp.response.StreamHttpResponse$;
import fr.hmil.roshttp.util.HeaderMap;
import fr.hmil.roshttp.util.HeaderMap$;
import fr.hmil.roshttp.util.Utils$;
import java.io.Serializable;
import java.net.URI;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u0005%\u00111\u0002\u0013;uaJ+\u0017/^3ti*\u00111\u0001B\u0001\be>\u001c\b\u000e\u001e;q\u0015\t)a!\u0001\u0003i[&d'\"A\u0004\u0002\u0005\u0019\u00148\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u000b\u0007I\u0011\u0001\n\u0002\r5,G\u000f[8e+\u0005\u0019\u0002C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005\u0019iU\r\u001e5pI\"A\u0001\u0004\u0001B\u0001B\u0003%1#A\u0004nKRDw\u000e\u001a\u0011\t\u0011i\u0001!Q1A\u0005\u0002m\tA\u0001[8tiV\tA\u0004\u0005\u0002\u001eI9\u0011aD\t\t\u0003?1i\u0011\u0001\t\u0006\u0003C!\ta\u0001\u0010:p_Rt\u0014BA\u0012\r\u0003\u0019\u0001&/\u001a3fM&\u0011QE\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rb\u0001\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000b!|7\u000f\u001e\u0011\t\u0011)\u0002!Q1A\u0005\u0002m\tA\u0001]1uQ\"AA\u0006\u0001B\u0001B\u0003%A$A\u0003qCRD\u0007\u0005\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0003\u0011\u0001xN\u001d;\u0016\u0003A\u00022aC\u00194\u0013\t\u0011DB\u0001\u0004PaRLwN\u001c\t\u0003\u0017QJ!!\u000e\u0007\u0003\u0007%sG\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u00031\u0003\u0015\u0001xN\u001d;!\u0011!I\u0004A!b\u0001\n\u0003Q\u0014\u0001\u00039s_R|7m\u001c7\u0016\u0003m\u0002\"\u0001\u0006\u001f\n\u0005u\u0012!\u0001\u0003)s_R|7m\u001c7\t\u0011}\u0002!\u0011!Q\u0001\nm\n\u0011\u0002\u001d:pi>\u001cw\u000e\u001c\u0011\t\u0011\u0005\u0003!Q1A\u0005\u0002\t\u000b1\"];fef\u001cFO]5oOV\t1\tE\u0002\fcqA\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IaQ\u0001\rcV,'/_*ue&tw\r\t\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\u0006\u00112M]8tg\u0012{W.Y5o\u0007>|7.[3t+\u0005I\u0005CA\u0006K\u0013\tYEBA\u0004C_>dW-\u00198\t\u00115\u0003!\u0011!Q\u0001\n%\u000b1c\u0019:pgN$u.\\1j]\u000e{wn[5fg\u0002B\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001U\u0001\bQ\u0016\fG-\u001a:t+\u0005\t\u0006c\u0001*V95\t1K\u0003\u0002U\u0005\u0005!Q\u000f^5m\u0013\t16KA\u0005IK\u0006$WM]'ba\"A\u0001\f\u0001B\u0001B\u0003%\u0011+\u0001\u0005iK\u0006$WM]:!\u0011!Q\u0006A!b\u0001\n\u0003Y\u0016\u0001\u00022pIf,\u0012\u0001\u0018\t\u0004\u0017Ej\u0006C\u00010a\u001b\u0005y&B\u0001.\u0003\u0013\t\twL\u0001\u0005C_\u0012L\b+\u0019:u\u0011!\u0019\u0007A!A!\u0002\u0013a\u0016!\u00022pIf\u0004\u0003\u0002C3\u0001\u0005\u000b\u0007I\u0011\u00014\u0002\u001b\t\f7m[3oI\u000e{gNZ5h+\u00059\u0007C\u0001\u000bi\u0013\tI'AA\u0007CC\u000e\\WM\u001c3D_:4\u0017n\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005O\u0006q!-Y2lK:$7i\u001c8gS\u001e\u0004\u0003\u0002C7\u0001\u0005\u000b\u0007I\u0011\u00018\u0002\u000fQLW.Z8viV\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006AA-\u001e:bi&|gN\u0003\u0002u\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Y\f(A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\tq\u0002\u0011\t\u0011)A\u0005_\u0006AA/[7f_V$\b\u0005C\u0003{\u0001\u0011%10\u0001\u0004=S:LGO\u0010\u000b\u0015yvtx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0011\u0005Q\u0001\u0001\"B\tz\u0001\u0004\u0019\u0002\"\u0002\u000ez\u0001\u0004a\u0002\"\u0002\u0016z\u0001\u0004a\u0002\"\u0002\u0018z\u0001\u0004\u0001\u0004\"B\u001dz\u0001\u0004Y\u0004\"B!z\u0001\u0004\u0019\u0005\"B$z\u0001\u0004I\u0005\"B(z\u0001\u0004\t\u0006\"\u0002.z\u0001\u0004a\u0006\"B3z\u0001\u00049\u0007\"B7z\u0001\u0004y\u0007\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0003!awN\\4QCRDWCAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tA\u0001\\1oO*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-C\u0002&\u00037A\u0001\"a\n\u0001A\u0003%\u0011qC\u0001\nY>tw\rU1uQ\u0002B\u0001\"a\u000b\u0001\u0005\u0004%\taG\u0001\u0004kJd\u0007bBA\u0018\u0001\u0001\u0006I\u0001H\u0001\u0005kJd\u0007\u0005C\u0004\u00024\u0001!\t!!\u000e\u0002\u0015]LG\u000f['fi\"|G\rF\u0002}\u0003oAa!EA\u0019\u0001\u0004\u0019\u0002bBA\u001e\u0001\u0011\u0005\u0011QH\u0001\to&$\b\u000eS8tiR\u0019A0a\u0010\t\ri\tI\u00041\u0001\u001d\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0001b^5uQB\u000bG\u000f\u001b\u000b\u0004y\u0006\u001d\u0003B\u0002\u0016\u0002B\u0001\u0007A\u0004C\u0004\u0002L\u0001!\t!!\u0014\u0002\u0011]LG\u000f\u001b)peR$2\u0001`A(\u0011\u0019q\u0013\u0011\na\u0001g!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013aD<ji\"$UMZ1vYR\u0004vN\u001d;\u0015\u0003qDq!!\u0017\u0001\t\u0003\tY&\u0001\u0007xSRD\u0007K]8u_\u000e|G\u000eF\u0002}\u0003;Ba!OA,\u0001\u0004Y\u0004bBA1\u0001\u0011\u0005\u00111M\u0001\u0010o&$\b.U;fef\u001cFO]5oOR\u0019A0!\u001a\t\r\u0005\u000by\u00061\u0001\u001d\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n!c^5uQF+XM]=TiJLgn\u001a*boR\u0019A0!\u001c\t\r\u0005\u000b9\u00071\u0001\u001d\u0011\u001d\t\t\b\u0001C\u0001\u0003+\n!c^5uQ>,H/U;fef\u001cFO]5oO\"9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014AE<ji\"\fV/\u001a:z!\u0006\u0014\u0018-\\3uKJ$R\u0001`A=\u0003{Bq!a\u001f\u0002t\u0001\u0007A$A\u0002lKfDq!a \u0002t\u0001\u0007A$A\u0003wC2,X\rC\u0004\u0002\u0004\u0002!\t!!\"\u0002+]LG\u000f[)vKJL8+Z9QCJ\fW.\u001a;feR)A0a\"\u0002\n\"9\u00111PAA\u0001\u0004a\u0002\u0002CAF\u0003\u0003\u0003\r!!$\u0002\rY\fG.^3t!\u0015\ty)!'\u001d\u001d\u0011\t\t*!&\u000f\u0007}\t\u0019*C\u0001\u000e\u0013\r\t9\nD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY*!(\u0003\u0007M+\u0017OC\u0002\u0002\u00182Aq!!)\u0001\t\u0003\t\u0019+\u0001\rxSRD\u0017+^3ss>\u0013'.Z2u!\u0006\u0014\u0018-\\3uKJ$R\u0001`AS\u0003OCq!a\u001f\u0002 \u0002\u0007A\u0004\u0003\u0005\u0002\f\u0006}\u0005\u0019AAU!\u0019\ty)!'\u0002,B)1\"!,\u001d9%\u0019\u0011q\u0016\u0007\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019\f\u0001C\u0001\u0003k\u000b1c^5uQF+XM]=QCJ\fW.\u001a;feN$2\u0001`A\\\u0011!\tI,!-A\u0002\u0005m\u0016A\u00039be\u0006lW\r^3sgB)1\"!0\u0002,&\u0019\u0011q\u0018\u0007\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0004\u0002D\u0002!\t!!2\u0002\u0015]LG\u000f\u001b%fC\u0012,'\u000fF\u0003}\u0003\u000f\fI\rC\u0004\u0002|\u0005\u0005\u0007\u0019\u0001\u000f\t\u000f\u0005}\u0014\u0011\u0019a\u00019!9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0017aC<ji\"DU-\u00193feN$2\u0001`Ai\u0011!\t\u0019.a3A\u0002\u0005m\u0016A\u00038fo\"+\u0017\rZ3sg\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0017AF<ji\"\u001c%o\\:t\t>l\u0017-\u001b8D_>\\\u0017.Z:\u0015\u0007q\fY\u000eC\u0004\u0002^\u0006U\u0007\u0019A%\u0002\rQ|wm\u001a7f\u0011\u001d\t\t\u000f\u0001C\u0001\u0003G\f1b^5uQRKW.Z8viR\u0019A0!:\t\r5\fy\u000e1\u0001p\u0011\u001d\tI\u000f\u0001C\u0001\u0003W\fqa^5uQV\u0013F\nF\u0002}\u0003[Dq!a\u000b\u0002h\u0002\u0007A\u0004C\u0004\u0002r\u0002!\t!a=\u0002#]LG\u000f\u001b\"bG.,g\u000eZ\"p]\u001aLw\rF\u0002}\u0003kDa!ZAx\u0001\u00049\u0007bBA}\u0001\u0011\u0005\u00111`\u0001\to&$\bNQ8esR\u0019A0!@\t\ri\u000b9\u00101\u0001^\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007\tQaX:f]\u0012,BA!\u0002\u0003\u0016Q!!q\u0001B!)\u0011\u0011IA!\f\u0011\r\t-!Q\u0002B\t\u001b\u0005\u0019\u0018b\u0001B\bg\n1a)\u001e;ve\u0016\u0004BAa\u0005\u0003\u00161\u0001A\u0001\u0003B\f\u0003\u007f\u0014\rA!\u0007\u0003\u0003Q\u000bBAa\u0007\u0003\"A\u00191B!\b\n\u0007\t}ABA\u0004O_RD\u0017N\\4\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQ1Aa\n\u0003\u0003!\u0011Xm\u001d9p]N,\u0017\u0002\u0002B\u0016\u0005K\u0011A\u0002\u0013;uaJ+7\u000f]8og\u0016D\u0001Ba\f\u0002\u0000\u0002\u000f!\u0011G\u0001\ng\u000eDW\rZ;mKJ\u0004BAa\r\u0003>5\u0011!Q\u0007\u0006\u0005\u0005o\u0011I$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!1H\u0001\u0006[>t\u0017\u000e_\u0005\u0005\u0005\u007f\u0011)DA\u0005TG\",G-\u001e7fe\"A!1IA\u0000\u0001\u0004\u0011)%A\u0004gC\u000e$xN]=\u0011\r\t\r\"q\tB\t\u0013\u0011\u0011IE!\n\u0003'!#H\u000f\u001d*fgB|gn]3GC\u000e$xN]=\t\u000f\t5\u0003\u0001\"\u0001\u0003P\u000511\u000f\u001e:fC6$\"A!\u0015\u0015\t\tM#1\f\t\u0007\u0005\u0017\u0011iA!\u0016\u0011\t\t\r\"qK\u0005\u0005\u00053\u0012)C\u0001\nTiJ,\u0017-\u001c%uiB\u0014Vm\u001d9p]N,\u0007\u0002\u0003B\u0018\u0005\u0017\u0002\u001dA!\r\t\u000f\t}\u0003\u0001\"\u0001\u0003b\u0005!1/\u001a8e)\t\u0011\u0019\u0007\u0006\u0003\u0003f\t5\u0004C\u0002B\u0006\u0005\u001b\u00119\u0007\u0005\u0003\u0003$\t%\u0014\u0002\u0002B6\u0005K\u0011!cU5na2,\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tK\"A!q\u0006B/\u0001\b\u0011\t\u0004C\u0004\u0003r\u0001!\tAa\u001d\u0002\u0007\u001d,G\u000f\u0006\u0002\u0003vQ!!Q\rB<\u0011!\u0011yCa\u001cA\u0004\tE\u0002b\u0002B>\u0001\u0011\u0005!QP\u0001\u0005a>\u001cH\u000f\u0006\u0003\u0003\u0000\t\rE\u0003\u0002B3\u0005\u0003C\u0001Ba\f\u0003z\u0001\u000f!\u0011\u0007\u0005\u00075\ne\u0004\u0019A/\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\u0006\u0019\u0001/\u001e;\u0015\t\t-%q\u0012\u000b\u0005\u0005K\u0012i\t\u0003\u0005\u00030\t\u0015\u00059\u0001B\u0019\u0011\u0019Q&Q\u0011a\u0001;\"9!1\u0013\u0001\u0005\u0002\tU\u0015aB8qi&|gn\u001d\u000b\u0005\u0005/\u0013Y\n\u0006\u0003\u0003f\te\u0005\u0002\u0003B\u0018\u0005#\u0003\u001dA!\r\t\ri\u0013\t\n1\u0001^\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005?#BA!)\u0003&R!!Q\rBR\u0011!\u0011yC!(A\u0004\tE\u0002B\u0002.\u0003\u001e\u0002\u0007Q\fC\u0004\u0003*\u0002!IAa+\u0002\t\r|\u0007/\u001f\u000b\u0018y\n5&q\u0016BY\u0005g\u0013)La.\u0003:\nm&Q\u0018B`\u0005\u0003D\u0001\"\u0005BT!\u0003\u0005\ra\u0005\u0005\t5\t\u001d\u0006\u0013!a\u00019!A!Fa*\u0011\u0002\u0003\u0007A\u0004\u0003\u0005/\u0005O\u0003\n\u00111\u00011\u0011!I$q\u0015I\u0001\u0002\u0004Y\u0004\u0002C!\u0003(B\u0005\t\u0019A\"\t\u0011=\u00139\u000b%AA\u0002EC\u0001b\u0012BT!\u0003\u0005\r!\u0013\u0005\t5\n\u001d\u0006\u0013!a\u00019\"AQMa*\u0011\u0002\u0003\u0007q\r\u0003\u0005n\u0005O\u0003\n\u00111\u0001p\u0011%\u0011)\rAI\u0001\n\u0013\u00119-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t%'fA\n\u0003L.\u0012!Q\u001a\t\u0005\u0005\u001f\u0014I.\u0004\u0002\u0003R*!!1\u001bBk\u0003%)hn\u00195fG.,GMC\u0002\u0003X2\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YN!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003`\u0002\t\n\u0011\"\u0003\u0003b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BrU\ra\"1\u001a\u0005\n\u0005O\u0004\u0011\u0013!C\u0005\u0005C\fabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0003l\u0002\t\n\u0011\"\u0003\u0003n\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001BxU\r\u0001$1\u001a\u0005\n\u0005g\u0004\u0011\u0013!C\u0005\u0005k\fabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003x*\u001a1Ha3\t\u0013\tm\b!%A\u0005\n\tu\u0018AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u0005\u007fT3a\u0011Bf\u0011%\u0019\u0019\u0001AI\u0001\n\u0013\u0019)!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r\u001d!fA)\u0003L\"I11\u0002\u0001\u0012\u0002\u0013%1QB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019yAK\u0002J\u0005\u0017D\u0011ba\u0005\u0001#\u0003%Ia!\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u00111q\u0003\u0016\u00049\n-\u0007\"CB\u000e\u0001E\u0005I\u0011BB\u000f\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\u0002TCAB\u0010U\r9'1\u001a\u0005\n\u0007G\u0001\u0011\u0013!C\u0005\u0007K\tqbY8qs\u0012\"WMZ1vYR$\u0013'M\u000b\u0003\u0007OQ3a\u001cBf\u000f\u001d\u0019YC\u0001E\u0001\u0007[\t1\u0002\u0013;uaJ+\u0017/^3tiB\u0019Aca\f\u0007\r\u0005\u0011\u0001\u0012AB\u0019'\r\u0019yC\u0003\u0005\bu\u000e=B\u0011AB\u001b)\t\u0019i\u0003\u0003\u0005\u0004:\r=B\u0011BB\u001e\u0003\u001d!WMZ1vYR,\u0012\u0001 \u0005\t\u0007\u007f\u0019y\u0003\"\u0001\u0002V\u0005)\u0011\r\u001d9ms\"A1qHB\u0018\t\u0003\u0019\u0019\u0005F\u0002}\u0007\u000bBq!a\u000b\u0004B\u0001\u0007A\u0004")
public final class HttpRequest {
    private final Method method;
    private final String host;
    private final String path;
    private final Option<Object> port;
    private final Protocol protocol;
    private final Option<String> queryString;
    private final boolean crossDomainCookies;
    private final HeaderMap<String> headers;
    private final Option<BodyPart> body;
    private final BackendConfig backendConfig;
    private final FiniteDuration timeout;
    private final String longPath;
    private final String url;

    public static HttpRequest apply(String string) {
        return HttpRequest$.MODULE$.apply(string);
    }

    public static HttpRequest apply() {
        return HttpRequest$.MODULE$.apply();
    }

    public Method method() {
        return this.method;
    }

    public String host() {
        return this.host;
    }

    public String path() {
        return this.path;
    }

    public Option<Object> port() {
        return this.port;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public Option<String> queryString() {
        return this.queryString;
    }

    public boolean crossDomainCookies() {
        return this.crossDomainCookies;
    }

    public HeaderMap<String> headers() {
        return this.headers;
    }

    public Option<BodyPart> body() {
        return this.body;
    }

    public BackendConfig backendConfig() {
        return this.backendConfig;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public String longPath() {
        return this.longPath;
    }

    public String url() {
        return this.url;
    }

    public HttpRequest withMethod(Method method) {
        return this.copy(method, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public HttpRequest withHost(String host) {
        String x$2 = host;
        Method x$3 = this.copy$default$1();
        String x$4 = this.copy$default$3();
        Option<Object> x$5 = this.copy$default$4();
        Protocol x$6 = this.copy$default$5();
        Option<String> x$7 = this.copy$default$6();
        HeaderMap<String> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$8();
        Option<BodyPart> x$10 = this.copy$default$9();
        BackendConfig x$11 = this.copy$default$10();
        FiniteDuration x$12 = this.copy$default$11();
        return this.copy(x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
    }

    public HttpRequest withPath(String path) {
        String x$13 = path;
        Method x$14 = this.copy$default$1();
        String x$15 = this.copy$default$2();
        Option<Object> x$16 = this.copy$default$4();
        Protocol x$17 = this.copy$default$5();
        Option<String> x$18 = this.copy$default$6();
        HeaderMap<String> x$19 = this.copy$default$7();
        boolean x$20 = this.copy$default$8();
        Option<BodyPart> x$21 = this.copy$default$9();
        BackendConfig x$22 = this.copy$default$10();
        FiniteDuration x$23 = this.copy$default$11();
        return this.copy(x$14, x$15, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23);
    }

    public HttpRequest withPort(int port) {
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)port));
        Method x$25 = this.copy$default$1();
        String x$26 = this.copy$default$2();
        String x$27 = this.copy$default$3();
        Protocol x$28 = this.copy$default$5();
        Option<String> x$29 = this.copy$default$6();
        HeaderMap<String> x$30 = this.copy$default$7();
        boolean x$31 = this.copy$default$8();
        Option<BodyPart> x$32 = this.copy$default$9();
        BackendConfig x$33 = this.copy$default$10();
        FiniteDuration x$34 = this.copy$default$11();
        return this.copy(x$25, x$26, x$27, (Option<Object>)x$24, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
    }

    public HttpRequest withDefaultPort() {
        None$ x$35 = None$.MODULE$;
        Method x$36 = this.copy$default$1();
        String x$37 = this.copy$default$2();
        String x$38 = this.copy$default$3();
        Protocol x$39 = this.copy$default$5();
        Option<String> x$40 = this.copy$default$6();
        HeaderMap<String> x$41 = this.copy$default$7();
        boolean x$42 = this.copy$default$8();
        Option<BodyPart> x$43 = this.copy$default$9();
        BackendConfig x$44 = this.copy$default$10();
        FiniteDuration x$45 = this.copy$default$11();
        return this.copy(x$36, x$37, x$38, (Option<Object>)x$35, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
    }

    public HttpRequest withProtocol(Protocol protocol) {
        Protocol x$46 = protocol;
        Method x$47 = this.copy$default$1();
        String x$48 = this.copy$default$2();
        String x$49 = this.copy$default$3();
        Option<Object> x$50 = this.copy$default$4();
        Option<String> x$51 = this.copy$default$6();
        HeaderMap<String> x$52 = this.copy$default$7();
        boolean x$53 = this.copy$default$8();
        Option<BodyPart> x$54 = this.copy$default$9();
        BackendConfig x$55 = this.copy$default$10();
        FiniteDuration x$56 = this.copy$default$11();
        return this.copy(x$47, x$48, x$49, x$50, x$46, x$51, x$52, x$53, x$54, x$55, x$56);
    }

    public HttpRequest withQueryString(String queryString) {
        Some x$57 = new Some((Object)Utils$.MODULE$.encodeQueryString(queryString));
        Method x$58 = this.copy$default$1();
        String x$59 = this.copy$default$2();
        String x$60 = this.copy$default$3();
        Option<Object> x$61 = this.copy$default$4();
        Protocol x$62 = this.copy$default$5();
        HeaderMap<String> x$63 = this.copy$default$7();
        boolean x$64 = this.copy$default$8();
        Option<BodyPart> x$65 = this.copy$default$9();
        BackendConfig x$66 = this.copy$default$10();
        FiniteDuration x$67 = this.copy$default$11();
        return this.copy(x$58, x$59, x$60, x$61, x$62, (Option<String>)x$57, x$63, x$64, x$65, x$66, x$67);
    }

    public HttpRequest withQueryStringRaw(String queryString) {
        Some x$68 = new Some((Object)queryString);
        Method x$69 = this.copy$default$1();
        String x$70 = this.copy$default$2();
        String x$71 = this.copy$default$3();
        Option<Object> x$72 = this.copy$default$4();
        Protocol x$73 = this.copy$default$5();
        HeaderMap<String> x$74 = this.copy$default$7();
        boolean x$75 = this.copy$default$8();
        Option<BodyPart> x$76 = this.copy$default$9();
        BackendConfig x$77 = this.copy$default$10();
        FiniteDuration x$78 = this.copy$default$11();
        return this.copy(x$69, x$70, x$71, x$72, x$73, (Option<String>)x$68, x$74, x$75, x$76, x$77, x$78);
    }

    public HttpRequest withoutQueryString() {
        None$ x$79 = None$.MODULE$;
        Method x$80 = this.copy$default$1();
        String x$81 = this.copy$default$2();
        String x$82 = this.copy$default$3();
        Option<Object> x$83 = this.copy$default$4();
        Protocol x$84 = this.copy$default$5();
        HeaderMap<String> x$85 = this.copy$default$7();
        boolean x$86 = this.copy$default$8();
        Option<BodyPart> x$87 = this.copy$default$9();
        BackendConfig x$88 = this.copy$default$10();
        FiniteDuration x$89 = this.copy$default$11();
        return this.copy(x$80, x$81, x$82, x$83, x$84, (Option<String>)x$79, x$85, x$86, x$87, x$88, x$89);
    }

    public HttpRequest withQueryParameter(String key, String value) {
        Some x$90 = new Some((Object)((String)this.queryString().map((Function1 & Serializable & scala.Serializable)q -> q + '&').getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + CrossPlatformUtils$.MODULE$.encodeURIComponent(key) + "=" + CrossPlatformUtils$.MODULE$.encodeURIComponent(value)));
        Method x$91 = this.copy$default$1();
        String x$92 = this.copy$default$2();
        String x$93 = this.copy$default$3();
        Option<Object> x$94 = this.copy$default$4();
        Protocol x$95 = this.copy$default$5();
        HeaderMap<String> x$96 = this.copy$default$7();
        boolean x$97 = this.copy$default$8();
        Option<BodyPart> x$98 = this.copy$default$9();
        BackendConfig x$99 = this.copy$default$10();
        FiniteDuration x$100 = this.copy$default$11();
        return this.copy(x$91, x$92, x$93, x$94, x$95, (Option<String>)x$90, x$96, x$97, x$98, x$99, x$100);
    }

    public HttpRequest withQuerySeqParameter(String key, Seq<String> values) {
        return (HttpRequest)values.foldLeft((Object)this, (Function2 & Serializable & scala.Serializable)(acc, value) -> acc.withQueryParameter(key, (String)value));
    }

    public HttpRequest withQueryObjectParameter(String key, Seq<Tuple2<String, String>> values) {
        return this.withQueryParameters((Seq<Tuple2<String, String>>)((Seq)values.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, p._1()})), p._2()), Seq$.MODULE$.canBuildFrom())));
    }

    public HttpRequest withQueryParameters(Seq<Tuple2<String, String>> parameters) {
        return (HttpRequest)parameters.foldLeft((Object)this, (Function2 & Serializable & scala.Serializable)(acc, entry) -> acc.withQueryParameter((String)entry._1(), (String)entry._2()));
    }

    public HttpRequest withHeader(String key, String value) {
        HeaderMap<String> x$101 = HeaderMap$.MODULE$.apply((Map<String, String>)this.headers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        Method x$102 = this.copy$default$1();
        String x$103 = this.copy$default$2();
        String x$104 = this.copy$default$3();
        Option<Object> x$105 = this.copy$default$4();
        Protocol x$106 = this.copy$default$5();
        Option<String> x$107 = this.copy$default$6();
        boolean x$108 = this.copy$default$8();
        Option<BodyPart> x$109 = this.copy$default$9();
        BackendConfig x$110 = this.copy$default$10();
        FiniteDuration x$111 = this.copy$default$11();
        return this.copy(x$102, x$103, x$104, x$105, x$106, x$107, x$101, x$108, x$109, x$110, x$111);
    }

    public HttpRequest withHeaders(Seq<Tuple2<String, String>> newHeaders) {
        HeaderMap<String> x$112 = HeaderMap$.MODULE$.apply(this.headers().$plus$plus(newHeaders));
        Method x$113 = this.copy$default$1();
        String x$114 = this.copy$default$2();
        String x$115 = this.copy$default$3();
        Option<Object> x$116 = this.copy$default$4();
        Protocol x$117 = this.copy$default$5();
        Option<String> x$118 = this.copy$default$6();
        boolean x$119 = this.copy$default$8();
        Option<BodyPart> x$120 = this.copy$default$9();
        BackendConfig x$121 = this.copy$default$10();
        FiniteDuration x$122 = this.copy$default$11();
        return this.copy(x$113, x$114, x$115, x$116, x$117, x$118, x$112, x$119, x$120, x$121, x$122);
    }

    public HttpRequest withCrossDomainCookies(boolean toggle) {
        boolean x$123 = toggle;
        Method x$124 = this.copy$default$1();
        String x$125 = this.copy$default$2();
        String x$126 = this.copy$default$3();
        Option<Object> x$127 = this.copy$default$4();
        Protocol x$128 = this.copy$default$5();
        Option<String> x$129 = this.copy$default$6();
        HeaderMap<String> x$130 = this.copy$default$7();
        Option<BodyPart> x$131 = this.copy$default$9();
        BackendConfig x$132 = this.copy$default$10();
        FiniteDuration x$133 = this.copy$default$11();
        return this.copy(x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$123, x$131, x$132, x$133);
    }

    public HttpRequest withTimeout(FiniteDuration timeout) {
        FiniteDuration x$134 = timeout;
        Method x$135 = this.copy$default$1();
        String x$136 = this.copy$default$2();
        String x$137 = this.copy$default$3();
        Option<Object> x$138 = this.copy$default$4();
        Protocol x$139 = this.copy$default$5();
        Option<String> x$140 = this.copy$default$6();
        HeaderMap<String> x$141 = this.copy$default$7();
        boolean x$142 = this.copy$default$8();
        Option<BodyPart> x$143 = this.copy$default$9();
        BackendConfig x$144 = this.copy$default$10();
        return this.copy(x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$134);
    }

    public HttpRequest withURL(String url) {
        URI parser = new URI(url);
        Protocol x$145 = parser.getScheme() != null ? Protocol$.MODULE$.fromString(parser.getScheme()) : this.protocol();
        String x$146 = parser.getHost() != null ? parser.getHost() : this.host();
        Some x$147 = parser.getPort() != -1 ? new Some((Object)BoxesRunTime.boxToInteger((int)parser.getPort())) : this.port();
        String x$148 = parser.getPath() != null ? parser.getPath() : this.path();
        Some x$149 = parser.getQuery() != null ? new Some((Object)Utils$.MODULE$.encodeQueryString(parser.getQuery())) : this.queryString();
        Method x$150 = this.copy$default$1();
        HeaderMap<String> x$151 = this.copy$default$7();
        boolean x$152 = this.copy$default$8();
        Option<BodyPart> x$153 = this.copy$default$9();
        BackendConfig x$154 = this.copy$default$10();
        FiniteDuration x$155 = this.copy$default$11();
        return this.copy(x$150, x$146, x$148, (Option<Object>)x$147, x$145, (Option<String>)x$149, x$151, x$152, x$153, x$154, x$155);
    }

    public HttpRequest withBackendConfig(BackendConfig backendConfig) {
        BackendConfig x$156 = backendConfig;
        Method x$157 = this.copy$default$1();
        String x$158 = this.copy$default$2();
        String x$159 = this.copy$default$3();
        Option<Object> x$160 = this.copy$default$4();
        Protocol x$161 = this.copy$default$5();
        Option<String> x$162 = this.copy$default$6();
        HeaderMap<String> x$163 = this.copy$default$7();
        boolean x$164 = this.copy$default$8();
        Option<BodyPart> x$165 = this.copy$default$9();
        FiniteDuration x$166 = this.copy$default$11();
        return this.copy(x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$156, x$166);
    }

    public HttpRequest withBody(BodyPart body) {
        HttpRequest qual$1 = this.withHeader("Content-Type", body.contentType());
        Some x$167 = new Some((Object)body);
        Method x$168 = qual$1.copy$default$1();
        String x$169 = qual$1.copy$default$2();
        String x$170 = qual$1.copy$default$3();
        Option<Object> x$171 = qual$1.copy$default$4();
        Protocol x$172 = qual$1.copy$default$5();
        Option<String> x$173 = qual$1.copy$default$6();
        HeaderMap<String> x$174 = qual$1.copy$default$7();
        boolean x$175 = qual$1.copy$default$8();
        BackendConfig x$176 = qual$1.copy$default$10();
        FiniteDuration x$177 = qual$1.copy$default$11();
        return qual$1.copy(x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, (Option<BodyPart>)x$167, x$176, x$177);
    }

    private <T extends HttpResponse> Future<T> _send(HttpResponseFactory<T> factory, Scheduler scheduler) {
        Promise promise = Promise$.MODULE$.apply();
        Cancelable timeoutTask = scheduler.scheduleOnce(this.timeout().length(), this.timeout().unit(), new Runnable(null, promise){
            private final Promise promise$1;

            public void run() {
                this.promise$1.tryFailure((Throwable)new TimeoutException(TimeoutException$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.promise$1 = promise$1;
            }
        });
        Future<T> backendFuture = HttpDriver$.MODULE$.send(this, factory, scheduler);
        backendFuture.onComplete((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)HttpRequest.$anonfun$_send$1(promise, timeoutTask, response)), (ExecutionContext)scheduler);
        return promise.future();
    }

    public Future<StreamHttpResponse> stream(Scheduler scheduler) {
        return this._send(StreamHttpResponse$.MODULE$, scheduler);
    }

    public Future<SimpleHttpResponse> send(Scheduler scheduler) {
        return this._send(SimpleHttpResponse$.MODULE$, scheduler);
    }

    public Future<SimpleHttpResponse> get(Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.GET()).send(scheduler);
    }

    public Future<SimpleHttpResponse> post(BodyPart body, Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.POST()).send(body, scheduler);
    }

    public Future<SimpleHttpResponse> put(BodyPart body, Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.PUT()).send(body, scheduler);
    }

    public Future<SimpleHttpResponse> options(BodyPart body, Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.OPTIONS()).send(body, scheduler);
    }

    public Future<SimpleHttpResponse> send(BodyPart body, Scheduler scheduler) {
        return this.withBody(body).send(scheduler);
    }

    private HttpRequest copy(Method method, String host, String path, Option<Object> port, Protocol protocol, Option<String> queryString, HeaderMap<String> headers, boolean crossDomainCookies, Option<BodyPart> body, BackendConfig backendConfig, FiniteDuration timeout) {
        return new HttpRequest(method, host, path, port, protocol, queryString, crossDomainCookies, headers, body, backendConfig, timeout);
    }

    private Method copy$default$1() {
        return this.method();
    }

    private String copy$default$2() {
        return this.host();
    }

    private String copy$default$3() {
        return this.path();
    }

    private Option<Object> copy$default$4() {
        return this.port();
    }

    private Protocol copy$default$5() {
        return this.protocol();
    }

    private Option<String> copy$default$6() {
        return this.queryString();
    }

    private HeaderMap<String> copy$default$7() {
        return this.headers();
    }

    private boolean copy$default$8() {
        return this.crossDomainCookies();
    }

    private Option<BodyPart> copy$default$9() {
        return this.body();
    }

    private BackendConfig copy$default$10() {
        return this.backendConfig();
    }

    private FiniteDuration copy$default$11() {
        return this.timeout();
    }

    public static final /* synthetic */ String $anonfun$url$2(int x$1) {
        return ":" + x$1;
    }

    public static final /* synthetic */ boolean $anonfun$_send$1(Promise promise$1, Cancelable timeoutTask$1, Try response) {
        timeoutTask$1.cancel();
        return promise$1.tryComplete(response);
    }

    public HttpRequest(Method method, String host, String path, Option<Object> port, Protocol protocol, Option<String> queryString, boolean crossDomainCookies, HeaderMap<String> headers, Option<BodyPart> body, BackendConfig backendConfig, FiniteDuration timeout) {
        this.method = method;
        this.host = host;
        this.path = path;
        this.port = port;
        this.protocol = protocol;
        this.queryString = queryString;
        this.crossDomainCookies = crossDomainCookies;
        this.headers = headers;
        this.body = body;
        this.backendConfig = backendConfig;
        this.timeout = timeout;
        this.longPath = path + queryString.map((Function1 & Serializable & scala.Serializable)q -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"?", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{q}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol, host, port.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$1 -> HttpRequest.$anonfun$url$2(BoxesRunTime.unboxToInt((Object)x$1))), this.longPath()}));
    }
}

