/*
 * Decompiled with CFR 0.152.
 */
package fr.hmil.roshttp;

import fr.hmil.roshttp.ByteBufferChopper$;
import fr.hmil.roshttp.ByteBufferQueue;
import fr.hmil.roshttp.ByteBufferQueue$;
import fr.hmil.roshttp.Converters$;
import fr.hmil.roshttp.DriverTrait;
import fr.hmil.roshttp.HttpRequest;
import fr.hmil.roshttp.body.BodyPart;
import fr.hmil.roshttp.exceptions.HttpException$;
import fr.hmil.roshttp.exceptions.RequestException;
import fr.hmil.roshttp.exceptions.UploadStreamException;
import fr.hmil.roshttp.response.HttpResponse;
import fr.hmil.roshttp.response.HttpResponseFactory;
import fr.hmil.roshttp.response.HttpResponseHeader;
import fr.hmil.roshttp.util.HeaderMap$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import monix.execution.Ack;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observer;
import org.scalajs.dom.ext.Ajax;
import org.scalajs.dom.package$;
import org.scalajs.dom.raw.ErrorEvent;
import org.scalajs.dom.raw.Event;
import org.scalajs.dom.raw.XMLHttpRequest;
import scala.Array$;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.scalajs.js.Any;
import scala.scalajs.js.Function1;
import scala.scalajs.js.JavaScriptException;
import scala.scalajs.js.typedarray.ArrayBuffer;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class BrowserDriver$
implements DriverTrait {
    public static BrowserDriver$ MODULE$;

    static {
        new BrowserDriver$();
    }

    @Override
    public <T extends HttpResponse> Future<T> send(HttpRequest req, HttpResponseFactory<T> factory, Scheduler scheduler) {
        BoxedUnit boxedUnit;
        Promise p = Promise$.MODULE$.apply();
        XMLHttpRequest xhr = new XMLHttpRequest();
        xhr.open(req.method().toString(), req.url(), xhr.open$default$3(), xhr.open$default$4(), xhr.open$default$5());
        xhr.withCredentials_$eq(req.crossDomainCookies());
        xhr.responseType_$eq("arraybuffer");
        req.headers().foreach((scala.Function1 & Serializable & scala.Serializable)t -> {
            xhr.setRequestHeader((String)t._1(), (String)t._2());
            return BoxedUnit.UNIT;
        });
        xhr.onerror_$eq(new Function1<ErrorEvent, Promise<T>>(p){
            private final Promise p$1;

            public final Promise<T> apply(ErrorEvent arg1) {
                return BrowserDriver$.fr$hmil$roshttp$BrowserDriver$$$anonfun$send$2(arg1, this.p$1);
            }
            {
                this.p$1 = p$1;
                super((Seq)Nil$.MODULE$);
            }
        });
        ByteBufferQueue bufferQueue = new ByteBufferQueue(req.backendConfig().internalBufferLength(), ByteBufferQueue$.MODULE$.$lessinit$greater$default$2(), (ExecutionContext)scheduler);
        xhr.onreadystatechange_$eq((Function1)new Function1<Event, Object>(req, factory, scheduler, p, xhr, bufferQueue){
            private final HttpRequest req$1;
            private final HttpResponseFactory factory$1;
            private final Scheduler scheduler$1;
            private final Promise p$1;
            private final XMLHttpRequest xhr$1;
            private final ByteBufferQueue bufferQueue$1;

            public final Object apply(Event arg1) {
                return BrowserDriver$.fr$hmil$roshttp$BrowserDriver$$$anonfun$send$3(arg1, this.req$1, this.factory$1, this.scheduler$1, this.p$1, this.xhr$1, this.bufferQueue$1);
            }
            {
                this.req$1 = req$1;
                this.factory$1 = factory$1;
                this.scheduler$1 = scheduler$1;
                this.p$1 = p$1;
                this.xhr$1 = xhr$1;
                this.bufferQueue$1 = bufferQueue$1;
                super((Seq)Nil$.MODULE$);
            }
        });
        if (req.body().isEmpty()) {
            xhr.send(xhr.send$default$1());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = this.bufferBody(((BodyPart)req.body().get()).content(), scheduler).andThen((PartialFunction)new scala.Serializable(p, xhr){
                public static final long serialVersionUID = 0L;
                private final Promise p$1;
                private final XMLHttpRequest xhr$1;

                public final <A1 extends Try<ByteBuffer>, B1> B1 applyOrElse(A1 x1, scala.Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        Success success = (Success)A1;
                        this.xhr$1.send((Any)Ajax.InputData$.MODULE$.byteBuffer2ajax((ByteBuffer)success.value()));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Failure) {
                        Failure failure = (Failure)A1;
                        object = this.p$1.failure(failure.exception());
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Try<ByteBuffer> x1) {
                    Try<ByteBuffer> try_ = x1;
                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure;
                    return bl;
                }
                {
                    this.p$1 = p$1;
                    this.xhr$1 = xhr$1;
                }
            }, (ExecutionContext)scheduler);
        }
        return p.future();
    }

    private Future<ByteBuffer> bufferBody(Observable<ByteBuffer> bodyStream, Scheduler scheduler) {
        Queue bufferQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef bytes = IntRef.create((int)0);
        Promise p = Promise$.MODULE$.apply();
        bodyStream.subscribe((Observer)new Observer<ByteBuffer>(bufferQueue, bytes, p){
            private final Queue bufferQueue$2;
            private final IntRef bytes$1;
            private final Promise p$2;

            public void onError(Throwable ex) {
                this.p$2.failure((Throwable)new UploadStreamException(ex));
            }

            public void onComplete() {
                this.p$2.success((Object)BrowserDriver$.MODULE$.fr$hmil$roshttp$BrowserDriver$$recomposeBody((Queue<ByteBuffer>)this.bufferQueue$2, this.bytes$1.elem));
            }

            public Future<Ack> onNext(ByteBuffer elem) {
                this.bytes$1.elem += elem.limit();
                this.bufferQueue$2.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ByteBuffer[]{elem}));
                return Future$.MODULE$.successful((Object)Ack.Continue$.MODULE$);
            }
            {
                this.bufferQueue$2 = bufferQueue$2;
                this.bytes$1 = bytes$1;
                this.p$2 = p$2;
            }
        }, scheduler);
        return p.future();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer fr$hmil$roshttp$BrowserDriver$$recomposeBody(Queue<ByteBuffer> seq, int bytes) {
        void var3_3;
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        seq.foreach((scala.Function1 & Serializable & scala.Serializable)chunk -> buffer.put((ByteBuffer)chunk));
        buffer.rewind();
        return var3_3;
    }

    public static final /* synthetic */ Promise fr$hmil$roshttp$BrowserDriver$$$anonfun$send$2(ErrorEvent e, Promise p$1) {
        return p$1.failure((Throwable)new RequestException(new JavaScriptException((Object)e)));
    }

    public static final /* synthetic */ Object fr$hmil$roshttp$BrowserDriver$$$anonfun$send$3(Event e, HttpRequest req$1, HttpResponseFactory factory$1, Scheduler scheduler$1, Promise p$1, XMLHttpRequest xhr$1, ByteBufferQueue bufferQueue$1) {
        BoxedUnit boxedUnit;
        if (xhr$1.readyState() == package$.MODULE$.XMLHttpRequest().HEADERS_RECEIVED()) {
            Map map;
            String string = xhr$1.getAllResponseHeaders();
            if (string == null) {
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            } else if (string != null) {
                String string2 = string;
                map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string2.split("\r\n"))).map((scala.Function1 & Serializable & scala.Serializable)s -> {
                    String[] split = s.split(": ");
                    return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).head(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).tail())).mkString().trim());
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new MatchError((Object)string);
            }
            Map headers = map;
            boxedUnit = p$1.completeWith(factory$1.apply(new HttpResponseHeader(xhr$1.status(), HeaderMap$.MODULE$.apply((Map<String, String>)headers)), bufferQueue$1.observable(), req$1.backendConfig(), scheduler$1).map((scala.Function1 & Serializable & scala.Serializable)response -> {
                if (xhr$1.status() >= 400) {
                    throw HttpException$.MODULE$.badStatus(response);
                }
                return response;
            }, (ExecutionContext)scheduler$1));
        } else if (xhr$1.readyState() == package$.MODULE$.XMLHttpRequest().DONE()) {
            BrowserDriver$.chopChunk$1(req$1, xhr$1).foreach((scala.Function1 & Serializable & scala.Serializable)buffer -> {
                bufferQueue$1.push(buffer);
                return BoxedUnit.UNIT;
            });
            bufferQueue$1.end();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq chopChunk$1(HttpRequest req$1, XMLHttpRequest xhr$1) {
        void var3_3;
        ArrayBuffer buffer = (ArrayBuffer)xhr$1.response();
        Seq<ByteBuffer> buffers = ByteBufferChopper$.MODULE$.chop(Converters$.MODULE$.arrayBufferToByteBuffer(buffer), req$1.backendConfig().maxChunkSize());
        return var3_3;
    }

    private BrowserDriver$() {
        MODULE$ = this;
    }
}

