/*
 * Decompiled with CFR 0.152.
 */
package fr.hmil.roshttp;

import fr.hmil.roshttp.BackendConfig;
import fr.hmil.roshttp.CrossPlatformUtils$;
import fr.hmil.roshttp.HttpDriver$;
import fr.hmil.roshttp.HttpRequest$;
import fr.hmil.roshttp.Method;
import fr.hmil.roshttp.Method$;
import fr.hmil.roshttp.Protocol;
import fr.hmil.roshttp.Protocol$;
import fr.hmil.roshttp.body.BodyPart;
import fr.hmil.roshttp.exceptions.TimeoutException;
import fr.hmil.roshttp.exceptions.TimeoutException$;
import fr.hmil.roshttp.response.HttpResponse;
import fr.hmil.roshttp.response.HttpResponseFactory;
import fr.hmil.roshttp.response.SimpleHttpResponse;
import fr.hmil.roshttp.response.SimpleHttpResponse$;
import fr.hmil.roshttp.response.StreamHttpResponse;
import fr.hmil.roshttp.response.StreamHttpResponse$;
import fr.hmil.roshttp.util.HeaderMap;
import fr.hmil.roshttp.util.HeaderMap$;
import fr.hmil.roshttp.util.Utils$;
import java.net.URI;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001B\u0001\u0003\u0005%\u00111\u0002\u0013;uaJ+\u0017/^3ti*\u00111\u0001B\u0001\be>\u001c\b\u000e\u001e;q\u0015\t)a!\u0001\u0003i[&d'\"A\u0004\u0002\u0005\u0019\u00148\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u000b\u0007I\u0011\u0001\n\u0002\r5,G\u000f[8e+\u0005\u0019\u0002C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005\u0019iU\r\u001e5pI\"A\u0001\u0004\u0001B\u0001B\u0003%1#A\u0004nKRDw\u000e\u001a\u0011\t\u0011i\u0001!Q1A\u0005\u0002m\tA\u0001[8tiV\tA\u0004\u0005\u0002\u001eA9\u00111BH\u0005\u0003?1\ta\u0001\u0015:fI\u00164\u0017BA\u0011#\u0005\u0019\u0019FO]5oO*\u0011q\u0004\u0004\u0005\tI\u0001\u0011\t\u0011)A\u00059\u0005)\u0001n\\:uA!Aa\u0005\u0001BC\u0002\u0013\u00051$\u0001\u0003qCRD\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000bA\fG\u000f\u001b\u0011\t\u0011)\u0002!Q1A\u0005\u0002-\nA\u0001]8siV\tA\u0006E\u0002\f[=J!A\f\u0007\u0003\r=\u0003H/[8o!\tY\u0001'\u0003\u00022\u0019\t\u0019\u0011J\u001c;\t\u0011M\u0002!\u0011!Q\u0001\n1\nQ\u0001]8si\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\taJ|Go\\2pYV\tq\u0007\u0005\u0002\u0015q%\u0011\u0011H\u0001\u0002\t!J|Go\\2pY\"A1\b\u0001B\u0001B\u0003%q'A\u0005qe>$xnY8mA!AQ\b\u0001BC\u0002\u0013\u0005a(A\u0006rk\u0016\u0014\u0018p\u0015;sS:<W#A \u0011\u0007-iC\u0004\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003@\u00031\tX/\u001a:z'R\u0014\u0018N\\4!\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0015AE2s_N\u001cHi\\7bS:\u001cun\\6jKN,\u0012!\u0012\t\u0003\u0017\u0019K!a\u0012\u0007\u0003\u000f\t{w\u000e\\3b]\"A\u0011\n\u0001B\u0001B\u0003%Q)A\nde>\u001c8\u000fR8nC&t7i\\8lS\u0016\u001c\b\u0005\u0003\u0005L\u0001\t\u0015\r\u0011\"\u0001M\u0003\u001dAW-\u00193feN,\u0012!\u0014\t\u0004\u001dFcR\"A(\u000b\u0005A\u0013\u0011\u0001B;uS2L!AU(\u0003\u0013!+\u0017\rZ3s\u001b\u0006\u0004\b\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\u0011!,\u0017\rZ3sg\u0002B\u0001B\u0016\u0001\u0003\u0006\u0004%\taV\u0001\u0005E>$\u00170F\u0001Y!\rYQ&\u0017\t\u00035rk\u0011a\u0017\u0006\u0003-\nI!!X.\u0003\u0011\t{G-\u001f)beRD\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001W\u0001\u0006E>$\u0017\u0010\t\u0005\tC\u0002\u0011)\u0019!C\u0001E\u0006i!-Y2lK:$7i\u001c8gS\u001e,\u0012a\u0019\t\u0003)\u0011L!!\u001a\u0002\u0003\u001b\t\u000b7m[3oI\u000e{gNZ5h\u0011!9\u0007A!A!\u0002\u0013\u0019\u0017A\u00042bG.,g\u000eZ\"p]\u001aLw\r\t\u0005\tS\u0002\u0011)\u0019!C\u0001U\u00069A/[7f_V$X#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005Ad\u0011AC2p]\u000e,(O]3oi&\u0011!/\u001c\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011!!\bA!A!\u0002\u0013Y\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\t\u000bY\u0004A\u0011B<\u0002\rqJg.\u001b;?)AA\u0018P_>}{z|\u0018\u0011AA\u0002\u0003\u000b\t9\u0001\u0005\u0002\u0015\u0001!)\u0011#\u001ea\u0001'!)!$\u001ea\u00019!)a%\u001ea\u00019!)!&\u001ea\u0001Y!)Q'\u001ea\u0001o!)Q(\u001ea\u0001\u007f!)1)\u001ea\u0001\u000b\")1*\u001ea\u0001\u001b\")a+\u001ea\u00011\")\u0011-\u001ea\u0001G\")\u0011.\u001ea\u0001W\"I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011QB\u0001\tY>tw\rU1uQV\u0011\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006L1!IA\n\u0011!\ty\u0002\u0001Q\u0001\n\u0005=\u0011!\u00037p]\u001e\u0004\u0016\r\u001e5!\u0011!\t\u0019\u0003\u0001b\u0001\n\u0003Y\u0012aA;sY\"9\u0011q\u0005\u0001!\u0002\u0013a\u0012\u0001B;sY\u0002Bq!a\u000b\u0001\t\u0003\ti#\u0001\u0006xSRDW*\u001a;i_\u0012$2\u0001_A\u0018\u0011\u0019\t\u0012\u0011\u0006a\u0001'!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012\u0001C<ji\"Dun\u001d;\u0015\u0007a\f9\u0004\u0003\u0004\u001b\u0003c\u0001\r\u0001\b\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003!9\u0018\u000e\u001e5QCRDGc\u0001=\u0002@!1a%!\u000fA\u0002qAq!a\u0011\u0001\t\u0003\t)%\u0001\u0005xSRD\u0007k\u001c:u)\rA\u0018q\t\u0005\u0007U\u0005\u0005\u0003\u0019A\u0018\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N\u0005yq/\u001b;i\t\u00164\u0017-\u001e7u!>\u0014H\u000fF\u0001y\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\nAb^5uQB\u0013x\u000e^8d_2$2\u0001_A+\u0011\u0019)\u0014q\na\u0001o!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013aD<ji\"\fV/\u001a:z'R\u0014\u0018N\\4\u0015\u0007a\fi\u0006\u0003\u0004>\u0003/\u0002\r\u0001\b\u0005\b\u0003C\u0002A\u0011AA2\u0003I9\u0018\u000e\u001e5Rk\u0016\u0014\u0018p\u0015;sS:<'+Y<\u0015\u0007a\f)\u0007\u0003\u0004>\u0003?\u0002\r\u0001\b\u0005\b\u0003S\u0002A\u0011AA'\u0003I9\u0018\u000e\u001e5pkR\fV/\u001a:z'R\u0014\u0018N\\4\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005\u0011r/\u001b;i#V,'/\u001f)be\u0006lW\r^3s)\u0015A\u0018\u0011OA;\u0011\u001d\t\u0019(a\u001bA\u0002q\t1a[3z\u0011\u001d\t9(a\u001bA\u0002q\tQA^1mk\u0016Dq!a\u001f\u0001\t\u0003\ti(A\u000bxSRD\u0017+^3ssN+\u0017\u000fU1sC6,G/\u001a:\u0015\u000ba\fy(!!\t\u000f\u0005M\u0014\u0011\u0010a\u00019!A\u00111QA=\u0001\u0004\t))\u0001\u0004wC2,Xm\u001d\t\u0006\u0003\u000f\u000b9\n\b\b\u0005\u0003\u0013\u000b\u0019J\u0004\u0003\u0002\f\u0006EUBAAG\u0015\r\ty\tC\u0001\u0007yI|w\u000e\u001e \n\u00035I1!!&\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!!'\u0002\u001c\n\u00191+Z9\u000b\u0007\u0005UE\u0002C\u0004\u0002 \u0002!\t!!)\u00021]LG\u000f[)vKJLxJ\u00196fGR\u0004\u0016M]1nKR,'\u000fF\u0003y\u0003G\u000b)\u000bC\u0004\u0002t\u0005u\u0005\u0019\u0001\u000f\t\u0011\u0005\r\u0015Q\u0014a\u0001\u0003O\u0003b!a\"\u0002\u0018\u0006%\u0006#B\u0006\u0002,ra\u0012bAAW\u0019\t1A+\u001e9mKJBq!!-\u0001\t\u0003\t\u0019,A\nxSRD\u0017+^3ssB\u000b'/Y7fi\u0016\u00148\u000fF\u0002y\u0003kC\u0001\"a.\u00020\u0002\u0007\u0011\u0011X\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b#B\u0006\u0002<\u0006%\u0016bAA_\u0019\tQAH]3qK\u0006$X\r\u001a \t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\u0006Qq/\u001b;i\u0011\u0016\fG-\u001a:\u0015\u000ba\f)-a2\t\u000f\u0005M\u0014q\u0018a\u00019!9\u0011qOA`\u0001\u0004a\u0002bBAf\u0001\u0011\u0005\u0011QZ\u0001\fo&$\b\u000eS3bI\u0016\u00148\u000fF\u0002y\u0003\u001fD\u0001\"!5\u0002J\u0002\u0007\u0011\u0011X\u0001\u000b]\u0016<\b*Z1eKJ\u001c\bbBAk\u0001\u0011\u0005\u0011q[\u0001\u0017o&$\bn\u0011:pgN$u.\\1j]\u000e{wn[5fgR\u0019\u00010!7\t\u000f\u0005m\u00171\u001ba\u0001\u000b\u00061Ao\\4hY\u0016Dq!a8\u0001\t\u0003\t\t/A\u0006xSRDG+[7f_V$Hc\u0001=\u0002d\"1\u0011.!8A\u0002-Dq!a:\u0001\t\u0003\tI/A\u0004xSRDWK\u0015'\u0015\u0007a\fY\u000fC\u0004\u0002$\u0005\u0015\b\u0019\u0001\u000f\t\u000f\u0005=\b\u0001\"\u0001\u0002r\u0006\tr/\u001b;i\u0005\u0006\u001c7.\u001a8e\u0007>tg-[4\u0015\u0007a\f\u0019\u0010\u0003\u0004b\u0003[\u0004\ra\u0019\u0005\b\u0003o\u0004A\u0011AA}\u0003!9\u0018\u000e\u001e5C_\u0012LHc\u0001=\u0002|\"1a+!>A\u0002eCq!a@\u0001\t\u0013\u0011\t!A\u0003`g\u0016tG-\u0006\u0003\u0003\u0004\tMA\u0003\u0002B\u0003\u0005\u007f!BAa\u0002\u0003,A1!\u0011\u0002B\u0006\u0005\u001fi\u0011a\\\u0005\u0004\u0005\u001by'A\u0002$viV\u0014X\r\u0005\u0003\u0003\u0012\tMA\u0002\u0001\u0003\t\u0005+\tiP1\u0001\u0003\u0018\t\tA+\u0005\u0003\u0003\u001a\t}\u0001cA\u0006\u0003\u001c%\u0019!Q\u0004\u0007\u0003\u000f9{G\u000f[5oOB!!\u0011\u0005B\u0014\u001b\t\u0011\u0019CC\u0002\u0003&\t\t\u0001B]3ta>t7/Z\u0005\u0005\u0005S\u0011\u0019C\u0001\u0007IiR\u0004(+Z:q_:\u001cX\r\u0003\u0005\u0003.\u0005u\b9\u0001B\u0018\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u00032\tmRB\u0001B\u001a\u0015\u0011\u0011)Da\u000e\u0002\u0013\u0015DXmY;uS>t'B\u0001B\u001d\u0003\u0015iwN\\5y\u0013\u0011\u0011iDa\r\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002\u0003B!\u0003{\u0004\rAa\u0011\u0002\u000f\u0019\f7\r^8ssB1!\u0011\u0005B#\u0005\u001fIAAa\u0012\u0003$\t\u0019\u0002\n\u001e;q%\u0016\u001c\bo\u001c8tK\u001a\u000b7\r^8ss\"9!1\n\u0001\u0005\u0002\t5\u0013AB:ue\u0016\fW\u000e\u0006\u0002\u0003PQ!!\u0011\u000bB-!\u0019\u0011IAa\u0003\u0003TA!!\u0011\u0005B+\u0013\u0011\u00119Fa\t\u0003%M#(/Z1n\u0011R$\bOU3ta>t7/\u001a\u0005\t\u0005[\u0011I\u0005q\u0001\u00030!9!Q\f\u0001\u0005\u0002\t}\u0013\u0001B:f]\u0012$\"A!\u0019\u0015\t\t\r$1\u000e\t\u0007\u0005\u0013\u0011YA!\u001a\u0011\t\t\u0005\"qM\u0005\u0005\u0005S\u0012\u0019C\u0001\nTS6\u0004H.\u001a%uiB\u0014Vm\u001d9p]N,\u0007\u0002\u0003B\u0017\u00057\u0002\u001dAa\f\t\u000f\t=\u0004\u0001\"\u0001\u0003r\u0005\u0019q-\u001a;\u0015\u0005\tMD\u0003\u0002B2\u0005kB\u0001B!\f\u0003n\u0001\u000f!q\u0006\u0005\b\u0005s\u0002A\u0011\u0001B>\u0003\u0011\u0001xn\u001d;\u0015\t\tu$\u0011\u0011\u000b\u0005\u0005G\u0012y\b\u0003\u0005\u0003.\t]\u00049\u0001B\u0018\u0011\u00191&q\u000fa\u00013\"9!Q\u0011\u0001\u0005\u0002\t\u001d\u0015a\u00019viR!!\u0011\u0012BG)\u0011\u0011\u0019Ga#\t\u0011\t5\"1\u0011a\u0002\u0005_AaA\u0016BB\u0001\u0004I\u0006b\u0002BI\u0001\u0011\u0005!1S\u0001\b_B$\u0018n\u001c8t)\u0011\u0011)J!'\u0015\t\t\r$q\u0013\u0005\t\u0005[\u0011y\tq\u0001\u00030!1aKa$A\u0002eCqA!\u0018\u0001\t\u0003\u0011i\n\u0006\u0003\u0003 \n\rF\u0003\u0002B2\u0005CC\u0001B!\f\u0003\u001c\u0002\u000f!q\u0006\u0005\u0007-\nm\u0005\u0019A-\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\u0006!1m\u001c9z)]A(1\u0016BW\u0005_\u0013\tLa-\u00036\n]&\u0011\u0018B^\u0005{\u0013y\f\u0003\u0005\u0012\u0005K\u0003\n\u00111\u0001\u0014\u0011!Q\"Q\u0015I\u0001\u0002\u0004a\u0002\u0002\u0003\u0014\u0003&B\u0005\t\u0019\u0001\u000f\t\u0011)\u0012)\u000b%AA\u00021B\u0001\"\u000eBS!\u0003\u0005\ra\u000e\u0005\t{\t\u0015\u0006\u0013!a\u0001\u007f!A1J!*\u0011\u0002\u0003\u0007Q\n\u0003\u0005D\u0005K\u0003\n\u00111\u0001F\u0011!1&Q\u0015I\u0001\u0002\u0004A\u0006\u0002C1\u0003&B\u0005\t\u0019A2\t\u0011%\u0014)\u000b%AA\u0002-D\u0011Ba1\u0001#\u0003%IA!2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u0019\u0016\u0004'\t%7F\u0001Bf!\u0011\u0011iMa6\u000e\u0005\t='\u0002\u0002Bi\u0005'\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tUG\"\u0001\u0006b]:|G/\u0019;j_:LAA!7\u0003P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\tu\u0007!%A\u0005\n\t}\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005CT3\u0001\bBe\u0011%\u0011)\u000fAI\u0001\n\u0013\u0011y.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\t%\b!%A\u0005\n\t-\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005[T3\u0001\fBe\u0011%\u0011\t\u0010AI\u0001\n\u0013\u0011\u00190\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tU(fA\u001c\u0003J\"I!\u0011 \u0001\u0012\u0002\u0013%!1`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iPK\u0002@\u0005\u0013D\u0011b!\u0001\u0001#\u0003%Iaa\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u00111Q\u0001\u0016\u0004\u001b\n%\u0007\"CB\u0005\u0001E\u0005I\u0011BB\u0006\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"a!\u0004+\u0007\u0015\u0013I\rC\u0005\u0004\u0012\u0001\t\n\u0011\"\u0003\u0004\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012JTCAB\u000bU\rA&\u0011\u001a\u0005\n\u00073\u0001\u0011\u0013!C\u0005\u00077\tqbY8qs\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0007;Q3a\u0019Be\u0011%\u0019\t\u0003AI\u0001\n\u0013\u0019\u0019#A\bd_BLH\u0005Z3gCVdG\u000fJ\u00192+\t\u0019)CK\u0002l\u0005\u0013<qa!\u000b\u0003\u0011\u0003\u0019Y#A\u0006IiR\u0004(+Z9vKN$\bc\u0001\u000b\u0004.\u00191\u0011A\u0001E\u0001\u0007_\u00192a!\f\u000b\u0011\u001d18Q\u0006C\u0001\u0007g!\"aa\u000b\t\u0011\r]2Q\u0006C\u0005\u0007s\tq\u0001Z3gCVdG/F\u0001y\u0011!\u0019id!\f\u0005\u0002\u00055\u0013!B1qa2L\b\u0002CB\u001f\u0007[!\ta!\u0011\u0015\u0007a\u001c\u0019\u0005C\u0004\u0002$\r}\u0002\u0019\u0001\u000f")
public final class HttpRequest {
    private final Method method;
    private final String host;
    private final String path;
    private final Option<Object> port;
    private final Protocol protocol;
    private final Option<String> queryString;
    private final boolean crossDomainCookies;
    private final HeaderMap<String> headers;
    private final Option<BodyPart> body;
    private final BackendConfig backendConfig;
    private final FiniteDuration timeout;
    private final String longPath;
    private final String url;

    public static HttpRequest apply(String string) {
        return HttpRequest$.MODULE$.apply(string);
    }

    public static HttpRequest apply() {
        return HttpRequest$.MODULE$.apply();
    }

    public Method method() {
        return this.method;
    }

    public String host() {
        return this.host;
    }

    public String path() {
        return this.path;
    }

    public Option<Object> port() {
        return this.port;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public Option<String> queryString() {
        return this.queryString;
    }

    public boolean crossDomainCookies() {
        return this.crossDomainCookies;
    }

    public HeaderMap<String> headers() {
        return this.headers;
    }

    public Option<BodyPart> body() {
        return this.body;
    }

    public BackendConfig backendConfig() {
        return this.backendConfig;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public String longPath() {
        return this.longPath;
    }

    public String url() {
        return this.url;
    }

    public HttpRequest withMethod(Method method) {
        return this.copy(method, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public HttpRequest withHost(String host) {
        String x$2 = host;
        Method x$3 = this.copy$default$1();
        String x$4 = this.copy$default$3();
        Option<Object> x$5 = this.copy$default$4();
        Protocol x$6 = this.copy$default$5();
        Option<String> x$7 = this.copy$default$6();
        HeaderMap<String> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$8();
        Option<BodyPart> x$10 = this.copy$default$9();
        BackendConfig x$11 = this.copy$default$10();
        FiniteDuration x$12 = this.copy$default$11();
        return this.copy(x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
    }

    public HttpRequest withPath(String path) {
        String x$13 = path;
        Method x$14 = this.copy$default$1();
        String x$15 = this.copy$default$2();
        Option<Object> x$16 = this.copy$default$4();
        Protocol x$17 = this.copy$default$5();
        Option<String> x$18 = this.copy$default$6();
        HeaderMap<String> x$19 = this.copy$default$7();
        boolean x$20 = this.copy$default$8();
        Option<BodyPart> x$21 = this.copy$default$9();
        BackendConfig x$22 = this.copy$default$10();
        FiniteDuration x$23 = this.copy$default$11();
        return this.copy(x$14, x$15, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23);
    }

    public HttpRequest withPort(int port) {
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)port));
        Method x$25 = this.copy$default$1();
        String x$26 = this.copy$default$2();
        String x$27 = this.copy$default$3();
        Protocol x$28 = this.copy$default$5();
        Option<String> x$29 = this.copy$default$6();
        HeaderMap<String> x$30 = this.copy$default$7();
        boolean x$31 = this.copy$default$8();
        Option<BodyPart> x$32 = this.copy$default$9();
        BackendConfig x$33 = this.copy$default$10();
        FiniteDuration x$34 = this.copy$default$11();
        return this.copy(x$25, x$26, x$27, (Option<Object>)x$24, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
    }

    public HttpRequest withDefaultPort() {
        None$ x$35 = None$.MODULE$;
        Method x$36 = this.copy$default$1();
        String x$37 = this.copy$default$2();
        String x$38 = this.copy$default$3();
        Protocol x$39 = this.copy$default$5();
        Option<String> x$40 = this.copy$default$6();
        HeaderMap<String> x$41 = this.copy$default$7();
        boolean x$42 = this.copy$default$8();
        Option<BodyPart> x$43 = this.copy$default$9();
        BackendConfig x$44 = this.copy$default$10();
        FiniteDuration x$45 = this.copy$default$11();
        return this.copy(x$36, x$37, x$38, (Option<Object>)x$35, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
    }

    public HttpRequest withProtocol(Protocol protocol) {
        Protocol x$46 = protocol;
        Method x$47 = this.copy$default$1();
        String x$48 = this.copy$default$2();
        String x$49 = this.copy$default$3();
        Option<Object> x$50 = this.copy$default$4();
        Option<String> x$51 = this.copy$default$6();
        HeaderMap<String> x$52 = this.copy$default$7();
        boolean x$53 = this.copy$default$8();
        Option<BodyPart> x$54 = this.copy$default$9();
        BackendConfig x$55 = this.copy$default$10();
        FiniteDuration x$56 = this.copy$default$11();
        return this.copy(x$47, x$48, x$49, x$50, x$46, x$51, x$52, x$53, x$54, x$55, x$56);
    }

    public HttpRequest withQueryString(String queryString) {
        Some x$57 = new Some((Object)Utils$.MODULE$.encodeQueryString(queryString));
        Method x$58 = this.copy$default$1();
        String x$59 = this.copy$default$2();
        String x$60 = this.copy$default$3();
        Option<Object> x$61 = this.copy$default$4();
        Protocol x$62 = this.copy$default$5();
        HeaderMap<String> x$63 = this.copy$default$7();
        boolean x$64 = this.copy$default$8();
        Option<BodyPart> x$65 = this.copy$default$9();
        BackendConfig x$66 = this.copy$default$10();
        FiniteDuration x$67 = this.copy$default$11();
        return this.copy(x$58, x$59, x$60, x$61, x$62, (Option<String>)x$57, x$63, x$64, x$65, x$66, x$67);
    }

    public HttpRequest withQueryStringRaw(String queryString) {
        Some x$68 = new Some((Object)queryString);
        Method x$69 = this.copy$default$1();
        String x$70 = this.copy$default$2();
        String x$71 = this.copy$default$3();
        Option<Object> x$72 = this.copy$default$4();
        Protocol x$73 = this.copy$default$5();
        HeaderMap<String> x$74 = this.copy$default$7();
        boolean x$75 = this.copy$default$8();
        Option<BodyPart> x$76 = this.copy$default$9();
        BackendConfig x$77 = this.copy$default$10();
        FiniteDuration x$78 = this.copy$default$11();
        return this.copy(x$69, x$70, x$71, x$72, x$73, (Option<String>)x$68, x$74, x$75, x$76, x$77, x$78);
    }

    public HttpRequest withoutQueryString() {
        None$ x$79 = None$.MODULE$;
        Method x$80 = this.copy$default$1();
        String x$81 = this.copy$default$2();
        String x$82 = this.copy$default$3();
        Option<Object> x$83 = this.copy$default$4();
        Protocol x$84 = this.copy$default$5();
        HeaderMap<String> x$85 = this.copy$default$7();
        boolean x$86 = this.copy$default$8();
        Option<BodyPart> x$87 = this.copy$default$9();
        BackendConfig x$88 = this.copy$default$10();
        FiniteDuration x$89 = this.copy$default$11();
        return this.copy(x$80, x$81, x$82, x$83, x$84, (Option<String>)x$79, x$85, x$86, x$87, x$88, x$89);
    }

    public HttpRequest withQueryParameter(String key, String value) {
        Some x$90 = new Some((Object)new StringBuilder().append((Object)((String)this.queryString().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String q) {
                return new StringBuilder().append((Object)q).append((Object)BoxesRunTime.boxToCharacter((char)'&')).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))).append((Object)CrossPlatformUtils$.MODULE$.encodeURIComponent(key)).append((Object)"=").append((Object)CrossPlatformUtils$.MODULE$.encodeURIComponent(value)).toString());
        Method x$91 = this.copy$default$1();
        String x$92 = this.copy$default$2();
        String x$93 = this.copy$default$3();
        Option<Object> x$94 = this.copy$default$4();
        Protocol x$95 = this.copy$default$5();
        HeaderMap<String> x$96 = this.copy$default$7();
        boolean x$97 = this.copy$default$8();
        Option<BodyPart> x$98 = this.copy$default$9();
        BackendConfig x$99 = this.copy$default$10();
        FiniteDuration x$100 = this.copy$default$11();
        return this.copy(x$91, x$92, x$93, x$94, x$95, (Option<String>)x$90, x$96, x$97, x$98, x$99, x$100);
    }

    public HttpRequest withQuerySeqParameter(String key, Seq<String> values) {
        return (HttpRequest)values.foldLeft((Object)this, (Function2)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final String key$1;

            public final HttpRequest apply(HttpRequest acc, String value) {
                return acc.withQueryParameter(this.key$1, value);
            }
            {
                this.key$1 = key$1;
            }
        });
    }

    public HttpRequest withQueryObjectParameter(String key, Seq<Tuple2<String, String>> values) {
        return this.withQueryParameters((Seq<Tuple2<String, String>>)((Seq)values.map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final String key$2;

            public final Tuple2<String, String> apply(Tuple2<String, String> p) {
                return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$2, p._1()})), p._2());
            }
            {
                this.key$2 = key$2;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public HttpRequest withQueryParameters(Seq<Tuple2<String, String>> parameters) {
        return (HttpRequest)parameters.foldLeft((Object)this, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final HttpRequest apply(HttpRequest acc, Tuple2<String, String> entry) {
                return acc.withQueryParameter((String)entry._1(), (String)entry._2());
            }
        });
    }

    public HttpRequest withHeader(String key, String value) {
        HeaderMap<String> x$101 = HeaderMap$.MODULE$.apply((Map<String, String>)this.headers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        Method x$102 = this.copy$default$1();
        String x$103 = this.copy$default$2();
        String x$104 = this.copy$default$3();
        Option<Object> x$105 = this.copy$default$4();
        Protocol x$106 = this.copy$default$5();
        Option<String> x$107 = this.copy$default$6();
        boolean x$108 = this.copy$default$8();
        Option<BodyPart> x$109 = this.copy$default$9();
        BackendConfig x$110 = this.copy$default$10();
        FiniteDuration x$111 = this.copy$default$11();
        return this.copy(x$102, x$103, x$104, x$105, x$106, x$107, x$101, x$108, x$109, x$110, x$111);
    }

    public HttpRequest withHeaders(Seq<Tuple2<String, String>> newHeaders) {
        HeaderMap<String> x$112 = HeaderMap$.MODULE$.apply(this.headers().$plus$plus(newHeaders));
        Method x$113 = this.copy$default$1();
        String x$114 = this.copy$default$2();
        String x$115 = this.copy$default$3();
        Option<Object> x$116 = this.copy$default$4();
        Protocol x$117 = this.copy$default$5();
        Option<String> x$118 = this.copy$default$6();
        boolean x$119 = this.copy$default$8();
        Option<BodyPart> x$120 = this.copy$default$9();
        BackendConfig x$121 = this.copy$default$10();
        FiniteDuration x$122 = this.copy$default$11();
        return this.copy(x$113, x$114, x$115, x$116, x$117, x$118, x$112, x$119, x$120, x$121, x$122);
    }

    public HttpRequest withCrossDomainCookies(boolean toggle) {
        boolean x$123 = toggle;
        Method x$124 = this.copy$default$1();
        String x$125 = this.copy$default$2();
        String x$126 = this.copy$default$3();
        Option<Object> x$127 = this.copy$default$4();
        Protocol x$128 = this.copy$default$5();
        Option<String> x$129 = this.copy$default$6();
        HeaderMap<String> x$130 = this.copy$default$7();
        Option<BodyPart> x$131 = this.copy$default$9();
        BackendConfig x$132 = this.copy$default$10();
        FiniteDuration x$133 = this.copy$default$11();
        return this.copy(x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$123, x$131, x$132, x$133);
    }

    public HttpRequest withTimeout(FiniteDuration timeout) {
        FiniteDuration x$134 = timeout;
        Method x$135 = this.copy$default$1();
        String x$136 = this.copy$default$2();
        String x$137 = this.copy$default$3();
        Option<Object> x$138 = this.copy$default$4();
        Protocol x$139 = this.copy$default$5();
        Option<String> x$140 = this.copy$default$6();
        HeaderMap<String> x$141 = this.copy$default$7();
        boolean x$142 = this.copy$default$8();
        Option<BodyPart> x$143 = this.copy$default$9();
        BackendConfig x$144 = this.copy$default$10();
        return this.copy(x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$134);
    }

    public HttpRequest withURL(String url) {
        URI parser = new URI(url);
        Protocol x$145 = parser.getScheme() == null ? this.protocol() : Protocol$.MODULE$.fromString(parser.getScheme());
        String x$146 = parser.getHost() == null ? this.host() : parser.getHost();
        Some x$147 = parser.getPort() != -1 ? new Some((Object)BoxesRunTime.boxToInteger((int)parser.getPort())) : this.port();
        String x$148 = parser.getPath() == null ? this.path() : parser.getPath();
        Some x$149 = parser.getQuery() == null ? this.queryString() : new Some((Object)Utils$.MODULE$.encodeQueryString(parser.getQuery()));
        Method x$150 = this.copy$default$1();
        HeaderMap<String> x$151 = this.copy$default$7();
        boolean x$152 = this.copy$default$8();
        Option<BodyPart> x$153 = this.copy$default$9();
        BackendConfig x$154 = this.copy$default$10();
        FiniteDuration x$155 = this.copy$default$11();
        return this.copy(x$150, x$146, x$148, (Option<Object>)x$147, x$145, (Option<String>)x$149, x$151, x$152, x$153, x$154, x$155);
    }

    public HttpRequest withBackendConfig(BackendConfig backendConfig) {
        BackendConfig x$156 = backendConfig;
        Method x$157 = this.copy$default$1();
        String x$158 = this.copy$default$2();
        String x$159 = this.copy$default$3();
        Option<Object> x$160 = this.copy$default$4();
        Protocol x$161 = this.copy$default$5();
        Option<String> x$162 = this.copy$default$6();
        HeaderMap<String> x$163 = this.copy$default$7();
        boolean x$164 = this.copy$default$8();
        Option<BodyPart> x$165 = this.copy$default$9();
        FiniteDuration x$166 = this.copy$default$11();
        return this.copy(x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$156, x$166);
    }

    public HttpRequest withBody(BodyPart body) {
        HttpRequest qual$1 = this.withHeader("Content-Type", body.contentType());
        Some x$167 = new Some((Object)body);
        Method x$168 = qual$1.copy$default$1();
        String x$169 = qual$1.copy$default$2();
        String x$170 = qual$1.copy$default$3();
        Option<Object> x$171 = qual$1.copy$default$4();
        Protocol x$172 = qual$1.copy$default$5();
        Option<String> x$173 = qual$1.copy$default$6();
        HeaderMap<String> x$174 = qual$1.copy$default$7();
        boolean x$175 = qual$1.copy$default$8();
        BackendConfig x$176 = qual$1.copy$default$10();
        FiniteDuration x$177 = qual$1.copy$default$11();
        return qual$1.copy(x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, (Option<BodyPart>)x$167, x$176, x$177);
    }

    private <T extends HttpResponse> Future<T> _send(HttpResponseFactory<T> factory, Scheduler scheduler) {
        Promise promise = Promise$.MODULE$.apply();
        Cancelable timeoutTask = scheduler.scheduleOnce(this.timeout().length(), this.timeout().unit(), new Runnable(this, promise){
            private final Promise promise$1;

            public void run() {
                this.promise$1.tryFailure((Throwable)new TimeoutException(TimeoutException$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.promise$1 = promise$1;
            }
        });
        Future<T> backendFuture = HttpDriver$.MODULE$.send(this, factory, scheduler);
        backendFuture.onComplete((Function1)new Serializable(this, promise, timeoutTask){
            public static final long serialVersionUID = 0L;
            private final Promise promise$1;
            private final Cancelable timeoutTask$1;

            public final boolean apply(Try<T> response) {
                this.timeoutTask$1.cancel();
                return this.promise$1.tryComplete(response);
            }
            {
                this.promise$1 = promise$1;
                this.timeoutTask$1 = timeoutTask$1;
            }
        }, (ExecutionContext)scheduler);
        return promise.future();
    }

    public Future<StreamHttpResponse> stream(Scheduler scheduler) {
        return this._send(StreamHttpResponse$.MODULE$, scheduler);
    }

    public Future<SimpleHttpResponse> send(Scheduler scheduler) {
        return this._send(SimpleHttpResponse$.MODULE$, scheduler);
    }

    public Future<SimpleHttpResponse> get(Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.GET()).send(scheduler);
    }

    public Future<SimpleHttpResponse> post(BodyPart body, Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.POST()).send(body, scheduler);
    }

    public Future<SimpleHttpResponse> put(BodyPart body, Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.PUT()).send(body, scheduler);
    }

    public Future<SimpleHttpResponse> options(BodyPart body, Scheduler scheduler) {
        return this.withMethod(Method$.MODULE$.OPTIONS()).send(body, scheduler);
    }

    public Future<SimpleHttpResponse> send(BodyPart body, Scheduler scheduler) {
        return this.withBody(body).send(scheduler);
    }

    private HttpRequest copy(Method method, String host, String path, Option<Object> port, Protocol protocol, Option<String> queryString, HeaderMap<String> headers, boolean crossDomainCookies, Option<BodyPart> body, BackendConfig backendConfig, FiniteDuration timeout) {
        return new HttpRequest(method, host, path, port, protocol, queryString, crossDomainCookies, headers, body, backendConfig, timeout);
    }

    private Method copy$default$1() {
        return this.method();
    }

    private String copy$default$2() {
        return this.host();
    }

    private String copy$default$3() {
        return this.path();
    }

    private Option<Object> copy$default$4() {
        return this.port();
    }

    private Protocol copy$default$5() {
        return this.protocol();
    }

    private Option<String> copy$default$6() {
        return this.queryString();
    }

    private HeaderMap<String> copy$default$7() {
        return this.headers();
    }

    private boolean copy$default$8() {
        return this.crossDomainCookies();
    }

    private Option<BodyPart> copy$default$9() {
        return this.body();
    }

    private BackendConfig copy$default$10() {
        return this.backendConfig();
    }

    private FiniteDuration copy$default$11() {
        return this.timeout();
    }

    public HttpRequest(Method method, String host, String path, Option<Object> port, Protocol protocol, Option<String> queryString, boolean crossDomainCookies, HeaderMap<String> headers, Option<BodyPart> body, BackendConfig backendConfig, FiniteDuration timeout) {
        this.method = method;
        this.host = host;
        this.path = path;
        this.port = port;
        this.protocol = protocol;
        this.queryString = queryString;
        this.crossDomainCookies = crossDomainCookies;
        this.headers = headers;
        this.body = body;
        this.backendConfig = backendConfig;
        this.timeout = timeout;
        this.longPath = new StringBuilder().append((Object)path).append(queryString.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String q) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"?", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{q}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
        this.url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol, host, port.fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$1) {
                return new StringBuilder().append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
            }
        }), this.longPath()}));
    }
}

