/*
 * Decompiled with CFR 0.152.
 */
package fr.hhdev.ocelot.spring;

import fr.hhdev.ocelot.spi.DataServiceException;
import fr.hhdev.ocelot.spi.DataServiceResolver;
import fr.hhdev.ocelot.spi.IDataServiceResolver;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;

@DataServiceResolver(value="SPRING")
public class SpringResolver
implements IDataServiceResolver {
    private static final Logger logger = LoggerFactory.getLogger(SpringResolver.class);
    @Inject
    private ApplicationContext applicationContext;

    public <T> T resolveDataService(Class<T> clazz) throws DataServiceException {
        Map beansOfType = this.applicationContext.getBeansOfType(clazz);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new DataServiceException("Unable to find any Spring bean of type : " + clazz.getName());
        }
        if (beansOfType.size() > 1) {
            throw new DataServiceException("Multiple (" + beansOfType.size() + ") Spring beans of type : '" + clazz.getName() + "' founded. Unable to choose one.");
        }
        return clazz.cast(beansOfType.values().iterator().next());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public fr.hhdev.ocelot.spi.Scope getScope(Class clazz) {
        for (Annotation anno : clazz.getAnnotations()) {
            Scope springScopeAnno;
            if (anno.annotationType().getName().equals("fr.hhdev.ocelot.annotations.DataService") || !anno.annotationType().equals(Scope.class) || !(springScopeAnno = (Scope)anno).value().contains("session")) continue;
            return fr.hhdev.ocelot.spi.Scope.SESSION;
        }
        if (!this.applicationContext.isPrototype(clazz.getName()) && !this.applicationContext.isSingleton(clazz.getName())) {
            return fr.hhdev.ocelot.spi.Scope.SESSION;
        }
        return fr.hhdev.ocelot.spi.Scope.MANAGED;
    }
}

